/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.dto;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.commons.schema.ConfigSchema;
import org.apache.nifi.minifi.commons.schema.ConnectionSchema;
import org.apache.nifi.minifi.commons.schema.ControllerServiceSchema;
import org.apache.nifi.minifi.commons.schema.ProcessorSchema;
import org.apache.nifi.minifi.commons.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithId;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;
import org.apache.nifi.minifi.commons.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.configuration.dto.ConnectionSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.ControllerServiceSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.FlowControllerSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.FunnelSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.PortSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.ProcessorSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.RemotePortSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.dto.RemoteProcessGroupSchemaFunction;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class ConfigSchemaFunction
implements Function<TemplateDTO, ConfigSchema> {
    private final FlowControllerSchemaFunction flowControllerSchemaFunction;
    private final ProcessorSchemaFunction processorSchemaFunction;
    private final ControllerServiceSchemaFunction controllerServiceSchemaFunction;
    private final ConnectionSchemaFunction connectionSchemaFunction;
    private final FunnelSchemaFunction funnelSchemaFunction;
    private final RemoteProcessGroupSchemaFunction remoteProcessGroupSchemaFunction;
    private final PortSchemaFunction inputPortSchemaFunction;
    private final PortSchemaFunction outputPortSchemaFunction;

    public ConfigSchemaFunction() {
        this(new FlowControllerSchemaFunction(), new ProcessorSchemaFunction(), new ConnectionSchemaFunction(), new FunnelSchemaFunction(), new RemoteProcessGroupSchemaFunction(new RemotePortSchemaFunction()), new PortSchemaFunction("Input Ports"), new PortSchemaFunction("Output Ports"), new ControllerServiceSchemaFunction());
    }

    public ConfigSchemaFunction(FlowControllerSchemaFunction flowControllerSchemaFunction, ProcessorSchemaFunction processorSchemaFunction, ConnectionSchemaFunction connectionSchemaFunction, FunnelSchemaFunction funnelSchemaFunction, RemoteProcessGroupSchemaFunction remoteProcessGroupSchemaFunction, PortSchemaFunction inputPortSchemaFunction, PortSchemaFunction outputPortSchemaFunction, ControllerServiceSchemaFunction controllerServiceSchemaFunction) {
        this.flowControllerSchemaFunction = flowControllerSchemaFunction;
        this.processorSchemaFunction = processorSchemaFunction;
        this.connectionSchemaFunction = connectionSchemaFunction;
        this.funnelSchemaFunction = funnelSchemaFunction;
        this.remoteProcessGroupSchemaFunction = remoteProcessGroupSchemaFunction;
        this.inputPortSchemaFunction = inputPortSchemaFunction;
        this.outputPortSchemaFunction = outputPortSchemaFunction;
        this.controllerServiceSchemaFunction = controllerServiceSchemaFunction;
    }

    @Override
    public ConfigSchema apply(TemplateDTO templateDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Flow Controller", this.flowControllerSchemaFunction.apply(templateDTO).toMap());
        FlowSnippetDTO snippet = templateDTO.getSnippet();
        this.addSnippet(map, snippet);
        return new ConfigSchema(map);
    }

    protected void addSnippet(Map<String, Object> map, FlowSnippetDTO snippet) {
        this.addSnippet(map, null, null, snippet);
    }

    protected Map<String, Object> addSnippet(Map<String, Object> map, String id, String name, FlowSnippetDTO snippet) {
        if (!StringUtil.isNullOrEmpty((String)id)) {
            map.put("id", id);
        }
        if (!StringUtil.isNullOrEmpty((String)name)) {
            map.put("name", name);
        }
        map.put("Processors", CollectionUtil.nullToEmpty((Set)snippet.getProcessors()).stream().map(this.processorSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(ProcessorSchema::toMap).collect(Collectors.toList()));
        map.put("Controller Services", CollectionUtil.nullToEmpty((Set)snippet.getControllerServices()).stream().map(this.controllerServiceSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(ControllerServiceSchema::toMap).collect(Collectors.toList()));
        map.put("Connections", CollectionUtil.nullToEmpty((Set)snippet.getConnections()).stream().map(this.connectionSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(ConnectionSchema::toMap).collect(Collectors.toList()));
        map.put("Funnels", CollectionUtil.nullToEmpty((Set)snippet.getFunnels()).stream().map(this.funnelSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithId::getId)).map(BaseSchemaWithId::toMap).collect(Collectors.toList()));
        map.put("Remote Process Groups", CollectionUtil.nullToEmpty((Set)snippet.getRemoteProcessGroups()).stream().map(this.remoteProcessGroupSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(RemoteProcessGroupSchema::toMap).collect(Collectors.toList()));
        map.put("Input Ports", CollectionUtil.nullToEmpty((Set)snippet.getInputPorts()).stream().map(this.inputPortSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(BaseSchemaWithIdAndName::toMap).collect(Collectors.toList()));
        map.put("Output Ports", CollectionUtil.nullToEmpty((Set)snippet.getOutputPorts()).stream().map(this.outputPortSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(BaseSchemaWithIdAndName::toMap).collect(Collectors.toList()));
        map.put("Process Groups", CollectionUtil.nullToEmpty((Set)snippet.getProcessGroups()).stream().map(p -> this.addSnippet(new HashMap<String, Object>(), p.getId(), p.getName(), p.getContents())).collect(Collectors.toList()));
        return map;
    }
}

