/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.registry;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.minifi.commons.schema.RemotePortSchema;
import org.apache.nifi.minifi.commons.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegRemotePortSchemaFunction;

public class NiFiRegRemoteProcessGroupSchemaFunction
implements Function<VersionedRemoteProcessGroup, RemoteProcessGroupSchema> {
    private final NiFiRegRemotePortSchemaFunction remotePortSchemaFunction;

    public NiFiRegRemoteProcessGroupSchemaFunction(NiFiRegRemotePortSchemaFunction remotePortSchemaFunction) {
        this.remotePortSchemaFunction = remotePortSchemaFunction;
    }

    @Override
    public RemoteProcessGroupSchema apply(VersionedRemoteProcessGroup versionedRemoteProcessGroup) {
        Set outputPorts;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", versionedRemoteProcessGroup.getIdentifier());
        map.put("name", versionedRemoteProcessGroup.getName());
        map.put("url", versionedRemoteProcessGroup.getTargetUri());
        Set inputPorts = versionedRemoteProcessGroup.getInputPorts();
        if (inputPorts != null) {
            map.put("Input Ports", inputPorts.stream().map(this.remotePortSchemaFunction).map(RemotePortSchema::toMap).collect(Collectors.toList()));
        }
        if ((outputPorts = versionedRemoteProcessGroup.getOutputPorts()) != null) {
            map.put("Output Ports", outputPorts.stream().map(this.remotePortSchemaFunction).map(RemotePortSchema::toMap).collect(Collectors.toList()));
        }
        map.put("comment", versionedRemoteProcessGroup.getComments());
        map.put("timeout", versionedRemoteProcessGroup.getCommunicationsTimeout());
        map.put("yield period", versionedRemoteProcessGroup.getYieldDuration());
        map.put("transport protocol", versionedRemoteProcessGroup.getTransportProtocol());
        map.put("proxy host", versionedRemoteProcessGroup.getProxyHost());
        map.put("proxy port", versionedRemoteProcessGroup.getProxyPort());
        map.put("proxy user", versionedRemoteProcessGroup.getProxyUser());
        map.put("local network interface", versionedRemoteProcessGroup.getLocalNetworkInterface());
        return new RemoteProcessGroupSchema(map);
    }
}

