/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class KeyReleasePolicy
implements JsonSerializable<KeyReleasePolicy> {
    private String contentType;
    private Boolean immutable;
    private Base64Url encodedPolicy;

    public String getContentType() {
        return this.contentType;
    }

    public KeyReleasePolicy setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Boolean isImmutable() {
        return this.immutable;
    }

    public KeyReleasePolicy setImmutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public byte[] getEncodedPolicy() {
        if (this.encodedPolicy == null) {
            return null;
        }
        return this.encodedPolicy.decodedBytes();
    }

    public KeyReleasePolicy setEncodedPolicy(byte[] encodedPolicy) {
        this.encodedPolicy = encodedPolicy == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])encodedPolicy));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeBooleanField("immutable", this.immutable);
        jsonWriter.writeStringField("data", Objects.toString(this.encodedPolicy, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyReleasePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (KeyReleasePolicy)jsonReader.readObject(reader -> {
            KeyReleasePolicy deserializedKeyReleasePolicy = new KeyReleasePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedKeyReleasePolicy.contentType = reader.getString();
                    continue;
                }
                if ("immutable".equals(fieldName)) {
                    deserializedKeyReleasePolicy.immutable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedKeyReleasePolicy.encodedPolicy = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyReleasePolicy;
        });
    }
}

