/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeyHelper;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public class KeyVaultKey
implements JsonSerializable<KeyVaultKey> {
    private final JsonWebKey key;
    final KeyProperties properties;

    KeyVaultKey() {
        this.key = null;
        this.properties = new KeyProperties();
    }

    KeyVaultKey(JsonWebKey jsonWebKey) {
        this.key = jsonWebKey;
        this.properties = new KeyProperties();
    }

    KeyVaultKey(JsonWebKey jsonWebKey, KeyProperties properties) {
        this.key = jsonWebKey;
        this.properties = properties;
    }

    public JsonWebKey getKey() {
        return this.key;
    }

    public KeyProperties getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public KeyType getKeyType() {
        return this.key.getKeyType();
    }

    public List<KeyOperation> getKeyOperations() {
        return this.key.getKeyOps();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeJsonField("key", (JsonSerializable)this.key).writeEndObject();
    }

    public static KeyVaultKey fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultKey)jsonReader.readObject(reader -> {
            JsonWebKey webKey = null;
            KeyProperties properties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    webKey = JsonWebKey.fromJson(reader);
                    KeyVaultKeysUtils.unpackId(webKey.getId(), name -> {
                        properties.name = name;
                    }, version -> {
                        properties.version = version;
                    });
                    continue;
                }
                if ("attributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("enabled".equals(fieldName)) {
                            properties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("exportable".equals(fieldName)) {
                            properties.exportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("nbf".equals(fieldName)) {
                            properties.notBefore = (OffsetDateTime)reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("exp".equals(fieldName)) {
                            properties.expiresOn = (OffsetDateTime)reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("created".equals(fieldName)) {
                            properties.createdOn = (OffsetDateTime)reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("updated".equals(fieldName)) {
                            properties.updatedOn = (OffsetDateTime)reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("recoveryLevel".equals(fieldName)) {
                            properties.recoveryLevel = reader.getString();
                            continue;
                        }
                        if ("recoverableDays".equals(fieldName)) {
                            properties.recoverableDays = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    properties.setTags(reader.readMap(JsonReader::getString));
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    properties.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    properties.setReleasePolicy(KeyReleasePolicy.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyVaultKey(webKey, properties);
        });
    }

    static {
        KeyVaultKeyHelper.setAccessor(KeyVaultKey::new);
    }
}

