/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.configuration.ClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BootstrapPropertiesClientProvider<T>
implements ClientProvider<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BootstrapProperties.BootstrapPropertyKey bootstrapPropertyKey;

    public BootstrapPropertiesClientProvider(BootstrapProperties.BootstrapPropertyKey bootstrapPropertyKey) {
        this.bootstrapPropertyKey = Objects.requireNonNull(bootstrapPropertyKey, "Bootstrap Property Key required");
    }

    @Override
    public Optional<T> getClient(Properties clientProperties) {
        return this.isMissingProperties(clientProperties) ? Optional.empty() : Optional.of(this.getConfiguredClient(clientProperties));
    }

    @Override
    public Optional<Properties> getClientProperties(BootstrapProperties bootstrapProperties) {
        Objects.requireNonNull(bootstrapProperties, "Bootstrap Properties required");
        String clientBootstrapPropertiesPath = bootstrapProperties.getProperty(this.bootstrapPropertyKey).orElse(null);
        if (clientBootstrapPropertiesPath == null || clientBootstrapPropertiesPath.isEmpty()) {
            this.logger.debug("Client Properties [{}] not configured", (Object)this.bootstrapPropertyKey);
            return Optional.empty();
        }
        Path propertiesPath = Paths.get(clientBootstrapPropertiesPath, new String[0]);
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            try {
                Properties clientProperties = new Properties();
                try (InputStream inputStream = Files.newInputStream(propertiesPath, new OpenOption[0]);){
                    clientProperties.load(inputStream);
                }
                return Optional.of(clientProperties);
            }
            catch (IOException e) {
                String message = String.format("Loading Client Properties Failed [%s]", propertiesPath);
                throw new UncheckedIOException(message, e);
            }
        }
        this.logger.debug("Client Properties [{}] Path [{}] not found", (Object)this.bootstrapPropertyKey, (Object)propertiesPath);
        return Optional.empty();
    }

    protected abstract T getConfiguredClient(Properties var1);

    protected abstract Set<String> getRequiredPropertyNames();

    private boolean isMissingProperties(Properties clientProperties) {
        return clientProperties == null || this.getRequiredPropertyNames().stream().anyMatch(propertyName -> {
            String property = clientProperties.getProperty((String)propertyName);
            return property == null || property.isEmpty();
        });
    }
}

