/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.jetty;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.jetty.connector.ApplicationServerConnectorFactory;
import org.apache.nifi.registry.jetty.handler.HandlerProvider;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private static final String APPLICATION_URL_FORMAT = "%s://%s:%d/nifi-registry";
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String HOST_UNSPECIFIED = "0.0.0.0";
    private final NiFiRegistryProperties properties;
    private final Server server;

    public JettyServer(NiFiRegistryProperties properties, HandlerProvider handlerProvider) {
        Objects.requireNonNull(properties, "Properties required");
        Objects.requireNonNull(handlerProvider, "Handler Provider required");
        QueuedThreadPool threadPool = new QueuedThreadPool(properties.getWebThreads());
        threadPool.setName("NiFi Registry Web Server");
        this.properties = properties;
        this.server = new Server((ThreadPool)threadPool);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.server);
        classlist.addBefore(JettyWebXmlConfiguration.class.getName(), new String[]{AnnotationConfiguration.class.getName()});
        try {
            this.configureConnectors();
            Handler handler = handlerProvider.getHandler(properties);
            this.server.setHandler(handler);
        }
        catch (Throwable t) {
            this.shutdown(t);
        }
    }

    private void configureConnectors() {
        ApplicationServerConnectorFactory serverConnectorFactory = new ApplicationServerConnectorFactory(this.server, this.properties);
        ServerConnector serverConnector = serverConnectorFactory.getServerConnector();
        this.server.addConnector((Connector)serverConnector);
    }

    public void start() {
        try {
            List<URI> applicationUrls;
            this.server.start();
            Optional<Throwable> unavailableExceptionFound = Arrays.stream(this.server.getChildHandlers()).filter(handler -> handler instanceof WebAppContext).map(handler -> (WebAppContext)handler).map(WebAppContext::getUnavailableException).filter(Objects::nonNull).findFirst();
            if (unavailableExceptionFound.isPresent()) {
                Throwable unavailableException = unavailableExceptionFound.get();
                this.shutdown(unavailableException);
            }
            if ((applicationUrls = this.getApplicationUrls()).isEmpty()) {
                logger.warn("Started Server without connectors");
            } else {
                for (URI applicationUrl : applicationUrls) {
                    logger.info("Started Server on {}", (Object)applicationUrl);
                }
            }
        }
        catch (Throwable t) {
            this.shutdown(t);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.warn("Server stop failed", (Throwable)e);
        }
    }

    protected List<URI> getApplicationUrls() {
        return Arrays.stream(this.server.getConnectors()).map(connector -> (ServerConnector)connector).map(serverConnector -> {
            SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
            String scheme = sslConnectionFactory == null ? HTTP_SCHEME : HTTPS_SCHEME;
            int port = serverConnector.getLocalPort();
            String connectorHost = serverConnector.getHost();
            String host = (String)StringUtils.defaultIfEmpty((CharSequence)connectorHost, (CharSequence)HOST_UNSPECIFIED);
            return URI.create(String.format(APPLICATION_URL_FORMAT, scheme, host, port));
        }).collect(Collectors.toList());
    }

    private void shutdown(Throwable throwable) {
        System.err.printf("Server start failed: %s%n", throwable.getMessage());
        logger.error("Server start failed", throwable);
        System.exit(1);
    }
}

