/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class Template
implements ComponentAuthorizable {
    private final TemplateDTO dto;
    private volatile ProcessGroup processGroup;

    public Template(TemplateDTO dto) {
        this.dto = dto;
    }

    public String getIdentifier() {
        return this.dto.getId();
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public int hashCode() {
        return 41 + 11 * this.getIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    public TemplateDTO getDetails() {
        return this.dto;
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup = group;
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup;
    }

    public Authorizable getParentAuthorizable() {
        return this.processGroup;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.Template, (String)this.dto.getId(), (String)this.dto.getName());
    }

    public String toString() {
        return "Template[id=" + this.getIdentifier() + "]";
    }
}

