/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.impl.client.nifi.AccessClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ConnectionClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerServicesClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.CountersClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.InputPortClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.OutputPortClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamProviderClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.PoliciesClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessorClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProvenanceClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RemoteProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ReportingTasksClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.SnippetClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.TemplatesClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.TenantsClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.VersionsClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.JerseyNiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.request.BasicAuthRequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.request.BearerTokenRequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.request.ProxiedEntityRequestConfig;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public class NiFiClientFactory
implements ClientFactory<NiFiClient> {
    @Override
    public NiFiClient createClient(Properties properties) throws MissingOptionException {
        Integer timeout;
        String url = properties.getProperty(CommandOption.URL.getLongName());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MissingOptionException("Missing required option '" + CommandOption.URL.getLongName() + "'");
        }
        String connectionTimeout = properties.getProperty(CommandOption.CONNECTION_TIMEOUT.getLongName());
        String readTimeout = properties.getProperty(CommandOption.READ_TIMEOUT.getLongName());
        String keystore = properties.getProperty(CommandOption.KEYSTORE.getLongName());
        String keystoreType = properties.getProperty(CommandOption.KEYSTORE_TYPE.getLongName());
        String keystorePasswd = properties.getProperty(CommandOption.KEYSTORE_PASSWORD.getLongName());
        String keyPasswd = properties.getProperty(CommandOption.KEY_PASSWORD.getLongName());
        String truststore = properties.getProperty(CommandOption.TRUSTSTORE.getLongName());
        String truststoreType = properties.getProperty(CommandOption.TRUSTSTORE_TYPE.getLongName());
        String truststorePasswd = properties.getProperty(CommandOption.TRUSTSTORE_PASSWORD.getLongName());
        String proxiedEntity = properties.getProperty(CommandOption.PROXIED_ENTITY.getLongName());
        String protocol = properties.getProperty(CommandOption.PROTOCOL.getLongName());
        String basicAuthUsername = properties.getProperty(CommandOption.BASIC_AUTH_USER.getLongName());
        String basicAuthPassword = properties.getProperty(CommandOption.BASIC_AUTH_PASSWORD.getLongName());
        String bearerToken = properties.getProperty(CommandOption.BEARER_TOKEN.getLongName());
        boolean secureUrl = url.startsWith("https");
        if (secureUrl && (StringUtils.isBlank((CharSequence)truststore) || StringUtils.isBlank((CharSequence)truststoreType) || StringUtils.isBlank((CharSequence)truststorePasswd))) {
            throw new MissingOptionException(CommandOption.TRUSTSTORE.getLongName() + ", " + CommandOption.TRUSTSTORE_TYPE.getLongName() + ", and " + CommandOption.TRUSTSTORE_PASSWORD.getLongName() + " are required when using an https url");
        }
        if (!(StringUtils.isBlank((CharSequence)proxiedEntity) || StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword))) {
            throw new IllegalStateException(CommandOption.PROXIED_ENTITY.getLongName() + " and basic authentication can not be used together");
        }
        if (!StringUtils.isBlank((CharSequence)proxiedEntity) && !StringUtils.isBlank((CharSequence)bearerToken)) {
            throw new IllegalStateException(CommandOption.PROXIED_ENTITY.getLongName() + " and " + CommandOption.BEARER_TOKEN.getLongName() + " can not be used together");
        }
        if (!(StringUtils.isBlank((CharSequence)bearerToken) || StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword))) {
            throw new IllegalStateException(CommandOption.BEARER_TOKEN.getLongName() + " and basic authentication can not be used together");
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword)) {
            throw new MissingOptionException(CommandOption.BASIC_AUTH_PASSWORD.getLongName() + " is required when specifying " + CommandOption.BASIC_AUTH_USER.getLongName());
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthPassword) && StringUtils.isBlank((CharSequence)basicAuthUsername)) {
            throw new MissingOptionException(CommandOption.BASIC_AUTH_USER.getLongName() + " is required when specifying " + CommandOption.BASIC_AUTH_PASSWORD.getLongName());
        }
        NiFiClientConfig.Builder clientConfigBuilder = new NiFiClientConfig.Builder().baseUrl(url);
        if (secureUrl) {
            if (!StringUtils.isBlank((CharSequence)keystore)) {
                clientConfigBuilder.keystoreFilename(keystore);
            }
            if (!StringUtils.isBlank((CharSequence)keystoreType)) {
                clientConfigBuilder.keystoreType(KeystoreType.valueOf((String)keystoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)keystorePasswd)) {
                clientConfigBuilder.keystorePassword(keystorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)keyPasswd)) {
                clientConfigBuilder.keyPassword(keyPasswd);
            }
            if (!StringUtils.isBlank((CharSequence)truststore)) {
                clientConfigBuilder.truststoreFilename(truststore);
            }
            if (!StringUtils.isBlank((CharSequence)truststoreType)) {
                clientConfigBuilder.truststoreType(KeystoreType.valueOf((String)truststoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)truststorePasswd)) {
                clientConfigBuilder.truststorePassword(truststorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)protocol)) {
                clientConfigBuilder.protocol(protocol);
            }
        }
        if (!StringUtils.isBlank((CharSequence)connectionTimeout)) {
            try {
                timeout = Integer.valueOf(connectionTimeout);
                clientConfigBuilder.connectTimeout(timeout);
            }
            catch (Exception e) {
                throw new MissingOptionException("connectionTimeout has to be an integer");
            }
        }
        if (!StringUtils.isBlank((CharSequence)readTimeout)) {
            try {
                timeout = Integer.valueOf(readTimeout);
                clientConfigBuilder.readTimeout(timeout);
            }
            catch (Exception e) {
                throw new MissingOptionException("readTimeout has to be an integer");
            }
        }
        NiFiClient client = new JerseyNiFiClient.Builder().config(clientConfigBuilder.build()).build();
        if (!StringUtils.isBlank((CharSequence)proxiedEntity)) {
            ProxiedEntityRequestConfig proxiedEntityConfig = new ProxiedEntityRequestConfig(proxiedEntity);
            return new NiFiClientWithRequestConfig(client, proxiedEntityConfig);
        }
        if (!StringUtils.isBlank((CharSequence)bearerToken)) {
            BearerTokenRequestConfig bearerTokenConfig = new BearerTokenRequestConfig(bearerToken);
            return new NiFiClientWithRequestConfig(client, bearerTokenConfig);
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthUsername) && !StringUtils.isBlank((CharSequence)basicAuthPassword)) {
            BasicAuthRequestConfig basicAuthConfig = new BasicAuthRequestConfig(basicAuthUsername, basicAuthPassword);
            return new NiFiClientWithRequestConfig(client, basicAuthConfig);
        }
        return client;
    }

    private static class NiFiClientWithRequestConfig
    implements NiFiClient {
        private final NiFiClient wrappedClient;
        private final RequestConfig requestConfig;

        public NiFiClientWithRequestConfig(NiFiClient wrappedClient, RequestConfig requestConfig) {
            this.wrappedClient = wrappedClient;
            this.requestConfig = Objects.requireNonNull(requestConfig);
        }

        @Override
        public ControllerClient getControllerClient() {
            return this.wrappedClient.getControllerClient(this.requestConfig);
        }

        @Override
        public ControllerClient getControllerClient(RequestConfig requestConfig) {
            return this.wrappedClient.getControllerClient(requestConfig);
        }

        @Override
        public ControllerServicesClient getControllerServicesClient() {
            return this.wrappedClient.getControllerServicesClient(this.requestConfig);
        }

        @Override
        public ControllerServicesClient getControllerServicesClient(RequestConfig requestConfig) {
            return this.wrappedClient.getControllerServicesClient(requestConfig);
        }

        @Override
        public FlowClient getFlowClient() {
            return this.wrappedClient.getFlowClient(this.requestConfig);
        }

        @Override
        public FlowClient getFlowClient(RequestConfig requestConfig) {
            return this.wrappedClient.getFlowClient(requestConfig);
        }

        @Override
        public ProcessGroupClient getProcessGroupClient() {
            return this.wrappedClient.getProcessGroupClient(this.requestConfig);
        }

        @Override
        public ProcessGroupClient getProcessGroupClient(RequestConfig requestConfig) {
            return this.wrappedClient.getProcessGroupClient(requestConfig);
        }

        @Override
        public ProcessorClient getProcessorClient() {
            return this.wrappedClient.getProcessorClient(this.requestConfig);
        }

        @Override
        public ProcessorClient getProcessorClient(RequestConfig requestConfig) {
            return this.wrappedClient.getProcessorClient(requestConfig);
        }

        @Override
        public VersionsClient getVersionsClient() {
            return this.wrappedClient.getVersionsClient(this.requestConfig);
        }

        @Override
        public VersionsClient getVersionsClient(RequestConfig requestConfig) {
            return this.wrappedClient.getVersionsClient(requestConfig);
        }

        @Override
        public TenantsClient getTenantsClient() {
            return this.wrappedClient.getTenantsClient(this.requestConfig);
        }

        @Override
        public TenantsClient getTenantsClient(RequestConfig requestConfig) {
            return this.wrappedClient.getTenantsClient(requestConfig);
        }

        @Override
        public PoliciesClient getPoliciesClient() {
            return this.wrappedClient.getPoliciesClient(this.requestConfig);
        }

        @Override
        public PoliciesClient getPoliciesClient(RequestConfig requestConfig) {
            return this.wrappedClient.getPoliciesClient(requestConfig);
        }

        @Override
        public TemplatesClient getTemplatesClient() {
            return this.wrappedClient.getTemplatesClient(this.requestConfig);
        }

        @Override
        public TemplatesClient getTemplatesClient(RequestConfig requestConfig) {
            return this.wrappedClient.getTemplatesClient(requestConfig);
        }

        @Override
        public ReportingTasksClient getReportingTasksClient() {
            return this.wrappedClient.getReportingTasksClient(this.requestConfig);
        }

        @Override
        public ReportingTasksClient getReportingTasksClient(RequestConfig requestConfig) {
            return this.wrappedClient.getReportingTasksClient(requestConfig);
        }

        @Override
        public ParamProviderClient getParamProviderClient() {
            return this.wrappedClient.getParamProviderClient();
        }

        @Override
        public ParamProviderClient getParamProviderClient(RequestConfig requestConfig) {
            return this.wrappedClient.getParamProviderClient(requestConfig);
        }

        @Override
        public ParamContextClient getParamContextClient() {
            return this.wrappedClient.getParamContextClient(this.requestConfig);
        }

        @Override
        public ParamContextClient getParamContextClient(RequestConfig requestConfig) {
            return this.wrappedClient.getParamContextClient(requestConfig);
        }

        @Override
        public CountersClient getCountersClient() {
            return this.wrappedClient.getCountersClient(this.requestConfig);
        }

        @Override
        public CountersClient getCountersClient(RequestConfig requestConfig) {
            return this.wrappedClient.getCountersClient(requestConfig);
        }

        @Override
        public ConnectionClient getConnectionClient() {
            return this.wrappedClient.getConnectionClient(this.requestConfig);
        }

        @Override
        public ConnectionClient getConnectionClient(RequestConfig requestConfig) {
            return this.wrappedClient.getConnectionClient(requestConfig);
        }

        @Override
        public RemoteProcessGroupClient getRemoteProcessGroupClient() {
            return this.wrappedClient.getRemoteProcessGroupClient(this.requestConfig);
        }

        @Override
        public RemoteProcessGroupClient getRemoteProcessGroupClient(RequestConfig requestConfig) {
            return this.wrappedClient.getRemoteProcessGroupClient(requestConfig);
        }

        @Override
        public InputPortClient getInputPortClient() {
            return this.wrappedClient.getInputPortClient(this.requestConfig);
        }

        @Override
        public InputPortClient getInputPortClient(RequestConfig requestConfig) {
            return this.wrappedClient.getInputPortClient(requestConfig);
        }

        @Override
        public OutputPortClient getOutputPortClient() {
            return this.wrappedClient.getOutputPortClient(this.requestConfig);
        }

        @Override
        public OutputPortClient getOutputPortClient(RequestConfig requestConfig) {
            return this.wrappedClient.getOutputPortClient(requestConfig);
        }

        @Override
        public ProvenanceClient getProvenanceClient() {
            return this.wrappedClient.getProvenanceClient(this.requestConfig);
        }

        @Override
        public ProvenanceClient getProvenanceClient(RequestConfig requestConfig) {
            return this.wrappedClient.getProvenanceClient(requestConfig);
        }

        @Override
        public AccessClient getAccessClient() {
            return this.wrappedClient.getAccessClient();
        }

        @Override
        public SnippetClient getSnippetClient() {
            return this.wrappedClient.getSnippetClient();
        }

        @Override
        public SnippetClient getSnippetClient(RequestConfig requestConfig) {
            return this.wrappedClient.getSnippetClient(requestConfig);
        }

        @Override
        public void close() throws IOException {
            this.wrappedClient.close();
        }
    }
}

