/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.session;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.SessionException;
import org.apache.nifi.toolkit.cli.impl.command.AbstractCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class SetVariable
extends AbstractCommand<VoidResult> {
    public static final String NAME = "set";

    public SetVariable() {
        super(NAME, VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Sets the given variable in the session. Use the 'keys' command to show the variable names that are supported.";
    }

    @Override
    public VoidResult execute(CommandLine commandLine) throws CommandException {
        String[] args = commandLine.getArgs();
        if (args == null || args.length < 2 || StringUtils.isBlank((CharSequence)args[0]) || StringUtils.isBlank((CharSequence)args[1])) {
            throw new CommandException("Incorrect number of arguments, should be: <var> <value>");
        }
        try {
            this.getContext().getSession().set(args[0], args[1]);
            return VoidResult.getInstance();
        }
        catch (SessionException se) {
            throw new CommandException(se.getMessage(), se);
        }
    }
}

