/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.apache.nifi.security.kms.StaticKeyProvider;
import org.apache.nifi.security.kms.reader.KeyReaderException;

public class KeyStoreKeyProvider
extends StaticKeyProvider {
    public KeyStoreKeyProvider(KeyStore keyStore, char[] keyPassword) {
        super(KeyStoreKeyProvider.readSecretKeys(Objects.requireNonNull(keyStore, "KeyStore required"), Objects.requireNonNull(keyPassword, "Password required")));
    }

    private static Map<String, SecretKey> readSecretKeys(KeyStore keyStore, char[] keyPassword) throws KeyReaderException {
        HashMap<String, SecretKey> secretKeys = new HashMap<String, SecretKey>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Key key = keyStore.getKey(alias, keyPassword);
                if (!(key instanceof SecretKey)) continue;
                SecretKey secretKey = (SecretKey)key;
                secretKeys.put(alias, secretKey);
            }
        }
        catch (GeneralSecurityException e) {
            throw new KeyReaderException("Reading KeyStore failed", e);
        }
        return secretKeys;
    }
}

