/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lineage;

import java.util.Objects;
import org.apache.nifi.provenance.lineage.LineageNode;
import org.apache.nifi.provenance.lineage.LineageNodeType;

public class FlowFileNode
implements LineageNode {
    private final String flowFileUuid;
    private final long creationTime;

    public FlowFileNode(String flowFileUuid, long flowFileCreationTime) {
        this.flowFileUuid = Objects.requireNonNull(flowFileUuid);
        this.creationTime = flowFileCreationTime;
    }

    public String getIdentifier() {
        return this.flowFileUuid;
    }

    public long getTimestamp() {
        return this.creationTime;
    }

    public LineageNodeType getNodeType() {
        return LineageNodeType.FLOWFILE_NODE;
    }

    public String getFlowFileUuid() {
        return this.flowFileUuid;
    }

    public int hashCode() {
        return 23498723 + this.flowFileUuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlowFileNode)) {
            return false;
        }
        FlowFileNode other = (FlowFileNode)obj;
        return this.flowFileUuid.equals(other.flowFileUuid);
    }

    public String toString() {
        return "FlowFile[UUID=" + this.flowFileUuid + "]";
    }
}

