/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.str.CharSink;

public abstract class AbstractDataFrameCursorFactory
implements DataFrameCursorFactory {
    private final GenericRecordMetadata metadata;
    private final TableToken tableToken;
    private final long tableVersion;

    public AbstractDataFrameCursorFactory(TableToken tableToken, long tableVersion, GenericRecordMetadata metadata) {
        this.tableToken = tableToken;
        this.tableVersion = tableVersion;
        this.metadata = metadata;
    }

    @Override
    public void close() {
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean supportTableRowId(TableToken tableToken) {
        return this.tableToken.equals(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.meta("on").val(this.tableToken);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("{\"name\":\"").put(this.getClass().getSimpleName()).put("\", \"table\":\"").put(this.tableToken).put("\"}");
    }

    protected TableReader getReader(SqlExecutionContext executionContext) {
        return executionContext.getReader(this.tableToken, this.tableVersion);
    }
}

