/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class StrArrayDereferenceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "[](S[]I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new StrArrayDereferenceFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class StrArrayDereferenceFunction
    extends StrFunction
    implements BinaryFunction {
        private final Function arrayFunction;
        private final Function indexFunction;

        public StrArrayDereferenceFunction(Function arrayFunction, Function indexFunction) {
            this.arrayFunction = arrayFunction;
            this.indexFunction = indexFunction;
        }

        @Override
        public Function getLeft() {
            return this.arrayFunction;
        }

        @Override
        public Function getRight() {
            return this.indexFunction;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.arrayFunction.getStr(rec, this.indexFunction.getInt(rec));
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.arrayFunction.getStrB(rec, this.indexFunction.getInt(rec));
        }

        @Override
        public int getStrLen(Record rec, int arrayIndex) {
            return this.arrayFunction.getStrLen(rec, this.indexFunction.getInt(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arrayFunction).val('[').val(this.indexFunction).val(']');
        }
    }
}

