/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqCharCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(AA)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function chrFunc1 = args.getQuick(0);
        Function chrFunc2 = args.getQuick(1);
        return new Func(chrFunc1, chrFunc2);
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function chrFunc1, Function chrFunc2) {
            super(chrFunc1, chrFunc2);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getChar(rec) == this.right.getChar(rec));
        }
    }
}

