/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class MinDateGroupByFunction
extends DateFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinDateGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putDate(this.valueIndex, this.arg.getDate(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        long min = mapValue.getDate(this.valueIndex);
        long next = this.arg.getDate(record);
        if (next != Long.MIN_VALUE && next < min || min == Long.MIN_VALUE) {
            mapValue.putDate(this.valueIndex, next);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getDate(Record rec) {
        return rec.getDate(this.valueIndex);
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(7);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDate(this.valueIndex, Long.MIN_VALUE);
    }
}

