/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndLongCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_long(lli)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        long lo = args.getQuick(0).getLong(null);
        long hi = args.getQuick(1).getLong(null);
        int nanRate = args.getQuick(2).getInt(null);
        if (nanRate < 0) {
            throw SqlException.$(argPositions.getQuick(2), "invalid NaN rate");
        }
        if (lo < hi) {
            return new Func(lo, hi, nanRate);
        }
        throw SqlException.$(position, "invalid range");
    }

    private static class Func
    extends LongFunction
    implements Function {
        private final long lo;
        private final int nanRate;
        private final long range;
        private Rnd rnd;

        public Func(long lo, long hi, int nanRate) {
            this.lo = lo;
            this.range = hi - lo + 1L;
            this.nanRate = nanRate + 1;
        }

        @Override
        public long getLong(Record rec) {
            if (this.rnd.nextInt() % this.nanRate == 1) {
                return Long.MIN_VALUE;
            }
            return this.lo + this.rnd.nextPositiveLong() % this.range;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_long(").val(this.lo).val(',').val(this.range + this.lo - 1L).val(',').val(this.nanRate - 1).val(')');
        }
    }
}

