/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.metrics.Scrapable;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.str.CharSink;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

public class GCMetrics
implements Scrapable {
    private static final CharSequenceHashSet majorGCNames = new CharSequenceHashSet();
    private static final CharSequenceHashSet minorGCNames = new CharSequenceHashSet();

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        long majorCount = 0L;
        long majorTime = 0L;
        long minorCount = 0L;
        long minorTime = 0L;
        long unknownCount = 0L;
        long unknownTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = gc.getCollectionCount();
            if (count <= -1L) continue;
            if (majorGCNames.contains(gc.getName())) {
                majorCount += count;
                majorTime += gc.getCollectionTime();
                continue;
            }
            if (minorGCNames.contains(gc.getName())) {
                minorCount += count;
                minorTime += gc.getCollectionTime();
                continue;
            }
            unknownCount += count;
            unknownTime += gc.getCollectionTime();
        }
        this.appendCounter(sink, majorCount, "jvm_major_gc_count");
        this.appendCounter(sink, majorTime, "jvm_major_gc_time");
        this.appendCounter(sink, minorCount, "jvm_minor_gc_count");
        this.appendCounter(sink, minorTime, "jvm_minor_gc_time");
        this.appendCounter(sink, unknownCount, "jvm_unknown_gc_count");
        this.appendCounter(sink, unknownTime, "jvm_unknown_gc_time");
    }

    private void appendCounter(CharSink sink, long value, String name) {
        PrometheusFormatUtils.appendCounterType(name, sink);
        PrometheusFormatUtils.appendCounterNamePrefix(name, sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, value);
        PrometheusFormatUtils.appendNewLine(sink);
    }

    static {
        majorGCNames.add("PS MarkSweep");
        majorGCNames.add("ConcurrentMarkSweep");
        majorGCNames.add("G1 Old Generation");
        majorGCNames.add("G1 Mixed Generation");
        majorGCNames.add("MarkSweepCompact");
        majorGCNames.add("Shenandoah Pauses");
        majorGCNames.add("global");
        majorGCNames.add("global garbage collect");
        minorGCNames.add("PS Scavenge");
        minorGCNames.add("ParNew");
        minorGCNames.add("G1 Young Generation");
        minorGCNames.add("Copy");
        minorGCNames.add("ZGC");
        minorGCNames.add("Shenandoah Cycles");
        minorGCNames.add("partial gc");
        minorGCNames.add("scavenge");
    }
}

