/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateDataKeyResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GenerateDataKeyResponse> {
    private static final SdkField<SdkBytes> CIPHERTEXT_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextBlob").getter(GenerateDataKeyResponse.getter(GenerateDataKeyResponse::ciphertextBlob)).setter(GenerateDataKeyResponse.setter(Builder::ciphertextBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextBlob").build()}).build();
    private static final SdkField<SdkBytes> PLAINTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Plaintext").getter(GenerateDataKeyResponse.getter(GenerateDataKeyResponse::plaintext)).setter(GenerateDataKeyResponse.setter(Builder::plaintext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plaintext").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GenerateDataKeyResponse.getter(GenerateDataKeyResponse::keyId)).setter(GenerateDataKeyResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> CIPHERTEXT_FOR_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextForRecipient").getter(GenerateDataKeyResponse.getter(GenerateDataKeyResponse::ciphertextForRecipient)).setter(GenerateDataKeyResponse.setter(Builder::ciphertextForRecipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextForRecipient").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHERTEXT_BLOB_FIELD, PLAINTEXT_FIELD, KEY_ID_FIELD, CIPHERTEXT_FOR_RECIPIENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CiphertextBlob", CIPHERTEXT_BLOB_FIELD);
            this.put("Plaintext", PLAINTEXT_FIELD);
            this.put("KeyId", KEY_ID_FIELD);
            this.put("CiphertextForRecipient", CIPHERTEXT_FOR_RECIPIENT_FIELD);
        }
    });
    private final SdkBytes ciphertextBlob;
    private final SdkBytes plaintext;
    private final String keyId;
    private final SdkBytes ciphertextForRecipient;

    private GenerateDataKeyResponse(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.plaintext = builder.plaintext;
        this.keyId = builder.keyId;
        this.ciphertextForRecipient = builder.ciphertextForRecipient;
    }

    public final SdkBytes ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public final SdkBytes plaintext() {
        return this.plaintext;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final SdkBytes ciphertextForRecipient() {
        return this.ciphertextForRecipient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextForRecipient());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyResponse)) {
            return false;
        }
        GenerateDataKeyResponse other = (GenerateDataKeyResponse)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.plaintext(), other.plaintext()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.ciphertextForRecipient(), other.ciphertextForRecipient());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateDataKeyResponse").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("Plaintext", (Object)(this.plaintext() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyId", (Object)this.keyId()).add("CiphertextForRecipient", (Object)this.ciphertextForRecipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.ciphertextBlob()));
            }
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "CiphertextForRecipient": {
                return Optional.ofNullable(clazz.cast(this.ciphertextForRecipient()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GenerateDataKeyResponse, T> g) {
        return obj -> g.apply((GenerateDataKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes ciphertextBlob;
        private SdkBytes plaintext;
        private String keyId;
        private SdkBytes ciphertextForRecipient;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyResponse model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.plaintext(model.plaintext);
            this.keyId(model.keyId);
            this.ciphertextForRecipient(model.ciphertextForRecipient);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob == null ? null : this.ciphertextBlob.asByteBuffer();
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob(ciphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextBlob));
        }

        @Override
        public final Builder ciphertextBlob(SdkBytes ciphertextBlob) {
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = plaintext;
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final ByteBuffer getCiphertextForRecipient() {
            return this.ciphertextForRecipient == null ? null : this.ciphertextForRecipient.asByteBuffer();
        }

        public final void setCiphertextForRecipient(ByteBuffer ciphertextForRecipient) {
            this.ciphertextForRecipient(ciphertextForRecipient == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextForRecipient));
        }

        @Override
        public final Builder ciphertextForRecipient(SdkBytes ciphertextForRecipient) {
            this.ciphertextForRecipient = ciphertextForRecipient;
            return this;
        }

        @Override
        public GenerateDataKeyResponse build() {
            return new GenerateDataKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateDataKeyResponse> {
        public Builder ciphertextBlob(SdkBytes var1);

        public Builder plaintext(SdkBytes var1);

        public Builder keyId(String var1);

        public Builder ciphertextForRecipient(SdkBytes var1);
    }
}

