/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.policy;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.PoliciesClient;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.AccessPolicyResult;

public class GetAccessPolicy
extends AbstractNiFiRegistryCommand<AccessPolicyResult> {
    public GetAccessPolicy() {
        super("get-policy", AccessPolicyResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the configuration for an access policy.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.POLICY_RESOURCE.createOption());
        this.addOption(CommandOption.POLICY_ACTION.createOption());
    }

    @Override
    public AccessPolicyResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        PoliciesClient policiesClient = client.getPoliciesClient();
        String action = this.getRequiredArg(properties, CommandOption.POLICY_ACTION);
        String resource = this.getRequiredArg(properties, CommandOption.POLICY_RESOURCE);
        AccessPolicy accessPolicy = policiesClient.getAccessPolicy(action, resource);
        return new AccessPolicyResult(this.getResultType(properties), accessPolicy);
    }
}

