/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.datasource;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationHelper;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationRuntimeException;
import org.apache.olingo.odata2.annotation.processor.core.util.ClassHelper;
import org.apache.olingo.odata2.api.annotation.edm.EdmKey;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;

public class DataStore<T> {
    private static final AnnotationHelper ANNOTATION_HELPER = new AnnotationHelper();
    private final Map<KeyElement, T> dataStore;
    private final Class<T> dataTypeClass;
    private final KeyAccess keyAccess;

    public static <T> DataStore<T> createInMemory(Class<T> clazz) throws DataStoreException {
        return InMemoryDataStore.getInstance(clazz, true);
    }

    public static <T> DataStore<T> createInMemory(Class<T> clazz, boolean keepExisting) throws DataStoreException {
        return InMemoryDataStore.getInstance(clazz, !keepExisting);
    }

    private DataStore(Map<KeyElement, T> wrapStore, Class<T> clz) throws DataStoreException {
        this.dataStore = Collections.synchronizedMap(wrapStore);
        this.dataTypeClass = clz;
        this.keyAccess = new KeyAccess(clz);
    }

    private DataStore(Class<T> clz) throws DataStoreException {
        this(new HashMap(), clz);
    }

    public Class<T> getDataTypeClass() {
        return this.dataTypeClass;
    }

    public String getEntityTypeName() {
        return ANNOTATION_HELPER.extractEntityTypeName(this.dataTypeClass);
    }

    public T createInstance() {
        try {
            return this.dataTypeClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new AnnotationRuntimeException("Unable to create instance of class '" + this.dataTypeClass + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationRuntimeException("Unable to create instance of class '" + this.dataTypeClass + "'.", e);
        }
    }

    public T read(T obj) {
        KeyElement objKeys = this.getKeys(obj);
        return this.dataStore.get(objKeys);
    }

    public Collection<T> read() {
        return Collections.unmodifiableCollection(this.dataStore.values());
    }

    public T create(T object) throws DataStoreException {
        KeyElement keyElement = this.getKeys(object);
        return this.create(object, keyElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T create(T object, KeyElement keyElement) throws DataStoreException {
        Map<KeyElement, T> map = this.dataStore;
        synchronized (map) {
            boolean replaceKeys = this.dataStore.containsKey(keyElement);
            if (keyElement.keyValuesMissing() || replaceKeys) {
                KeyElement newKey = this.createSetAndGetKeys(object, replaceKeys);
                return this.create(object, newKey);
            }
            this.dataStore.put(keyElement, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update(T object) {
        KeyElement keyElement = this.getKeys(object);
        Map<KeyElement, T> map = this.dataStore;
        synchronized (map) {
            this.dataStore.remove(keyElement);
            this.dataStore.put(keyElement, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T delete(T object) {
        KeyElement keyElement = this.getKeys(object);
        Map<KeyElement, T> map = this.dataStore;
        synchronized (map) {
            return this.dataStore.remove(keyElement);
        }
    }

    public boolean isKeyEqual(T first, T second) {
        KeyElement firstKeys = this.getKeys(first);
        KeyElement secondKeys = this.getKeys(second);
        return firstKeys.equals(secondKeys);
    }

    public boolean isKeyEqualChecked(Object first, Object second) throws DataStoreException {
        if (first == null || second == null) {
            throw new DataStoreException("Tried to compare null values which is not allowed.");
        }
        if (first.getClass() != this.dataTypeClass) {
            throw new DataStoreException("First value is no instance from required class '" + this.dataTypeClass + "'.");
        }
        if (second.getClass() != this.dataTypeClass) {
            throw new DataStoreException("Second value is no instance from required class '" + this.dataTypeClass + "'.");
        }
        return this.isKeyEqual(first, second);
    }

    private KeyElement getKeys(T object) {
        return this.keyAccess.getKeyValues(object);
    }

    private KeyElement createSetAndGetKeys(T object, boolean replaceKeys) throws DataStoreException {
        return this.keyAccess.createSetAndGetKeys(object, replaceKeys);
    }

    public static class DataStoreException
    extends ODataApplicationException {
        private static final long serialVersionUID = 42L;

        public DataStoreException(String message) {
            this(message, null);
        }

        public DataStoreException(String message, Throwable cause) {
            super(message, Locale.ENGLISH, cause);
        }
    }

    private class KeyAccess {
        final List<Field> keyFields;
        final AtomicInteger idCounter = new AtomicInteger(1);

        KeyAccess(Class<?> clazz) throws DataStoreException {
            this.keyFields = ANNOTATION_HELPER.getAnnotatedFields(clazz, EdmKey.class);
            if (this.keyFields.isEmpty()) {
                throw new DataStoreException("No EdmKey annotated fields found for class " + clazz);
            }
        }

        KeyElement getKeyValues(T object) {
            KeyElement keyElement = new KeyElement(this.keyFields.size());
            for (Field field : this.keyFields) {
                Object keyValue = ClassHelper.getFieldValue(object, field);
                keyElement.addValue(keyValue);
            }
            return keyElement;
        }

        KeyElement createSetAndGetKeys(T object, boolean replaceKeys) throws DataStoreException {
            KeyElement keyElement = new KeyElement(this.keyFields.size());
            for (Field field : this.keyFields) {
                Object key = ClassHelper.getFieldValue(object, field);
                if (key == null || replaceKeys) {
                    key = this.createKey(field);
                    ClassHelper.setFieldValue(object, field, key);
                }
                keyElement.addValue(key);
            }
            return keyElement;
        }

        private Object createKey(Field field) {
            Class<?> type = field.getType();
            if (type == String.class) {
                return String.valueOf(this.idCounter.getAndIncrement());
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return this.idCounter.getAndIncrement();
            }
            if (type == Long.class || type == Long.TYPE) {
                return (long)this.idCounter.getAndIncrement();
            }
            if (type == UUID.class) {
                return UUID.randomUUID();
            }
            throw new UnsupportedOperationException("Automated key generation for type '" + type + "' is not supported (caused on field '" + field + "').");
        }
    }

    private class KeyElement {
        private int cachedHashCode = 42;
        private final List<Object> keyValues;

        public KeyElement(int size) {
            this.keyValues = new ArrayList<Object>(size);
        }

        private void addValue(Object keyValue) {
            this.keyValues.add(keyValue);
            this.cachedHashCode = 89 * this.cachedHashCode + (keyValue != null ? keyValue.hashCode() : 0);
        }

        boolean keyValuesMissing() {
            return this.keyValues.contains(null);
        }

        public int hashCode() {
            return this.cachedHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyElement other = (KeyElement)obj;
            return this.keyValues == other.keyValues || this.keyValues != null && this.keyValues.equals(other.keyValues);
        }

        public String toString() {
            return "KeyElement{cachedHashCode=" + this.cachedHashCode + ", keyValues=" + this.keyValues + '}';
        }
    }

    private static class InMemoryDataStore {
        private static final Map<Class<?>, DataStore<?>> c2ds = new HashMap();

        private InMemoryDataStore() {
        }

        static synchronized DataStore<?> getInstance(Class<?> clz, boolean createNewInstance) throws DataStoreException {
            DataStore<Object> ds = c2ds.get(clz);
            if (createNewInstance || ds == null) {
                ds = new DataStore(clz);
                c2ds.put(clz, ds);
            }
            return ds;
        }
    }
}

