/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.domain.ClientAnnotatable;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.client.core.domain.ClientAnnotationImpl;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.ComplexCollection;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.annotations.ComplexType;
import org.apache.olingo.ext.proxy.api.annotations.CompoundKey;
import org.apache.olingo.ext.proxy.api.annotations.CompoundKeyElement;
import org.apache.olingo.ext.proxy.api.annotations.EnumType;
import org.apache.olingo.ext.proxy.api.annotations.Key;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.api.annotations.Property;
import org.apache.olingo.ext.proxy.api.annotations.Term;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CompoundKeyElementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CoreUtils.class);

    private CoreUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientValue getODataValue(EdmEnabledODataClient client, EdmTypeInfo type, Object obj) {
        ClientValue value;
        if (type.isCollection()) {
            value = client.getObjectFactory().newCollectionValue(type.getFullQualifiedName().toString());
            EdmTypeInfo intType = new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(type.getFullQualifiedName().toString()).build();
            Iterator iterator = ((Collection)obj).iterator();
            while (iterator.hasNext()) {
                Object collectionItem = iterator.next();
                if (intType.isPrimitiveType()) {
                    value.asCollection().add(CoreUtils.getODataValue(client, intType, collectionItem).asPrimitive());
                    continue;
                }
                if (intType.isEnumType()) {
                    value.asCollection().add(CoreUtils.getODataValue(client, intType, collectionItem).asEnum());
                    continue;
                }
                if (!intType.isComplexType()) throw new UnsupportedOperationException("Unsupported object type " + intType.getFullQualifiedName());
                value.asCollection().add(CoreUtils.getODataValue(client, intType, collectionItem).asComplex());
            }
            return value;
        }
        if (type.isComplexType()) {
            InvocationHandler objHandler = Proxy.getInvocationHandler(obj);
            if (!(objHandler instanceof ComplexInvocationHandler)) throw new IllegalArgumentException(objHandler.getClass().getName() + "' is not a complex value");
            value = ((ComplexInvocationHandler)objHandler).getComplex();
            Class<?> typeRef = ((ComplexInvocationHandler)objHandler).getTypeRef();
            Iterator<Map.Entry<String, Object>> iterator = ((ComplexInvocationHandler)objHandler).getPropertyChanges().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> changes = iterator.next();
                try {
                    value.asComplex().add(CoreUtils.getODataComplexProperty(client, type.getFullQualifiedName(), changes.getKey(), changes.getValue()));
                }
                catch (Exception ignore) {
                    LOG.warn("Error attaching complex {} for field '{}.{}'", type.getFullQualifiedName(), typeRef.getName(), changes.getKey(), ignore);
                }
            }
            return value;
        }
        if (!type.isEnumType()) return client.getObjectFactory().newPrimitiveValueBuilder().setType(type.getPrimitiveTypeKind()).setValue(obj).build();
        return client.getObjectFactory().newEnumValue(type.getFullQualifiedName().toString(), ((Enum)obj).name());
    }

    private static ClientProperty getODataEntityProperty(EdmEnabledODataClient client, FullQualifiedName entity, String property, Object obj) {
        EdmElement edmProperty = client.getCachedEdm().getEntityType(entity).getProperty(property);
        return CoreUtils.getODataProperty(client, edmProperty, property, obj);
    }

    private static ClientProperty getODataComplexProperty(EdmEnabledODataClient client, FullQualifiedName complex, String property, Object obj) {
        EdmElement edmProperty = client.getCachedEdm().getComplexType(complex).getProperty(property);
        return CoreUtils.getODataProperty(client, edmProperty, property, obj);
    }

    private static ClientProperty getODataProperty(EdmEnabledODataClient client, EdmElement edmProperty, String property, Object obj) {
        EdmTypeInfo type;
        if (edmProperty == null) {
            type = null;
        } else {
            EdmType edmType = edmProperty.getType();
            type = new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(edmProperty.isCollection() ? "Collection(" + edmType.getFullQualifiedName().toString() + ")" : edmType.getFullQualifiedName().toString()).build();
        }
        return CoreUtils.getODataProperty(client, property, type, obj);
    }

    public static ClientAnnotation getODataAnnotation(EdmEnabledODataClient client, String term, EdmType type, Object obj) {
        ClientAnnotationImpl annotation;
        if (obj == null) {
            annotation = new ClientAnnotationImpl(term, null);
        } else {
            EdmTypeInfo valueType = type == null ? CoreUtils.guessTypeFromObject(client, obj) : new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(type.getFullQualifiedName().toString()).build();
            annotation = new ClientAnnotationImpl(term, CoreUtils.getODataValue(client, valueType, obj));
        }
        return annotation;
    }

    public static ClientProperty getODataProperty(EdmEnabledODataClient client, String name, EdmTypeInfo type, Object obj) {
        try {
            ClientProperty property;
            if (obj == null) {
                property = client.getObjectFactory().newPrimitiveProperty(name, null);
            } else {
                EdmTypeInfo valueType = type == null ? CoreUtils.guessTypeFromObject(client, obj) : type;
                ClientValue value = CoreUtils.getODataValue(client, valueType, obj);
                if (valueType.isCollection()) {
                    property = client.getObjectFactory().newCollectionProperty(name, value.asCollection());
                } else if (valueType.isPrimitiveType()) {
                    property = client.getObjectFactory().newPrimitiveProperty(name, value.asPrimitive());
                } else if (valueType.isComplexType()) {
                    property = client.getObjectFactory().newComplexProperty(name, value.asComplex());
                } else if (valueType.isEnumType()) {
                    property = client.getObjectFactory().newEnumProperty(name, value.asEnum());
                } else {
                    throw new UnsupportedOperationException("Usupported object type " + valueType.getFullQualifiedName());
                }
            }
            return property;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static EdmTypeInfo guessTypeFromObject(EdmEnabledODataClient client, Object obj) {
        EdmTypeInfo.Builder edmTypeInfo = new EdmTypeInfo.Builder().setEdm(client.getCachedEdm());
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            EdmTypeInfo type = CoreUtils.guessPrimitiveType(client, ClassUtils.extractTypeArg(obj.getClass(), EntityCollection.class, ComplexCollection.class, Collection.class));
            return edmTypeInfo.setTypeExpression("Collection(" + type.getFullQualifiedName() + ")").build();
        }
        if (obj instanceof Proxy) {
            Class<?> typeRef = obj.getClass().getInterfaces()[0];
            String ns = typeRef.getAnnotation(Namespace.class).value();
            String name = typeRef.getAnnotation(ComplexType.class).name();
            return edmTypeInfo.setTypeExpression(new FullQualifiedName(ns, name).toString()).build();
        }
        if (obj.getClass().getAnnotation(EnumType.class) != null) {
            Class<?> typeRef = obj.getClass();
            String ns = typeRef.getAnnotation(Namespace.class).value();
            String name = typeRef.getAnnotation(EnumType.class).name();
            return edmTypeInfo.setTypeExpression(new FullQualifiedName(ns, name).toString()).build();
        }
        return CoreUtils.guessPrimitiveType(client, obj.getClass());
    }

    private static EdmTypeInfo guessPrimitiveType(EdmEnabledODataClient client, Class<?> clazz) {
        Enum bckCandidate = null;
        for (EdmPrimitiveTypeKind kind : EdmPrimitiveTypeKind.values()) {
            Class<?> target = EdmPrimitiveTypeFactory.getInstance(kind).getDefaultType();
            if (clazz.equals(target)) {
                return new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(kind.toString()).build();
            }
            if (target.isAssignableFrom(clazz)) {
                bckCandidate = kind;
                continue;
            }
            if (target != Timestamp.class || kind != EdmPrimitiveTypeKind.DateTimeOffset) continue;
            bckCandidate = kind;
        }
        if (bckCandidate == null) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " is not a simple type");
        }
        return new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(bckCandidate.toString()).build();
    }

    public static void addProperties(EdmEnabledODataClient client, Map<String, Object> changes, ClientEntity entity) {
        for (Map.Entry<String, Object> entry : changes.entrySet()) {
            entity.getProperties().add(CoreUtils.getODataEntityProperty(client, entity.getTypeName(), entry.getKey(), entry.getValue()));
        }
    }

    public static void addProperties(EdmEnabledODataClient client, Map<String, Object> changes, ClientComplexValue entity) {
        for (Map.Entry<String, Object> entry : changes.entrySet()) {
            entity.add(CoreUtils.getODataComplexProperty(client, new FullQualifiedName(entity.getTypeName()), entry.getKey(), entry.getValue()));
        }
    }

    public static void addAnnotations(EdmEnabledODataClient client, Map<Class<? extends AbstractTerm>, Object> annotations, ClientAnnotatable annotatable) {
        for (Map.Entry<Class<? extends AbstractTerm>, Object> entry : annotations.entrySet()) {
            Namespace nsAnn = entry.getKey().getAnnotation(Namespace.class);
            Term termAnn = entry.getKey().getAnnotation(Term.class);
            FullQualifiedName termName = new FullQualifiedName(nsAnn.value(), termAnn.name());
            EdmTerm term = client.getCachedEdm().getTerm(termName);
            if (term == null) {
                LOG.error("Could not find term for class {}", (Object)entry.getKey().getName());
                continue;
            }
            annotatable.getAnnotations().add(CoreUtils.getODataAnnotation(client, term.getFullQualifiedName().toString(), term.getType(), entry.getValue()));
        }
    }

    private static Enum<?> enumValueToObject(ClientEnumValue value, Class<?> reference) {
        Namespace namespace = reference.getAnnotation(Namespace.class);
        EnumType enumType = reference.getAnnotation(EnumType.class);
        if (value.getTypeName().equals(namespace.value() + "." + enumType.name())) {
            return Enum.valueOf(reference, value.getValue());
        }
        return null;
    }

    private static Object primitiveValueToObject(ClientPrimitiveValue value, Class<?> reference) {
        Object obj;
        try {
            obj = reference == null ? value.toValue() : value.toCastValue(reference);
        }
        catch (EdmPrimitiveTypeException e) {
            LOG.warn("While casting primitive value {} to {}", value, reference, e);
            obj = value.toValue();
        }
        return obj;
    }

    private static void setPropertyValue(Object bean, Method getter, Object value) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String setterName = getter.getName().replaceFirst("get", "set");
        bean.getClass().getMethod(setterName, getter.getReturnType()).invoke(bean, value);
    }

    private static Class<?> getPropertyClass(Class<?> entityClass, String propertyName) {
        Class<?> propertyClass = null;
        try {
            Method getter = entityClass.getMethod("get" + StringUtils.capitalize(propertyName), new Class[0]);
            if (getter != null) {
                propertyClass = getter.getReturnType();
            }
        }
        catch (Exception e) {
            LOG.error("Could not determine the Java type of {}", (Object)propertyName, (Object)e);
        }
        return propertyClass;
    }

    public static URIBuilder buildEditLink(EdmEnabledODataClient client, String entitySetURI, Object key) {
        URIBuilder uriBuilder;
        if (key == null) {
            return null;
        }
        URIBuilder uRIBuilder = uriBuilder = StringUtils.isNotBlank(entitySetURI) ? client.newURIBuilder(entitySetURI) : client.newURIBuilder();
        if (key.getClass().getAnnotation(CompoundKey.class) == null) {
            LOG.debug("Append key segment '{}'", key);
            uriBuilder.appendKeySegment(key);
        } else {
            LOG.debug("Append compound key segment '{}'", key);
            uriBuilder.appendKeySegment(CoreUtils.getCompoundKey(key));
        }
        return uriBuilder;
    }

    public static Map<String, Object> getCompoundKey(Object key) {
        TreeSet<CompoundKeyElementWrapper> elements = new TreeSet<CompoundKeyElementWrapper>();
        for (Method method : key.getClass().getMethods()) {
            CompoundKeyElement annotation = method.getAnnotation(CompoundKeyElement.class);
            if (!(annotation instanceof CompoundKeyElement)) continue;
            elements.add(new CompoundKeyElementWrapper(annotation.name(), method, annotation.position()));
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (CompoundKeyElementWrapper element : elements) {
            try {
                map.put(element.getName(), element.getMethod().invoke(key, new Object[0]));
            }
            catch (Exception e) {
                LOG.warn("Error retrieving compound key element '{}' value", (Object)element.getName(), (Object)e);
            }
        }
        return map;
    }

    public static Object getKey(EdmEnabledODataClient client, EntityInvocationHandler typeHandler, Class<?> entityTypeRef, ClientEntity entity) {
        Object res = null;
        if (!entity.getProperties().isEmpty()) {
            Class<?> keyRef = ClassUtils.getCompoundKeyRef(entityTypeRef);
            if (keyRef == null) {
                ClientProperty property = entity.getProperty(CoreUtils.firstValidEntityKey(entityTypeRef));
                if (property != null && property.hasPrimitiveValue()) {
                    res = CoreUtils.primitiveValueToObject(property.getPrimitiveValue(), CoreUtils.getPropertyClass(entityTypeRef, property.getName()));
                }
            } else {
                try {
                    res = keyRef.newInstance();
                    CoreUtils.populate(client, typeHandler, res, CompoundKeyElement.class, entity.getProperties().iterator());
                }
                catch (Exception e) {
                    LOG.error("Error population compound key {}", (Object)keyRef.getSimpleName(), (Object)e);
                    throw new IllegalArgumentException("Cannot populate compound key");
                }
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void populate(EdmEnabledODataClient client, EntityInvocationHandler typeHandler, Object bean, Class<? extends Annotation> getterAnn, Iterator<? extends ClientProperty> propItor) {
        Class<?> typeRef;
        if (bean == null) return;
        if (bean instanceof Proxy) {
            InvocationHandler handler = Proxy.getInvocationHandler(bean);
            if (!(handler instanceof AbstractStructuredInvocationHandler)) throw new IllegalStateException("Invalid bean " + bean);
            typeRef = ((ComplexInvocationHandler)handler).getTypeRef();
        } else {
            typeRef = bean.getClass();
        }
        CoreUtils.populate(client, typeHandler, bean, typeRef, getterAnn, propItor);
    }

    private static void populate(EdmEnabledODataClient client, EntityInvocationHandler typeHandler, Object bean, Class<?> typeRef, Class<? extends Annotation> getterAnn, Iterator<? extends ClientProperty> propItor) {
        if (bean != null) {
            while (propItor.hasNext()) {
                ClientProperty property = propItor.next();
                Method getter = ClassUtils.findGetterByAnnotatedName(typeRef, getterAnn, property.getName());
                if (getter == null) {
                    LOG.warn("Could not find any property annotated as {} in {}", (Object)property.getName(), (Object)bean.getClass().getName());
                    continue;
                }
                try {
                    if (property.hasNullValue()) {
                        CoreUtils.setPropertyValue(bean, getter, null);
                        continue;
                    }
                    if (property.hasPrimitiveValue()) {
                        CoreUtils.setPropertyValue(bean, getter, CoreUtils.primitiveValueToObject(property.getPrimitiveValue(), CoreUtils.getPropertyClass(typeRef, property.getName())));
                        continue;
                    }
                    if (property.hasComplexValue()) {
                        Object complex = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{getter.getReturnType()}, (InvocationHandler)ComplexInvocationHandler.getInstance(typeHandler, getter.getReturnType()));
                        CoreUtils.populate(client, typeHandler, complex, Property.class, property.getValue().asComplex().iterator());
                        CoreUtils.setPropertyValue(bean, getter, complex);
                        continue;
                    }
                    if (!property.hasCollectionValue()) continue;
                    ParameterizedType collType = (ParameterizedType)getter.getGenericReturnType();
                    Class collItemClass = (Class)collType.getActualTypeArguments()[0];
                    ArrayList<Object> collection = (ArrayList<Object>)getter.invoke(bean, new Object[0]);
                    if (collection == null) {
                        collection = new ArrayList<Object>();
                        CoreUtils.setPropertyValue(bean, getter, collection);
                    }
                    for (ClientValue value : property.getValue().asCollection()) {
                        if (value.isPrimitive()) {
                            collection.add(CoreUtils.primitiveValueToObject(value.asPrimitive(), CoreUtils.getPropertyClass(typeRef, property.getName())));
                            continue;
                        }
                        if (!value.isComplex()) continue;
                        Object collItem = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collItemClass}, (InvocationHandler)ComplexInvocationHandler.getInstance(typeHandler, collItemClass));
                        CoreUtils.populate(client, typeHandler, collItem, Property.class, value.asComplex().iterator());
                        collection.add(collItem);
                    }
                }
                catch (Exception e) {
                    LOG.error("Could not set property {} on {}", getter, bean, e);
                }
            }
        }
    }

    public static Object getObjectFromODataValue(ClientValue value, Type typeRef, AbstractService<?> service) throws InstantiationException, IllegalAccessException {
        Class internalRef;
        if (typeRef == null) {
            internalRef = null;
        } else {
            try {
                internalRef = (Class)((ParameterizedType)typeRef).getActualTypeArguments()[0];
            }
            catch (ClassCastException e) {
                internalRef = (Class)typeRef;
            }
        }
        return CoreUtils.getObjectFromODataValue(value, internalRef, service);
    }

    public static Object getObjectFromODataValue(ClientValue value, Class<?> ref, AbstractService<?> service) throws InstantiationException, IllegalAccessException {
        Enum<?> res;
        if (value == null) {
            res = null;
        } else if (value.isComplex()) {
            Class<?> internalRef = CoreUtils.getComplexTypeRef(service, value);
            res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{internalRef}, (InvocationHandler)ComplexInvocationHandler.getInstance(value.asComplex(), internalRef, service));
        } else if (value.isCollection()) {
            ArrayList<Object> collection = new ArrayList<Object>();
            for (ClientValue itemValue : value.asCollection()) {
                if (itemValue.isPrimitive()) {
                    collection.add(CoreUtils.primitiveValueToObject(itemValue.asPrimitive(), ref));
                    continue;
                }
                if (itemValue.isComplex()) {
                    Class<?> internalRef = CoreUtils.getComplexTypeRef(service, value);
                    Object collItem = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{internalRef}, (InvocationHandler)ComplexInvocationHandler.getInstance(itemValue.asComplex(), internalRef, service));
                    collection.add(collItem);
                    continue;
                }
                if (itemValue.isEnum()) {
                    collection.add(CoreUtils.enumValueToObject(itemValue.asEnum(), ref));
                    continue;
                }
                throw new RuntimeException("Unsupported collection item type " + itemValue.getTypeName());
            }
            res = collection;
        } else {
            res = value instanceof ClientEnumValue ? CoreUtils.enumValueToObject((ClientEnumValue)value, ref == null ? CoreUtils.getEnumTypeRef(service, value) : ref) : CoreUtils.primitiveValueToObject(value.asPrimitive(), ref);
        }
        return res;
    }

    public static Collection<Class<? extends AbstractTerm>> getAnnotationTerms(AbstractService<?> service, List<ClientAnnotation> annotations) {
        ArrayList<Class<? extends AbstractTerm>> res = new ArrayList<Class<? extends AbstractTerm>>();
        for (ClientAnnotation annotation : annotations) {
            Class<AbstractTerm> clazz = service.getTermClass(annotation.getTerm());
            if (clazz == null) continue;
            res.add(clazz);
        }
        return res;
    }

    private static Class<?> getEnumTypeRef(AbstractService<?> service, ClientValue value) {
        return service.getEnumTypeClass(value.getTypeName().replaceAll("^Collection\\(", "").replaceAll("\\)$", ""));
    }

    public static Class<?> getComplexTypeRef(AbstractService<?> service, ClientValue value) {
        return service.getComplexTypeClass(value.getTypeName().replaceAll("^Collection\\(", "").replaceAll("\\)$", ""));
    }

    private static String firstValidEntityKey(Class<?> entityTypeRef) {
        for (Method method : entityTypeRef.getDeclaredMethods()) {
            Property ann;
            if (method.getAnnotation(Key.class) == null || (ann = method.getAnnotation(Property.class)) == null) continue;
            return ann.name();
        }
        return null;
    }

    public static URI getMediaEditLink(String name, ClientEntity entity) {
        ClientLink mediaEditLink = entity.getMediaEditLink(name);
        return mediaEditLink == null ? URIUtils.getURI(entity.getEditLink(), name) : mediaEditLink.getLink();
    }

    public static URI getTargetEntitySetURI(EdmEnabledODataClient client, NavigationProperty property) {
        URIBuilder uriBuilder = client.newURIBuilder(client.getServiceRoot());
        uriBuilder.appendEntitySetSegment(property.targetEntitySet());
        return uriBuilder.build();
    }
}

