/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientOperation;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.ext.proxy.api.OperationType;
import org.apache.olingo.ext.proxy.api.annotations.Operation;
import org.apache.olingo.ext.proxy.api.annotations.Parameter;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityContainerInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.InvokerInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PrimitiveCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.StructuredComposableInvokerInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CoreUtils;

final class OperationInvocationHandler
extends AbstractInvocationHandler {
    private final InvocationHandler target;
    private final FullQualifiedName targetFQN;

    static OperationInvocationHandler getInstance(EntityContainerInvocationHandler containerHandler) {
        return new OperationInvocationHandler(containerHandler);
    }

    static OperationInvocationHandler getInstance(EntityInvocationHandler entityHandler) {
        return new OperationInvocationHandler(entityHandler);
    }

    static OperationInvocationHandler getInstance(ComplexInvocationHandler complexHandler) {
        return new OperationInvocationHandler(complexHandler);
    }

    static OperationInvocationHandler getInstance(EntityCollectionInvocationHandler<?> collectionHandler) {
        return new OperationInvocationHandler(collectionHandler);
    }

    static OperationInvocationHandler getInstance(ComplexCollectionInvocationHandler<?> collectionHandler) {
        return new OperationInvocationHandler(collectionHandler);
    }

    static OperationInvocationHandler getInstance(PrimitiveCollectionInvocationHandler<?> collectionHandler) {
        return new OperationInvocationHandler(collectionHandler);
    }

    private OperationInvocationHandler(EntityContainerInvocationHandler containerHandler) {
        super(containerHandler.service);
        this.target = containerHandler;
        this.targetFQN = new FullQualifiedName(containerHandler.getSchemaName(), containerHandler.getEntityContainerName());
    }

    private OperationInvocationHandler(EntityInvocationHandler entityHandler) {
        super(entityHandler.service);
        this.target = entityHandler;
        this.targetFQN = entityHandler.getEntity().getTypeName();
    }

    private OperationInvocationHandler(ComplexInvocationHandler complexHandler) {
        super(complexHandler.service);
        this.target = complexHandler;
        this.targetFQN = new FullQualifiedName(complexHandler.getComplex().getTypeName());
    }

    private OperationInvocationHandler(EntityCollectionInvocationHandler<?> collectionHandler) {
        super(collectionHandler.service);
        this.target = collectionHandler;
        String typeName = ClassUtils.getEntityTypeName(collectionHandler.getTypeRef());
        String typeNamespace = ClassUtils.getNamespace(collectionHandler.getTypeRef());
        this.targetFQN = new FullQualifiedName(typeNamespace, typeName);
    }

    private OperationInvocationHandler(ComplexCollectionInvocationHandler<?> collectionHandler) {
        super(collectionHandler.service);
        this.target = collectionHandler;
        String typeName = ClassUtils.getEntityTypeName(collectionHandler.getTypeRef());
        String typeNamespace = ClassUtils.getNamespace(collectionHandler.getTypeRef());
        this.targetFQN = new FullQualifiedName(typeNamespace, typeName);
    }

    private OperationInvocationHandler(PrimitiveCollectionInvocationHandler<?> collectionHandler) {
        super(collectionHandler.service);
        this.target = collectionHandler;
        String typeName = ClassUtils.getEntityTypeName(collectionHandler.getTypeRef());
        String typeNamespace = ClassUtils.getNamespace(collectionHandler.getTypeRef());
        this.targetFQN = new FullQualifiedName(typeNamespace, typeName);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isSelfMethod(method)) {
            return this.invokeSelfMethod(method, args);
        }
        Operation operation = method.getAnnotation(Operation.class);
        if (operation != null) {
            Map.Entry<URI, EdmOperation> edmOperation;
            ArrayList<String> parameterNames;
            Annotation[][] annotations = method.getParameterAnnotations();
            LinkedHashMap<Parameter, Object> parameters = new LinkedHashMap<Parameter, Object>();
            if (annotations == null || annotations.length == 0) {
                parameterNames = null;
            } else {
                parameterNames = new ArrayList<String>();
                for (int i = 0; i < args.length; ++i) {
                    for (Annotation paramAnnotation : annotations[i]) {
                        if (!(paramAnnotation instanceof Parameter)) continue;
                        parameterNames.add(((Parameter)paramAnnotation).name());
                        parameters.put((Parameter)paramAnnotation, args[i]);
                    }
                    if (parameters.size() > i) continue;
                    throw new IllegalArgumentException("Paramter " + i + " is not annotated as @" + Parameter.class.getSimpleName());
                }
            }
            if (this.target instanceof EntityContainerInvocationHandler) {
                edmOperation = this.getUnboundOperation(operation, parameterNames);
            } else if (this.target instanceof EntityInvocationHandler) {
                edmOperation = this.getBoundOperation(operation, parameterNames);
            } else if (this.target instanceof EntityCollectionInvocationHandler) {
                edmOperation = this.getCollectionBoundOperation(operation, parameterNames);
            } else {
                throw new IllegalStateException("Invalid target invocation");
            }
            LinkedHashMap<String, ClientValue> parameterValues = new LinkedHashMap<String, ClientValue>();
            for (Map.Entry parameter : parameters.entrySet()) {
                if (!((Parameter)parameter.getKey()).nullable() && parameter.getValue() == null) {
                    throw new IllegalArgumentException("Parameter " + ((Parameter)parameter.getKey()).name() + " is not nullable but a null value was provided");
                }
                EdmTypeInfo parameterType = new EdmTypeInfo.Builder().setEdm(this.service.getClient().getCachedEdm()).setTypeExpression(((Parameter)parameter.getKey()).type()).build();
                ClientValue paramValue = parameter.getValue() == null ? null : CoreUtils.getODataValue(this.service.getClient(), parameterType, parameter.getValue());
                parameterValues.put(((Parameter)parameter.getKey()).name(), paramValue);
            }
            EdmTypeInfo returnType = edmOperation.getValue().getReturnType() == null ? null : new EdmTypeInfo.Builder().setEdm(this.service.getClient().getCachedEdm()).setTypeExpression(edmOperation.getValue().getReturnType().getType().getFullQualifiedName().toString()).build();
            InvokerInvocationHandler handler = returnType != null && (returnType.isEntityType() || returnType.isComplexType()) && operation.isComposable() ? new StructuredComposableInvokerInvocationHandler(edmOperation.getKey(), parameterValues, operation, edmOperation.getValue(), ClassUtils.getTypeArguments(method.getReturnType().getGenericInterfaces()[0]), returnType, this.service) : new InvokerInvocationHandler(edmOperation.getKey(), parameterValues, operation, edmOperation.getValue(), ClassUtils.getTypeArguments(method.getGenericReturnType()), this.service);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ClassUtils.getTypeClass(method.getGenericReturnType())}, handler);
        }
        throw new NoSuchMethodException(method.getName());
    }

    private Map.Entry<URI, EdmOperation> getUnboundOperation(Operation operation, List<String> parameterNames) {
        EdmEntityContainer container = this.getClient().getCachedEdm().getEntityContainer(this.targetFQN);
        EdmOperation edmOperation = operation.type() == OperationType.FUNCTION ? container.getFunctionImport(operation.name()).getUnboundFunction(parameterNames) : container.getActionImport(operation.name()).getUnboundAction();
        URIBuilder uriBuilder = this.getClient().newURIBuilder().appendOperationCallSegment(edmOperation.getName());
        return new AbstractMap.SimpleEntry<URI, EdmOperation>(uriBuilder.build(), edmOperation);
    }

    private Map.Entry<URI, EdmOperation> getBoundOperation(Operation operation, List<String> parameterNames) {
        EdmEntityType entityType;
        ClientEntity entity = ((EntityInvocationHandler)EntityInvocationHandler.class.cast(this.target)).getEntity();
        URI entityURI = ((EntityInvocationHandler)EntityInvocationHandler.class.cast(this.target)).getEntityURI();
        ClientOperation boundOp = entity.getOperation(operation.name());
        if (boundOp == null) {
            boundOp = entity.getOperation(new FullQualifiedName(this.targetFQN.getNamespace(), operation.name()).toString());
        }
        boolean useOperationFQN = this.getClient().getConfiguration().isUseUrlOperationFQN();
        EdmEntityType baseType = entityType = this.getClient().getCachedEdm().getEntityType(entity.getTypeName());
        while (boundOp == null && baseType != null) {
            EdmAction action = this.getClient().getCachedEdm().getBoundAction(new FullQualifiedName(this.targetFQN.getNamespace(), operation.name()), baseType.getFullQualifiedName(), false);
            if (action == null) {
                baseType = baseType.getBaseType();
                continue;
            }
            boundOp = new ClientOperation();
            boundOp.setMetadataAnchor(action.getFullQualifiedName().toString());
            boundOp.setTitle(boundOp.getMetadataAnchor());
            boundOp.setTarget(URI.create(entityURI.toASCIIString() + "/" + (useOperationFQN ? action.getFullQualifiedName().toString() : operation.name())));
        }
        baseType = entityType;
        while (boundOp == null && baseType != null) {
            EdmFunction func = this.getClient().getCachedEdm().getBoundFunction(new FullQualifiedName(this.targetFQN.getNamespace(), operation.name()), baseType.getFullQualifiedName(), false, parameterNames);
            if (func == null) {
                baseType = baseType.getBaseType();
                continue;
            }
            boundOp = new ClientOperation();
            boundOp.setMetadataAnchor(func.getFullQualifiedName().toString());
            boundOp.setTitle(boundOp.getMetadataAnchor());
            boundOp.setTarget(URI.create(entityURI.toASCIIString() + "/" + (useOperationFQN ? func.getFullQualifiedName().toString() : operation.name())));
        }
        if (boundOp == null) {
            throw new IllegalArgumentException(String.format("Could not find any matching operation '%s' bound to %s", operation.name(), entity.getTypeName()));
        }
        FullQualifiedName operationFQN = boundOp.getTitle().indexOf(46) == -1 ? new FullQualifiedName(this.targetFQN.getNamespace(), boundOp.getTitle()) : new FullQualifiedName(boundOp.getTitle());
        EdmOperation edmOperation = null;
        while (edmOperation == null && entityType != null) {
            EdmOperation edmOperation2 = edmOperation = operation.type() == OperationType.FUNCTION ? this.getClient().getCachedEdm().getBoundFunction(operationFQN, entityType.getFullQualifiedName(), false, parameterNames) : this.getClient().getCachedEdm().getBoundAction(operationFQN, entityType.getFullQualifiedName(), false);
            if (entityType.getBaseType() == null) continue;
            entityType = entityType.getBaseType();
        }
        if (edmOperation == null) {
            throw new IllegalArgumentException(String.format("Could not find any matching operation '%s' bound to %s", operation.name(), entity.getTypeName()));
        }
        return new AbstractMap.SimpleEntry<URI, Object>(boundOp.getTarget(), edmOperation);
    }

    private Map.Entry<URI, EdmOperation> getCollectionBoundOperation(Operation operation, List<String> parameterNames) {
        EdmOperation edmOperation = operation.type() == OperationType.FUNCTION ? this.getClient().getCachedEdm().getBoundFunction(new FullQualifiedName(this.targetFQN.getNamespace(), operation.name()), this.targetFQN, true, parameterNames) : this.getClient().getCachedEdm().getBoundAction(new FullQualifiedName(this.targetFQN.getNamespace(), operation.name()), this.targetFQN, true);
        return new AbstractMap.SimpleEntry<URI, EdmOperation>(URI.create(((EntityCollectionInvocationHandler)this.target).getURI().toASCIIString() + "/" + edmOperation.getName()), edmOperation);
    }
}

