/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Map;

import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Version;

@Entity(name = "MapHolder")
public class MapHolder {
    @Id
    private int id;

    @Version
    private int version;

    @ElementCollection
    private Map<MapEmbeddable, MapEmbeddable> embeddableMap;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<MapEmbeddable, MapEmbeddable> getEmbeddableMap() {
        return embeddableMap;
    }

    public void setEmbeddableMap(Map<MapEmbeddable, MapEmbeddable> embeddableMap) {
        this.embeddableMap = embeddableMap;
    }

    @Override
    public String toString() {
        return "MapHolder [embeddableMap=" + embeddableMap + ", id=" + id + ", version=" + version + "]";
    }
}
