/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AbstractInjectable;

public class InjectableField<T>
extends AbstractInjectable<T> {
    protected Field field;
    protected Object instance;

    public InjectableField(Field field, Object instance, InjectionTarget<T> owner, CreationalContextImpl<T> creationalContext) {
        super((Producer<?>)owner, creationalContext);
        this.field = field;
        this.instance = instance;
    }

    public T doInjection() {
        try {
            InjectionPoint injectedField = this.getInjectionPoints(this.field).get(0);
            if (!this.field.isAccessible()) {
                this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.field, true);
            }
            Object object = injectedField.isDelegate() ? this.creationalContext.getDelegate() : this.inject(injectedField);
            this.field.set(this.instance, object);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansException(e);
        }
        return null;
    }
}

