/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.fs.ozone;

import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import java.io.IOException;

/**
 * The PosixOzoneFileSystem implementation.
 * The create function in this class overrides
 * the create function of OzoneFileSystem class.
 * This create function first creates a file, then
 * closes it and again calls the create function
 * of super class.
 */

public class PosixOzoneFileSystem extends OzoneFileSystem {
  @Override
  public FSDataOutputStream create(Path f, FsPermission permission,
                                   boolean overwrite, int bufferSize,
                                   short replication, long blockSize,
                                   Progressable progress) throws IOException {
    FSDataOutputStream cstream = super.create(f, permission, overwrite,
        bufferSize, replication, blockSize, progress);
    cstream.close();
    return super.create(f, permission, overwrite, bufferSize,
        replication, blockSize, progress);
  }
}
