/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.ContainerEndpoint;
import org.apache.hadoop.ozone.recon.api.types.KeyEntityInfo;
import org.apache.hadoop.ozone.recon.api.types.KeyInsightInfoResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconNamespaceSummaryManagerImpl;
import org.apache.hadoop.ozone.recon.tasks.OmTableInsightTask;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/keys")
@Produces(value={"application/json"})
@AdminOnly
public class OMDBInsightEndpoint {
    @Inject
    private ContainerEndpoint containerEndpoint;
    @Inject
    private ReconContainerMetadataManager reconContainerMetadataManager;
    private final ReconOMMetadataManager omMetadataManager;
    private final ReconContainerManager containerManager;
    private static final Logger LOG = LoggerFactory.getLogger(OMDBInsightEndpoint.class);
    private final GlobalStatsDao globalStatsDao;
    private ReconNamespaceSummaryManagerImpl reconNamespaceSummaryManager;

    @Inject
    public OMDBInsightEndpoint(OzoneStorageContainerManager reconSCM, ReconOMMetadataManager omMetadataManager, GlobalStatsDao globalStatsDao, ReconNamespaceSummaryManagerImpl reconNamespaceSummaryManager) {
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.omMetadataManager = omMetadataManager;
        this.globalStatsDao = globalStatsDao;
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
    }

    @GET
    @Path(value="/open")
    public Response getOpenKeyInfo(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey, @DefaultValue(value="false") @QueryParam(value="includeFso") boolean includeFso, @DefaultValue(value="false") @QueryParam(value="includeNonFso") boolean includeNonFso) {
        KeyInsightInfoResponse openKeyInsightInfo = new KeyInsightInfoResponse();
        List<KeyEntityInfo> nonFSOKeyInfoList = openKeyInsightInfo.getNonFSOKeyInfoList();
        boolean skipPrevKeyDone = false;
        boolean isLegacyBucketLayout = true;
        boolean recordsFetchedLimitReached = false;
        String lastKey = "";
        List<KeyEntityInfo> fsoKeyInfoList = openKeyInsightInfo.getFsoKeyInfoList();
        for (BucketLayout layout : Arrays.asList(BucketLayout.LEGACY, BucketLayout.FILE_SYSTEM_OPTIMIZED)) {
            boolean bl = isLegacyBucketLayout = layout == BucketLayout.LEGACY;
            if (!includeFso && !isLegacyBucketLayout || !includeNonFso && isLegacyBucketLayout) continue;
            Table openKeyTable = this.omMetadataManager.getOpenKeyTable(layout);
            try {
                TableIterator keyIter = openKeyTable.iterator();
                Throwable throwable = null;
                try {
                    boolean skipPrevKey = false;
                    String seekKey = prevKey;
                    if (!skipPrevKeyDone && StringUtils.isNotBlank((CharSequence)prevKey)) {
                        skipPrevKey = true;
                        Table.KeyValue seekKeyValue = (Table.KeyValue)keyIter.seek((Object)seekKey);
                        if (seekKeyValue == null || StringUtils.isNotBlank((CharSequence)prevKey) && !((String)seekKeyValue.getKey()).equals(prevKey)) continue;
                    }
                    while (keyIter.hasNext()) {
                        boolean added;
                        String key;
                        Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                        lastKey = key = (String)kv.getKey();
                        OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                        if (skipPrevKey && key.equals(prevKey)) {
                            skipPrevKeyDone = true;
                            continue;
                        }
                        KeyEntityInfo keyEntityInfo = new KeyEntityInfo();
                        keyEntityInfo.setKey(key);
                        keyEntityInfo.setPath(omKeyInfo.getKeyName());
                        keyEntityInfo.setInStateSince(omKeyInfo.getCreationTime());
                        keyEntityInfo.setSize(omKeyInfo.getDataSize());
                        keyEntityInfo.setReplicatedSize(omKeyInfo.getReplicatedSize());
                        keyEntityInfo.setReplicationConfig(omKeyInfo.getReplicationConfig());
                        openKeyInsightInfo.setUnreplicatedDataSize(openKeyInsightInfo.getUnreplicatedDataSize() + keyEntityInfo.getSize());
                        openKeyInsightInfo.setReplicatedDataSize(openKeyInsightInfo.getReplicatedDataSize() + keyEntityInfo.getReplicatedSize());
                        boolean bl2 = added = isLegacyBucketLayout ? nonFSOKeyInfoList.add(keyEntityInfo) : fsoKeyInfoList.add(keyEntityInfo);
                        if (nonFSOKeyInfoList.size() + fsoKeyInfoList.size() != limit) continue;
                        recordsFetchedLimitReached = true;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (keyIter == null) continue;
                    if (throwable != null) {
                        try {
                            keyIter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    keyIter.close();
                    continue;
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
            catch (Exception ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (!recordsFetchedLimitReached) continue;
            break;
        }
        openKeyInsightInfo.setLastKey(lastKey);
        return Response.ok((Object)openKeyInsightInfo).build();
    }

    @GET
    @Path(value="/open/summary")
    public Response getOpenKeySummary() {
        HashMap<String, Long> keysSummary = new HashMap<String, Long>();
        this.createKeysSummaryForOpenKey(keysSummary);
        return Response.ok(keysSummary).build();
    }

    private void createKeysSummaryForOpenKey(Map<String, Long> keysSummary) {
        Long replicatedSizeOpenKey = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getReplicatedSizeKeyFromTable("openKeyTable")));
        Long replicatedSizeOpenFile = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getReplicatedSizeKeyFromTable("openFileTable")));
        Long unreplicatedSizeOpenKey = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getUnReplicatedSizeKeyFromTable("openKeyTable")));
        Long unreplicatedSizeOpenFile = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getUnReplicatedSizeKeyFromTable("openFileTable")));
        Long openKeyCountForKeyTable = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("openKeyTable")));
        Long openKeyCountForFileTable = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("openFileTable")));
        keysSummary.put("totalOpenKeys", openKeyCountForKeyTable + openKeyCountForFileTable);
        keysSummary.put("totalReplicatedDataSize", replicatedSizeOpenKey + replicatedSizeOpenFile);
        keysSummary.put("totalUnreplicatedDataSize", unreplicatedSizeOpenKey + unreplicatedSizeOpenFile);
    }

    private Long getValueFromId(GlobalStats record) {
        return record != null ? record.getValue() : 0L;
    }

    private void getPendingForDeletionKeyInfo(int limit, String prevKey, KeyInsightInfoResponse deletedKeyAndDirInsightInfo) {
        List<RepeatedOmKeyInfo> repeatedOmKeyInfoList = deletedKeyAndDirInsightInfo.getRepeatedOmKeyInfoList();
        Table deletedTable = this.omMetadataManager.getDeletedTable();
        try (TableIterator keyIter = deletedTable.iterator();){
            boolean skipPrevKey = false;
            String seekKey = prevKey;
            String lastKey = "";
            if (StringUtils.isNotBlank((CharSequence)prevKey)) {
                skipPrevKey = true;
                Table.KeyValue seekKeyValue = (Table.KeyValue)keyIter.seek((Object)seekKey);
                if (seekKeyValue == null || StringUtils.isNotBlank((CharSequence)prevKey) && !((String)seekKeyValue.getKey()).equals(prevKey)) {
                    return;
                }
            }
            while (keyIter.hasNext()) {
                String key;
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                lastKey = key = (String)kv.getKey();
                RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)kv.getValue();
                if (skipPrevKey && key.equals(prevKey)) continue;
                this.updateReplicatedAndUnReplicatedTotal(deletedKeyAndDirInsightInfo, repeatedOmKeyInfo);
                repeatedOmKeyInfoList.add(repeatedOmKeyInfo);
                if (repeatedOmKeyInfoList.size() != limit) continue;
                break;
            }
            deletedKeyAndDirInsightInfo.setLastKey(lastKey);
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/deletePending/summary")
    public Response getDeletedKeySummary() {
        HashMap<String, Long> keysSummary = new HashMap<String, Long>();
        this.createKeysSummaryForDeletedKey(keysSummary);
        return Response.ok(keysSummary).build();
    }

    @GET
    @Path(value="/deletePending")
    public Response getDeletedKeyInfo(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey) {
        KeyInsightInfoResponse deletedKeyInsightInfo = new KeyInsightInfoResponse();
        this.getPendingForDeletionKeyInfo(limit, prevKey, deletedKeyInsightInfo);
        return Response.ok((Object)deletedKeyInsightInfo).build();
    }

    private void createKeysSummaryForDeletedKey(Map<String, Long> keysSummary) {
        Long replicatedSizeDeleted = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getReplicatedSizeKeyFromTable("deletedTable")));
        Long unreplicatedSizeDeleted = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getUnReplicatedSizeKeyFromTable("deletedTable")));
        Long deletedKeyCount = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("deletedTable")));
        keysSummary.put("totalDeletedKeys", deletedKeyCount);
        keysSummary.put("totalReplicatedDataSize", replicatedSizeDeleted);
        keysSummary.put("totalUnreplicatedDataSize", unreplicatedSizeDeleted);
    }

    private void getPendingForDeletionDirInfo(int limit, String prevKey, KeyInsightInfoResponse pendingForDeletionKeyInfo) {
        List<KeyEntityInfo> deletedDirInfoList = pendingForDeletionKeyInfo.getDeletedDirInfoList();
        Table deletedDirTable = this.omMetadataManager.getDeletedDirTable();
        try (TableIterator keyIter = deletedDirTable.iterator();){
            boolean skipPrevKey = false;
            String seekKey = prevKey;
            String lastKey = "";
            if (StringUtils.isNotBlank((CharSequence)prevKey)) {
                skipPrevKey = true;
                Table.KeyValue seekKeyValue = (Table.KeyValue)keyIter.seek((Object)seekKey);
                if (seekKeyValue == null || StringUtils.isNotBlank((CharSequence)prevKey) && !((String)seekKeyValue.getKey()).equals(prevKey)) {
                    return;
                }
            }
            while (keyIter.hasNext()) {
                String key;
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                lastKey = key = (String)kv.getKey();
                OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                if (skipPrevKey && key.equals(prevKey)) continue;
                KeyEntityInfo keyEntityInfo = new KeyEntityInfo();
                keyEntityInfo.setKey(key);
                keyEntityInfo.setPath(omKeyInfo.getKeyName());
                keyEntityInfo.setInStateSince(omKeyInfo.getCreationTime());
                keyEntityInfo.setSize(this.fetchSizeForDeletedDirectory(omKeyInfo.getObjectID()));
                keyEntityInfo.setReplicatedSize(omKeyInfo.getReplicatedSize());
                keyEntityInfo.setReplicationConfig(omKeyInfo.getReplicationConfig());
                pendingForDeletionKeyInfo.setUnreplicatedDataSize(pendingForDeletionKeyInfo.getUnreplicatedDataSize() + keyEntityInfo.getSize());
                pendingForDeletionKeyInfo.setReplicatedDataSize(pendingForDeletionKeyInfo.getReplicatedDataSize() + keyEntityInfo.getReplicatedSize());
                deletedDirInfoList.add(keyEntityInfo);
                if (deletedDirInfoList.size() != limit) continue;
                break;
            }
            pendingForDeletionKeyInfo.setLastKey(lastKey);
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected long fetchSizeForDeletedDirectory(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0L;
        }
        long totalSize = nsSummary.getSizeOfFiles();
        for (long childId : nsSummary.getChildDir()) {
            totalSize += this.fetchSizeForDeletedDirectory(childId);
        }
        return totalSize;
    }

    @GET
    @Path(value="/deletePending/dirs")
    public Response getDeletedDirInfo(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey) {
        KeyInsightInfoResponse deletedDirInsightInfo = new KeyInsightInfoResponse();
        this.getPendingForDeletionDirInfo(limit, prevKey, deletedDirInsightInfo);
        return Response.ok((Object)deletedDirInsightInfo).build();
    }

    private void updateReplicatedAndUnReplicatedTotal(KeyInsightInfoResponse deletedKeyAndDirInsightInfo, RepeatedOmKeyInfo repeatedOmKeyInfo) {
        repeatedOmKeyInfo.getOmKeyInfoList().forEach(omKeyInfo -> {
            deletedKeyAndDirInsightInfo.setUnreplicatedDataSize(deletedKeyAndDirInsightInfo.getUnreplicatedDataSize() + omKeyInfo.getDataSize());
            deletedKeyAndDirInsightInfo.setReplicatedDataSize(deletedKeyAndDirInsightInfo.getReplicatedDataSize() + omKeyInfo.getReplicatedSize());
        });
    }

    @VisibleForTesting
    public GlobalStatsDao getDao() {
        return this.globalStatsDao;
    }

    @VisibleForTesting
    public Table<Long, NSSummary> getNsSummaryTable() {
        return this.reconNamespaceSummaryManager.getNSSummaryTable();
    }
}

