/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.heatmap;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityMetaData;
import org.apache.hadoop.ozone.recon.api.types.EntityReadAccessHeatMapResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.heatmap.IHeatMapProvider;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatMapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HeatMapUtil.class);
    private OzoneConfiguration ozoneConfiguration;
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager omMetadataManager;
    private final OzoneStorageContainerManager reconSCM;

    @Inject
    public HeatMapUtil(ReconNamespaceSummaryManager namespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, OzoneConfiguration ozoneConfiguration) {
        this.reconNamespaceSummaryManager = namespaceSummaryManager;
        this.omMetadataManager = omMetadataManager;
        this.reconSCM = reconSCM;
        this.ozoneConfiguration = ozoneConfiguration;
    }

    private long getEntitySize(String path) throws IOException {
        DUResponse duResponse;
        long entitySize = 0L;
        LOG.info("Getting entity size for {}: ", (Object)path);
        EntityHandler entityHandler = EntityHandler.getEntityHandler(this.reconNamespaceSummaryManager, this.omMetadataManager, this.reconSCM, path);
        if (null != entityHandler && null != (duResponse = entityHandler.getDuResponse(false, false, false)) && duResponse.getStatus() == ResponseStatus.OK) {
            return duResponse.getSize();
        }
        return 256L;
    }

    private static boolean validateLength(String[] split, int minLength) {
        return split.length < minLength;
    }

    private void addBucketData(EntityReadAccessHeatMapResponse rootEntity, EntityReadAccessHeatMapResponse volumeEntity, String[] split, int readAccessCount, long keySize) {
        List<EntityReadAccessHeatMapResponse> children = volumeEntity.getChildren();
        EntityReadAccessHeatMapResponse bucketEntity = null;
        List bucketList = children.stream().filter(entity -> entity.getLabel().equalsIgnoreCase(split[1])).collect(Collectors.toList());
        if (bucketList.size() > 0) {
            bucketEntity = (EntityReadAccessHeatMapResponse)bucketList.get(0);
        }
        if (children.contains(bucketEntity)) {
            this.addPrefixPathInfoToBucket(rootEntity, split, bucketEntity, readAccessCount, keySize);
        } else {
            this.addBucketAndPrefixPath(split, rootEntity, volumeEntity, readAccessCount, keySize);
        }
    }

    private void updateRootLevelMinMaxAccessCount(long readAccessCount, EntityReadAccessHeatMapResponse rootEntity) {
        rootEntity.setMinAccessCount(readAccessCount < rootEntity.getMinAccessCount() ? readAccessCount : rootEntity.getMinAccessCount());
        rootEntity.setMaxAccessCount(readAccessCount > rootEntity.getMaxAccessCount() ? readAccessCount : rootEntity.getMaxAccessCount());
    }

    private void updateBucketSize(EntityReadAccessHeatMapResponse bucket, long keySize) {
        bucket.setSize(bucket.getSize() + keySize);
    }

    private void addPrefixPathInfoToBucket(EntityReadAccessHeatMapResponse rootEntity, String[] split, EntityReadAccessHeatMapResponse bucket, long readAccessCount, long keySize) {
        List<EntityReadAccessHeatMapResponse> prefixes = bucket.getChildren();
        this.updateBucketSize(bucket, keySize);
        String path = Arrays.stream(split).skip(2L).collect(Collectors.joining("/"));
        EntityReadAccessHeatMapResponse prefixPathInfo = new EntityReadAccessHeatMapResponse();
        prefixPathInfo.setLabel(path);
        prefixPathInfo.setPath(bucket.getPath() + "/" + path);
        prefixPathInfo.setAccessCount(readAccessCount);
        prefixPathInfo.setSize(keySize);
        prefixes.add(prefixPathInfo);
        this.updateRootLevelMinMaxAccessCount(readAccessCount, rootEntity);
    }

    private void addBucketAndPrefixPath(String[] split, EntityReadAccessHeatMapResponse rootEntity, EntityReadAccessHeatMapResponse volumeEntity, long readAccessCount, long keySize) {
        List<EntityReadAccessHeatMapResponse> bucketEntities = volumeEntity.getChildren();
        EntityReadAccessHeatMapResponse bucket = new EntityReadAccessHeatMapResponse();
        bucket.setLabel(split[1]);
        bucket.setPath(this.omMetadataManager.getBucketKey(split[0], split[1]));
        bucketEntities.add(bucket);
        bucket.setMinAccessCount(readAccessCount);
        if (split.length > 2) {
            this.addPrefixPathInfoToBucket(rootEntity, split, bucket, readAccessCount, keySize);
        } else {
            this.updateBucketSize(bucket, keySize);
        }
    }

    private void addVolumeData(EntityReadAccessHeatMapResponse rootEntity, String[] split, int readAccessCount, long entitySize) {
        List<EntityReadAccessHeatMapResponse> children = rootEntity.getChildren();
        EntityReadAccessHeatMapResponse volumeInfo = new EntityReadAccessHeatMapResponse();
        volumeInfo.setLabel(split[0]);
        volumeInfo.setPath(split[0]);
        children.add(volumeInfo);
        if (split.length < 2) {
            volumeInfo.setSize(entitySize);
            volumeInfo.setAccessCount(readAccessCount);
            volumeInfo.setMinAccessCount(readAccessCount);
            volumeInfo.setMaxAccessCount(readAccessCount);
            return;
        }
        this.addBucketAndPrefixPath(split, rootEntity, volumeInfo, readAccessCount, entitySize);
    }

    private void setEntityLevelAccessCount(EntityReadAccessHeatMapResponse entity) {
        List<EntityReadAccessHeatMapResponse> children = entity.getChildren();
        children.stream().forEach(child -> entity.setAccessCount(entity.getAccessCount() + child.getAccessCount()));
        if (entity.getAccessCount() > 0L && children.size() > 0) {
            entity.setAccessCount(entity.getAccessCount() / (long)children.size());
        }
    }

    private void updateBucketLevelMinMaxAccessCount(EntityReadAccessHeatMapResponse bucket) {
        List<EntityReadAccessHeatMapResponse> children = HeatMapUtil.initializeEntityMinMaxCount(bucket);
        children.stream().forEach(path -> {
            long readAccessCount = path.getAccessCount();
            bucket.setMinAccessCount(path.getAccessCount() < bucket.getMinAccessCount() ? readAccessCount : bucket.getMinAccessCount());
            bucket.setMaxAccessCount(readAccessCount > bucket.getMaxAccessCount() ? readAccessCount : bucket.getMaxAccessCount());
        });
    }

    private void updateVolumeSize(EntityReadAccessHeatMapResponse volumeInfo) {
        List<EntityReadAccessHeatMapResponse> children = volumeInfo.getChildren();
        children.stream().forEach(bucket -> {
            volumeInfo.setSize(volumeInfo.getSize() + bucket.getSize());
            this.updateBucketLevelMinMaxAccessCount((EntityReadAccessHeatMapResponse)bucket);
        });
    }

    private void updateRootEntitySize(EntityReadAccessHeatMapResponse rootEntity) {
        List<EntityReadAccessHeatMapResponse> children = rootEntity.getChildren();
        children.stream().forEach(volume -> {
            this.updateVolumeSize((EntityReadAccessHeatMapResponse)volume);
            this.updateVolumeLevelMinMaxAccessCount((EntityReadAccessHeatMapResponse)volume);
            this.setEntityLevelAccessCount((EntityReadAccessHeatMapResponse)volume);
            rootEntity.setSize(rootEntity.getSize() + volume.getSize());
        });
    }

    @NotNull
    private static List<EntityReadAccessHeatMapResponse> initializeEntityMinMaxCount(EntityReadAccessHeatMapResponse entity) {
        List<EntityReadAccessHeatMapResponse> children = entity.getChildren();
        if (children.size() == 0) {
            entity.setMaxAccessCount(entity.getMinAccessCount());
        }
        if (children.size() > 0) {
            entity.setMinAccessCount(Long.MAX_VALUE);
        }
        return children;
    }

    private void updateVolumeLevelMinMaxAccessCount(EntityReadAccessHeatMapResponse volume) {
        List<EntityReadAccessHeatMapResponse> children = HeatMapUtil.initializeEntityMinMaxCount(volume);
        children.stream().forEach(child -> {
            long bucketMinAccessCount = child.getMinAccessCount();
            long bucketMaxAccessCount = child.getMaxAccessCount();
            volume.setMinAccessCount(bucketMinAccessCount < volume.getMinAccessCount() ? bucketMinAccessCount : volume.getMinAccessCount());
            volume.setMaxAccessCount(bucketMaxAccessCount > volume.getMaxAccessCount() ? bucketMaxAccessCount : volume.getMaxAccessCount());
        });
    }

    private static double truncate(double value, int decimalPlaces) {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException();
        }
        value *= Math.pow(10.0, decimalPlaces);
        value = Math.floor(value);
        return value /= Math.pow(10.0, decimalPlaces);
    }

    private void updateEntityAccessRatio(EntityReadAccessHeatMapResponse entity) {
        long delta = entity.getMaxAccessCount() - entity.getMinAccessCount();
        List<EntityReadAccessHeatMapResponse> children = entity.getChildren();
        children.stream().forEach(path -> {
            if (path.getChildren().size() != 0) {
                this.updateEntityAccessRatio((EntityReadAccessHeatMapResponse)path);
            } else {
                path.setColor(1.0);
                long accessCount = path.getAccessCount();
                long l = accessCount = accessCount == 0L ? path.getMinAccessCount() : accessCount;
                if (delta >= 0L && accessCount > 0L) {
                    double truncatedValue = HeatMapUtil.truncate((double)accessCount / (double)entity.getMaxAccessCount(), 3);
                    path.setColor(truncatedValue);
                }
            }
        });
    }

    public EntityReadAccessHeatMapResponse generateHeatMap(List<EntityMetaData> entityMetaDataList) {
        EntityReadAccessHeatMapResponse rootEntity = new EntityReadAccessHeatMapResponse();
        rootEntity.setMinAccessCount(entityMetaDataList.get(0).getReadAccessCount());
        rootEntity.setLabel("root");
        rootEntity.setPath("/");
        List<EntityReadAccessHeatMapResponse> children = rootEntity.getChildren();
        entityMetaDataList.forEach(entityMetaData -> {
            String path = entityMetaData.getVal();
            String[] split = path.split("/");
            if (split.length == 0) {
                return;
            }
            long entitySize = 0L;
            try {
                entitySize = this.getEntitySize(path);
            }
            catch (IOException e) {
                LOG.error("IOException while getting key size for key : {} - {}", (Object)path, (Object)e);
            }
            EntityReadAccessHeatMapResponse volumeEntity = null;
            List volumeList = children.stream().filter(entity -> entity.getLabel().equalsIgnoreCase(split[0])).collect(Collectors.toList());
            if (volumeList.size() > 0) {
                volumeEntity = (EntityReadAccessHeatMapResponse)volumeList.get(0);
            }
            if (null != volumeEntity) {
                if (HeatMapUtil.validateLength(split, 2)) {
                    return;
                }
                this.addBucketData(rootEntity, volumeEntity, split, entityMetaData.getReadAccessCount(), entitySize);
            } else {
                if (HeatMapUtil.validateLength(split, 1)) {
                    return;
                }
                this.addVolumeData(rootEntity, split, entityMetaData.getReadAccessCount(), entitySize);
            }
        });
        this.updateRootEntitySize(rootEntity);
        this.updateVolumeLevelMinMaxAccessCount(rootEntity);
        this.updateEntityAccessRatio(rootEntity);
        return rootEntity;
    }

    public EntityReadAccessHeatMapResponse retrieveDataAndGenerateHeatMap(IHeatMapProvider heatMapProvider, String normalizePath, String entityType, String startDate) throws Exception {
        List<EntityMetaData> entityMetaDataList;
        if (null != heatMapProvider && null != (entityMetaDataList = heatMapProvider.retrieveData(normalizePath, entityType, startDate)) && CollectionUtils.isNotEmpty(entityMetaDataList)) {
            return this.generateHeatMap(entityMetaDataList);
        }
        return new EntityReadAccessHeatMapResponse();
    }

    public static IHeatMapProvider loadHeatMapProvider(String className) throws Exception {
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            if (o instanceof IHeatMapProvider) {
                return (IHeatMapProvider)o;
            }
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new Exception(e);
        }
    }
}

