/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconNewNodeHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(ReconNewNodeHandler.class);
    private ReconNodeManager nodeManager;

    public ReconNewNodeHandler(ReconNodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        try {
            this.nodeManager.addNodeToDB(datanodeDetails);
        }
        catch (IOException e) {
            LOG.error("Unable to add new node {} to Node DB.", (Object)datanodeDetails.getUuidString());
        }
    }
}

