/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.compress.utils.CharsetNames;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;

public final class ContainerKeyPrefixCodec
implements Codec<ContainerKeyPrefix> {
    private static final String KEY_DELIMITER = "_";
    private static final Codec<ContainerKeyPrefix> INSTANCE = new ContainerKeyPrefixCodec();

    public static Codec<ContainerKeyPrefix> get() {
        return INSTANCE;
    }

    private ContainerKeyPrefixCodec() {
    }

    public byte[] toPersistedFormat(ContainerKeyPrefix containerKeyPrefix) throws IOException {
        Preconditions.checkNotNull((Object)containerKeyPrefix, (Object)"Null object can't be converted to byte array.");
        byte[] containerIdBytes = Longs.toByteArray((long)containerKeyPrefix.getContainerId());
        if (StringUtils.isNotEmpty((CharSequence)containerKeyPrefix.getKeyPrefix())) {
            byte[] keyPrefixBytes = (KEY_DELIMITER + containerKeyPrefix.getKeyPrefix()).getBytes(CharsetNames.UTF_8);
            containerIdBytes = ArrayUtils.addAll((byte[])containerIdBytes, (byte[])keyPrefixBytes);
        }
        if (containerKeyPrefix.getKeyVersion() != -1L) {
            containerIdBytes = ArrayUtils.addAll((byte[])containerIdBytes, (byte[])KEY_DELIMITER.getBytes(CharsetNames.UTF_8));
            containerIdBytes = ArrayUtils.addAll((byte[])containerIdBytes, (byte[])Longs.toByteArray((long)containerKeyPrefix.getKeyVersion()));
        }
        return containerIdBytes;
    }

    public ContainerKeyPrefix fromPersistedFormat(byte[] rawData) throws IOException {
        long containerIdFromDB = ByteBuffer.wrap(ArrayUtils.subarray((byte[])rawData, (int)0, (int)8)).getLong();
        byte[] keyBytes = ArrayUtils.subarray((byte[])rawData, (int)9, (int)(rawData.length - 8 - 1));
        String keyPrefix = new String(keyBytes, CharsetNames.UTF_8);
        byte[] versionBytes = ArrayUtils.subarray((byte[])rawData, (int)(rawData.length - 8), (int)rawData.length);
        long version = ByteBuffer.wrap(versionBytes).getLong();
        return ContainerKeyPrefix.get(containerIdFromDB, keyPrefix, version);
    }

    public ContainerKeyPrefix copyObject(ContainerKeyPrefix object) {
        return object;
    }
}

