/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.KeyPrefixContainer;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerKeyMapperTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerKeyMapperTask.class);
    private ReconContainerMetadataManager reconContainerMetadataManager;
    private final long containerKeyFlushToDBMaxThreshold;

    @Inject
    public ContainerKeyMapperTask(ReconContainerMetadataManager reconContainerMetadataManager, OzoneConfiguration configuration) {
        this.reconContainerMetadataManager = reconContainerMetadataManager;
        this.containerKeyFlushToDBMaxThreshold = configuration.getLong("ozone.recon.containerkey.flush.db.max.threshold", 150000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        long omKeyCount = 0L;
        HashMap<ContainerKeyPrefix, Integer> containerKeyMap = new HashMap<ContainerKeyPrefix, Integer>();
        HashMap<Long, Long> containerKeyCountMap = new HashMap<Long, Long>();
        try {
            LOG.info("Starting a 'reprocess' run of ContainerKeyMapperTask.");
            Instant start = Instant.now();
            this.reconContainerMetadataManager.reinitWithNewContainerDataFromOm(new HashMap<ContainerKeyPrefix, Integer>());
            for (BucketLayout layout : Arrays.asList(BucketLayout.LEGACY, BucketLayout.FILE_SYSTEM_OPTIMIZED)) {
                Table omKeyInfoTable = omMetadataManager.getKeyTable(layout);
                TableIterator keyIter = omKeyInfoTable.iterator();
                Throwable throwable = null;
                try {
                    while (keyIter.hasNext()) {
                        Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                        OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                        this.handleKeyReprocess((String)kv.getKey(), omKeyInfo, containerKeyMap, containerKeyCountMap);
                        if (!this.checkAndCallFlushToDB(containerKeyMap)) {
                            LOG.error("Unable to flush containerKey information to the DB");
                            ImmutablePair immutablePair = new ImmutablePair((Object)this.getTaskName(), (Object)false);
                            return immutablePair;
                        }
                        ++omKeyCount;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (keyIter == null) continue;
                    if (throwable != null) {
                        try {
                            keyIter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    keyIter.close();
                }
            }
            if (!this.flushAndCommitContainerKeyInfoToDB(containerKeyMap, containerKeyCountMap)) {
                LOG.error("Unable to flush Container Key Count and remaining Container Key information to the DB");
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
            LOG.info("Completed 'reprocess' of ContainerKeyMapperTask.");
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("It took me {} seconds to process {} keys.", (Object)((double)duration / 1000.0), (Object)omKeyCount);
            return new ImmutablePair((Object)this.getTaskName(), (Object)true);
        }
        catch (IOException ioEx) {
            LOG.error("Unable to populate Container Key data in Recon DB. ", (Throwable)ioEx);
            return new ImmutablePair((Object)this.getTaskName(), (Object)false);
        }
    }

    private boolean flushAndCommitContainerKeyInfoToDB(Map<ContainerKeyPrefix, Integer> containerKeyMap, Map<Long, Long> containerKeyCountMap) {
        try {
            this.writeToTheDB(containerKeyMap, containerKeyCountMap, Collections.emptyList());
            containerKeyMap.clear();
            containerKeyCountMap.clear();
        }
        catch (IOException e) {
            LOG.error("Unable to write Container Key and Container Key Count data in Recon DB.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean checkAndCallFlushToDB(Map<ContainerKeyPrefix, Integer> containerKeyMap) {
        if (null != containerKeyMap && (long)containerKeyMap.size() >= this.containerKeyFlushToDBMaxThreshold) {
            return this.flushAndCommitContainerKeyInfoToDB(containerKeyMap, Collections.emptyMap());
        }
        return true;
    }

    @Override
    public String getTaskName() {
        return "ContainerKeyMapperTask";
    }

    public Collection<String> getTaskTables() {
        ArrayList<String> taskTables = new ArrayList<String>();
        taskTables.add("keyTable");
        taskTables.add("fileTable");
        return taskTables;
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        int eventCount = 0;
        Collection<String> taskTables = this.getTaskTables();
        HashMap<ContainerKeyPrefix, Integer> containerKeyMap = new HashMap<ContainerKeyPrefix, Integer>();
        HashMap<Long, Long> containerKeyCountMap = new HashMap<Long, Long>();
        ArrayList<ContainerKeyPrefix> deletedKeyCountList = new ArrayList<ContainerKeyPrefix>();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            if (!taskTables.contains(omdbUpdateEvent.getTable())) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            OmKeyInfo updatedKeyValue = (OmKeyInfo)omdbUpdateEvent.getValue();
            try {
                switch (omdbUpdateEvent.getAction()) {
                    case PUT: {
                        this.handlePutOMKeyEvent(updatedKey, updatedKeyValue, containerKeyMap, containerKeyCountMap, deletedKeyCountList);
                        break;
                    }
                    case DELETE: {
                        this.handleDeleteOMKeyEvent(updatedKey, containerKeyMap, containerKeyCountMap, deletedKeyCountList);
                        break;
                    }
                    case UPDATE: {
                        if (omdbUpdateEvent.getOldValue() != null) {
                            this.handleDeleteOMKeyEvent(((OmKeyInfo)omdbUpdateEvent.getOldValue()).getKeyName(), containerKeyMap, containerKeyCountMap, deletedKeyCountList);
                        } else {
                            LOG.warn("Update event does not have the old Key Info for {}.", (Object)updatedKey);
                        }
                        this.handlePutOMKeyEvent(updatedKey, updatedKeyValue, containerKeyMap, containerKeyCountMap, deletedKeyCountList);
                        break;
                    }
                    default: {
                        LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                    }
                }
                ++eventCount;
            }
            catch (IOException e) {
                LOG.error("Unexpected exception while updating key data : {} ", (Object)updatedKey, (Object)e);
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        try {
            this.writeToTheDB(containerKeyMap, containerKeyCountMap, deletedKeyCountList);
        }
        catch (IOException e) {
            LOG.error("Unable to write Container Key Prefix data in Recon DB.", (Throwable)e);
            return new ImmutablePair((Object)this.getTaskName(), (Object)false);
        }
        LOG.info("{} successfully processed {} OM DB update event(s).", (Object)this.getTaskName(), (Object)eventCount);
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private void writeToTheDB(Map<ContainerKeyPrefix, Integer> containerKeyMap, Map<Long, Long> containerKeyCountMap, List<ContainerKeyPrefix> deletedContainerKeyList) throws IOException {
        try (RDBBatchOperation rdbBatchOperation = new RDBBatchOperation();){
            containerKeyMap.keySet().forEach(key -> {
                try {
                    this.reconContainerMetadataManager.batchStoreContainerKeyMapping((BatchOperation)rdbBatchOperation, (ContainerKeyPrefix)key, (Integer)containerKeyMap.get(key));
                }
                catch (IOException e) {
                    LOG.error("Unable to write Container Key Prefix data in Recon DB.", (Throwable)e);
                }
            });
            containerKeyCountMap.keySet().forEach(key -> {
                try {
                    this.reconContainerMetadataManager.batchStoreContainerKeyCounts((BatchOperation)rdbBatchOperation, (Long)key, (Long)containerKeyCountMap.get(key));
                }
                catch (IOException e) {
                    LOG.error("Unable to write Container Key Prefix data in Recon DB.", (Throwable)e);
                }
            });
            deletedContainerKeyList.forEach(key -> {
                try {
                    this.reconContainerMetadataManager.batchDeleteContainerMapping((BatchOperation)rdbBatchOperation, (ContainerKeyPrefix)key);
                }
                catch (IOException e) {
                    LOG.error("Unable to write Container Key Prefix data in Recon DB.", (Throwable)e);
                }
            });
            this.reconContainerMetadataManager.commitBatchOperation(rdbBatchOperation);
        }
    }

    private void handleDeleteOMKeyEvent(String key, Map<ContainerKeyPrefix, Integer> containerKeyMap, Map<Long, Long> containerKeyCountMap, List<ContainerKeyPrefix> deletedContainerKeyList) throws IOException {
        HashSet<ContainerKeyPrefix> keysToBeDeleted = new HashSet<ContainerKeyPrefix>();
        try (TableIterator keyContainerIterator = this.reconContainerMetadataManager.getKeyContainerTableIterator();){
            Table.KeyValue keyValue;
            String keyPrefix;
            keyContainerIterator.seek((Object)KeyPrefixContainer.get(key));
            while (keyContainerIterator.hasNext() && (keyPrefix = ((KeyPrefixContainer)(keyValue = (Table.KeyValue)keyContainerIterator.next()).getKey()).getKeyPrefix()).equals(key)) {
                if (((KeyPrefixContainer)keyValue.getKey()).getContainerId() == -1L) continue;
                keysToBeDeleted.add(((KeyPrefixContainer)keyValue.getKey()).toContainerKeyPrefix());
            }
        }
        containerKeyMap.keySet().forEach(containerKeyPrefix -> {
            String keyPrefix = containerKeyPrefix.getKeyPrefix();
            if (keyPrefix.equals(key)) {
                keysToBeDeleted.add((ContainerKeyPrefix)containerKeyPrefix);
            }
        });
        for (ContainerKeyPrefix containerKeyPrefix2 : keysToBeDeleted) {
            deletedContainerKeyList.add(containerKeyPrefix2);
            containerKeyMap.remove(containerKeyPrefix2);
            Long containerID = containerKeyPrefix2.getContainerId();
            long keyCount = containerKeyCountMap.containsKey(containerID) ? containerKeyCountMap.get(containerID).longValue() : this.reconContainerMetadataManager.getKeyCountForContainer(containerID);
            if (keyCount <= 0L) continue;
            containerKeyCountMap.put(containerID, --keyCount);
        }
    }

    private void handlePutOMKeyEvent(String key, OmKeyInfo omKeyInfo, Map<ContainerKeyPrefix, Integer> containerKeyMap, Map<Long, Long> containerKeyCountMap, List<ContainerKeyPrefix> deletedContainerKeyList) throws IOException {
        long containerCountToIncrement = 0L;
        for (OmKeyLocationInfoGroup omKeyLocationInfoGroup : omKeyInfo.getKeyLocationVersions()) {
            long keyVersion = omKeyLocationInfoGroup.getVersion();
            for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getLocationList()) {
                long containerId = omKeyLocationInfo.getContainerID();
                ContainerKeyPrefix containerKeyPrefix = ContainerKeyPrefix.get(containerId, key, keyVersion);
                if (this.reconContainerMetadataManager.getCountForContainerKeyPrefix(containerKeyPrefix) != 0 || containerKeyMap.containsKey(containerKeyPrefix)) continue;
                containerKeyMap.put(containerKeyPrefix, 1);
                deletedContainerKeyList.remove(containerKeyPrefix);
                if (!this.reconContainerMetadataManager.doesContainerExists(containerId) && !containerKeyCountMap.containsKey(containerId)) {
                    ++containerCountToIncrement;
                }
                long keyCount = containerKeyCountMap.containsKey(containerId) ? containerKeyCountMap.get(containerId).longValue() : this.reconContainerMetadataManager.getKeyCountForContainer(containerId);
                containerKeyCountMap.put(containerId, ++keyCount);
            }
        }
        if (containerCountToIncrement > 0L) {
            this.reconContainerMetadataManager.incrementContainerCountBy(containerCountToIncrement);
        }
    }

    private void handleKeyReprocess(String key, OmKeyInfo omKeyInfo, Map<ContainerKeyPrefix, Integer> containerKeyMap, Map<Long, Long> containerKeyCountMap) throws IOException {
        long containerCountToIncrement = 0L;
        for (OmKeyLocationInfoGroup omKeyLocationInfoGroup : omKeyInfo.getKeyLocationVersions()) {
            long keyVersion = omKeyLocationInfoGroup.getVersion();
            for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getLocationList()) {
                long keyCount;
                long containerId = omKeyLocationInfo.getContainerID();
                ContainerKeyPrefix containerKeyPrefix = ContainerKeyPrefix.get(containerId, key, keyVersion);
                if (this.reconContainerMetadataManager.getCountForContainerKeyPrefix(containerKeyPrefix) != 0 || containerKeyMap.containsKey(containerKeyPrefix)) continue;
                containerKeyMap.put(containerKeyPrefix, 1);
                if (containerKeyCountMap.containsKey(containerId)) {
                    keyCount = containerKeyCountMap.get(containerId);
                } else {
                    ++containerCountToIncrement;
                    keyCount = 0L;
                }
                containerKeyCountMap.put(containerId, ++keyCount);
            }
        }
        if (containerCountToIncrement > 0L) {
            this.reconContainerMetadataManager.incrementContainerCountBy(containerCountToIncrement);
        }
    }
}

