/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerPolicy
extends RangerBaseModelObject
implements Serializable {
    public static final int POLICY_TYPE_ACCESS = 0;
    public static final int POLICY_TYPE_DATAMASK = 1;
    public static final int POLICY_TYPE_ROWFILTER = 2;
    public static final int POLICY_TYPE_AUDIT = 3;
    public static final int[] POLICY_TYPES = new int[]{0, 1, 2};
    public static final String MASK_TYPE_NULL = "MASK_NULL";
    public static final String MASK_TYPE_NONE = "MASK_NONE";
    public static final String MASK_TYPE_CUSTOM = "CUSTOM";
    public static final int POLICY_PRIORITY_NORMAL = 0;
    public static final int POLICY_PRIORITY_OVERRIDE = 1;
    public static final String POLICY_PRIORITY_NAME_NORMAL = "NORMAL";
    public static final String POLICY_PRIORITY_NAME_OVERRIDE = "OVERRIDE";
    public static final Comparator<RangerPolicy> POLICY_ID_COMPARATOR = new PolicyIdComparator();
    private static final long serialVersionUID = 1L;
    private String service;
    private String name;
    private Integer policyType;
    private Integer policyPriority;
    private String description;
    private String resourceSignature;
    private Boolean isAuditEnabled;
    private Map<String, RangerPolicyResource> resources;
    private List<RangerPolicyItemCondition> conditions;
    private List<RangerPolicyItem> policyItems;
    private List<RangerPolicyItem> denyPolicyItems;
    private List<RangerPolicyItem> allowExceptions;
    private List<RangerPolicyItem> denyExceptions;
    private List<RangerDataMaskPolicyItem> dataMaskPolicyItems;
    private List<RangerRowFilterPolicyItem> rowFilterPolicyItems;
    private String serviceType;
    private Map<String, Object> options;
    private List<RangerValiditySchedule> validitySchedules;
    private List<String> policyLabels;
    private String zoneName;
    private Boolean isDenyAllElse;

    public RangerPolicy() {
        this(null, null, null, null, null, null, null, null, null, null, null);
    }

    public RangerPolicy(String service, String name, Integer policyType, Integer policyPriority, String description, Map<String, RangerPolicyResource> resources, List<RangerPolicyItem> policyItems, String resourceSignature, Map<String, Object> options, List<RangerValiditySchedule> validitySchedules, List<String> policyLables) {
        this(service, name, policyType, policyPriority, description, resources, policyItems, resourceSignature, options, validitySchedules, policyLables, null);
    }

    public RangerPolicy(String service, String name, Integer policyType, Integer policyPriority, String description, Map<String, RangerPolicyResource> resources, List<RangerPolicyItem> policyItems, String resourceSignature, Map<String, Object> options, List<RangerValiditySchedule> validitySchedules, List<String> policyLables, String zoneName) {
        this(service, name, policyType, policyPriority, description, resources, policyItems, resourceSignature, options, validitySchedules, policyLables, zoneName, null);
    }

    public RangerPolicy(String service, String name, Integer policyType, Integer policyPriority, String description, Map<String, RangerPolicyResource> resources, List<RangerPolicyItem> policyItems, String resourceSignature, Map<String, Object> options, List<RangerValiditySchedule> validitySchedules, List<String> policyLables, String zoneName, List<RangerPolicyItemCondition> conditions) {
        this(service, name, policyType, policyPriority, description, resources, policyItems, resourceSignature, options, validitySchedules, policyLables, zoneName, conditions, null);
    }

    public RangerPolicy(String service, String name, Integer policyType, Integer policyPriority, String description, Map<String, RangerPolicyResource> resources, List<RangerPolicyItem> policyItems, String resourceSignature, Map<String, Object> options, List<RangerValiditySchedule> validitySchedules, List<String> policyLables, String zoneName, List<RangerPolicyItemCondition> conditions, Boolean isDenyAllElse) {
        this.setService(service);
        this.setName(name);
        this.setPolicyType(policyType);
        this.setPolicyPriority(policyPriority);
        this.setDescription(description);
        this.setResourceSignature(resourceSignature);
        this.setIsAuditEnabled(null);
        this.setResources(resources);
        this.setPolicyItems(policyItems);
        this.setDenyPolicyItems(null);
        this.setAllowExceptions(null);
        this.setDenyExceptions(null);
        this.setDataMaskPolicyItems(null);
        this.setRowFilterPolicyItems(null);
        this.setOptions(options);
        this.setValiditySchedules(validitySchedules);
        this.setPolicyLabels(policyLables);
        this.setZoneName(zoneName);
        this.setConditions(conditions);
        this.setIsDenyAllElse(isDenyAllElse);
    }

    public void updateFrom(RangerPolicy other) {
        super.updateFrom(other);
        this.setService(other.getService());
        this.setName(other.getName());
        this.setPolicyType(other.getPolicyType());
        this.setPolicyPriority(other.getPolicyPriority());
        this.setDescription(other.getDescription());
        this.setResourceSignature(other.getResourceSignature());
        this.setIsAuditEnabled(other.getIsAuditEnabled());
        this.setResources(other.getResources());
        this.setConditions(other.getConditions());
        this.setPolicyItems(other.getPolicyItems());
        this.setDenyPolicyItems(other.getDenyPolicyItems());
        this.setAllowExceptions(other.getAllowExceptions());
        this.setDenyExceptions(other.getDenyExceptions());
        this.setDataMaskPolicyItems(other.getDataMaskPolicyItems());
        this.setRowFilterPolicyItems(other.getRowFilterPolicyItems());
        this.setServiceType(other.getServiceType());
        this.setOptions(other.getOptions());
        this.setValiditySchedules(other.getValiditySchedules());
        this.setPolicyLabels(other.getPolicyLabels());
        this.setZoneName(other.getZoneName());
        this.setIsDenyAllElse(other.getIsDenyAllElse());
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(Integer policyType) {
        this.policyType = policyType;
    }

    public Integer getPolicyPriority() {
        return this.policyPriority;
    }

    public void setPolicyPriority(Integer policyPriority) {
        this.policyPriority = policyPriority == null ? 0 : policyPriority;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResourceSignature() {
        return this.resourceSignature;
    }

    public void setResourceSignature(String resourceSignature) {
        this.resourceSignature = resourceSignature;
    }

    public Boolean getIsAuditEnabled() {
        return this.isAuditEnabled;
    }

    public void setIsAuditEnabled(Boolean isAuditEnabled) {
        this.isAuditEnabled = isAuditEnabled == null ? Boolean.TRUE : isAuditEnabled;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public List<String> getPolicyLabels() {
        return this.policyLabels;
    }

    public void setPolicyLabels(List<String> policyLabels) {
        if (this.policyLabels == null) {
            this.policyLabels = new ArrayList<String>();
        }
        if (this.policyLabels == policyLabels) {
            return;
        }
        this.policyLabels.clear();
        if (policyLabels != null) {
            this.policyLabels.addAll(policyLabels);
        }
    }

    public Map<String, RangerPolicyResource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, RangerPolicyResource> resources) {
        if (this.resources == null) {
            this.resources = new HashMap<String, RangerPolicyResource>();
        }
        if (this.resources == resources) {
            return;
        }
        this.resources.clear();
        if (resources != null) {
            for (Map.Entry<String, RangerPolicyResource> e : resources.entrySet()) {
                this.resources.put(e.getKey(), e.getValue());
            }
        }
    }

    public List<RangerPolicyItem> getPolicyItems() {
        return this.policyItems;
    }

    public void setPolicyItems(List<RangerPolicyItem> policyItems) {
        if (this.policyItems == null) {
            this.policyItems = new ArrayList<RangerPolicyItem>();
        }
        if (this.policyItems == policyItems) {
            return;
        }
        this.policyItems.clear();
        if (policyItems != null) {
            this.policyItems.addAll(policyItems);
        }
    }

    public List<RangerPolicyItem> getDenyPolicyItems() {
        return this.denyPolicyItems;
    }

    public void setDenyPolicyItems(List<RangerPolicyItem> denyPolicyItems) {
        if (this.denyPolicyItems == null) {
            this.denyPolicyItems = new ArrayList<RangerPolicyItem>();
        }
        if (this.denyPolicyItems == denyPolicyItems) {
            return;
        }
        this.denyPolicyItems.clear();
        if (denyPolicyItems != null) {
            this.denyPolicyItems.addAll(denyPolicyItems);
        }
    }

    public List<RangerPolicyItem> getAllowExceptions() {
        return this.allowExceptions;
    }

    public void setAllowExceptions(List<RangerPolicyItem> allowExceptions) {
        if (this.allowExceptions == null) {
            this.allowExceptions = new ArrayList<RangerPolicyItem>();
        }
        if (this.allowExceptions == allowExceptions) {
            return;
        }
        this.allowExceptions.clear();
        if (allowExceptions != null) {
            this.allowExceptions.addAll(allowExceptions);
        }
    }

    public List<RangerPolicyItem> getDenyExceptions() {
        return this.denyExceptions;
    }

    public void setDenyExceptions(List<RangerPolicyItem> denyExceptions) {
        if (this.denyExceptions == null) {
            this.denyExceptions = new ArrayList<RangerPolicyItem>();
        }
        if (this.denyExceptions == denyExceptions) {
            return;
        }
        this.denyExceptions.clear();
        if (denyExceptions != null) {
            this.denyExceptions.addAll(denyExceptions);
        }
    }

    public List<RangerDataMaskPolicyItem> getDataMaskPolicyItems() {
        return this.dataMaskPolicyItems;
    }

    public void setDataMaskPolicyItems(List<RangerDataMaskPolicyItem> dataMaskPolicyItems) {
        if (this.dataMaskPolicyItems == null) {
            this.dataMaskPolicyItems = new ArrayList<RangerDataMaskPolicyItem>();
        }
        if (this.dataMaskPolicyItems == dataMaskPolicyItems) {
            return;
        }
        this.dataMaskPolicyItems.clear();
        if (dataMaskPolicyItems != null) {
            this.dataMaskPolicyItems.addAll(dataMaskPolicyItems);
        }
    }

    public List<RangerRowFilterPolicyItem> getRowFilterPolicyItems() {
        return this.rowFilterPolicyItems;
    }

    public void setRowFilterPolicyItems(List<RangerRowFilterPolicyItem> rowFilterPolicyItems) {
        if (this.rowFilterPolicyItems == null) {
            this.rowFilterPolicyItems = new ArrayList<RangerRowFilterPolicyItem>();
        }
        if (this.rowFilterPolicyItems == rowFilterPolicyItems) {
            return;
        }
        this.rowFilterPolicyItems.clear();
        if (rowFilterPolicyItems != null) {
            this.rowFilterPolicyItems.addAll(rowFilterPolicyItems);
        }
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        if (this.options == options) {
            return;
        }
        this.options.clear();
        if (options != null) {
            for (Map.Entry<String, Object> e : options.entrySet()) {
                this.options.put(e.getKey(), e.getValue());
            }
        }
    }

    public List<RangerValiditySchedule> getValiditySchedules() {
        return this.validitySchedules;
    }

    public void setValiditySchedules(List<RangerValiditySchedule> validitySchedules) {
        if (this.validitySchedules == null) {
            this.validitySchedules = new ArrayList<RangerValiditySchedule>();
        }
        if (this.validitySchedules == validitySchedules) {
            return;
        }
        this.validitySchedules.clear();
        if (validitySchedules != null) {
            this.validitySchedules.addAll(validitySchedules);
        }
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public List<RangerPolicyItemCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<RangerPolicyItemCondition> conditions) {
        this.conditions = conditions;
    }

    public Boolean getIsDenyAllElse() {
        return this.isDenyAllElse;
    }

    public void setIsDenyAllElse(Boolean isDenyAllElse) {
        this.isDenyAllElse = isDenyAllElse == null ? Boolean.FALSE : isDenyAllElse;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPolicy={");
        super.toString(sb);
        sb.append("service={").append(this.service).append("} ");
        sb.append("name={").append(this.name).append("} ");
        sb.append("policyType={").append(this.policyType).append("} ");
        sb.append("policyPriority={").append(this.policyPriority).append("} ");
        sb.append("description={").append(this.description).append("} ");
        sb.append("resourceSignature={").append(this.resourceSignature).append("} ");
        sb.append("isAuditEnabled={").append(this.isAuditEnabled).append("} ");
        sb.append("serviceType={").append(this.serviceType).append("} ");
        sb.append("resources={");
        if (this.resources != null) {
            for (Map.Entry<String, RangerPolicyResource> entry : this.resources.entrySet()) {
                sb.append(entry.getKey()).append("={");
                entry.getValue().toString(sb);
                sb.append("} ");
            }
        }
        sb.append("} ");
        sb.append("policyLabels={");
        if (this.policyLabels != null) {
            for (String string : this.policyLabels) {
                if (string == null) continue;
                sb.append(string).append(" ");
            }
        }
        sb.append("} ");
        sb.append("policyConditions={");
        if (this.conditions != null) {
            for (RangerPolicyItemCondition rangerPolicyItemCondition : this.conditions) {
                if (rangerPolicyItemCondition == null) continue;
                rangerPolicyItemCondition.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("policyItems={");
        if (this.policyItems != null) {
            for (RangerPolicyItem rangerPolicyItem : this.policyItems) {
                if (rangerPolicyItem == null) continue;
                rangerPolicyItem.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("denyPolicyItems={");
        if (this.denyPolicyItems != null) {
            for (RangerPolicyItem rangerPolicyItem : this.denyPolicyItems) {
                if (rangerPolicyItem == null) continue;
                rangerPolicyItem.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("allowExceptions={");
        if (this.allowExceptions != null) {
            for (RangerPolicyItem rangerPolicyItem : this.allowExceptions) {
                if (rangerPolicyItem == null) continue;
                rangerPolicyItem.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("denyExceptions={");
        if (this.denyExceptions != null) {
            for (RangerPolicyItem rangerPolicyItem : this.denyExceptions) {
                if (rangerPolicyItem == null) continue;
                rangerPolicyItem.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("dataMaskPolicyItems={");
        if (this.dataMaskPolicyItems != null) {
            for (RangerDataMaskPolicyItem rangerDataMaskPolicyItem : this.dataMaskPolicyItems) {
                if (rangerDataMaskPolicyItem == null) continue;
                rangerDataMaskPolicyItem.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("rowFilterPolicyItems={");
        if (this.rowFilterPolicyItems != null) {
            for (RangerRowFilterPolicyItem rangerRowFilterPolicyItem : this.rowFilterPolicyItems) {
                if (rangerRowFilterPolicyItem == null) continue;
                rangerRowFilterPolicyItem.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("options={");
        if (this.options != null) {
            for (Map.Entry entry : this.options.entrySet()) {
                sb.append((String)entry.getKey()).append("={");
                sb.append(entry.getValue().toString());
                sb.append("} ");
            }
        }
        sb.append("} ");
        sb.append("validitySchedules={");
        if (CollectionUtils.isNotEmpty(this.validitySchedules)) {
            for (RangerValiditySchedule rangerValiditySchedule : this.validitySchedules) {
                if (rangerValiditySchedule == null) continue;
                sb.append("schedule={").append(rangerValiditySchedule).append("}");
            }
        }
        sb.append(", zoneName=").append(this.zoneName);
        sb.append(", isDenyAllElse={").append(this.isDenyAllElse).append("} ");
        sb.append("}");
        sb.append("}");
        return sb;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyItemRowFilterInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String filterExpr;

        public RangerPolicyItemRowFilterInfo() {
        }

        public RangerPolicyItemRowFilterInfo(String filterExpr) {
            this.setFilterExpr(filterExpr);
        }

        public RangerPolicyItemRowFilterInfo(RangerPolicyItemRowFilterInfo that) {
            this.filterExpr = that.filterExpr;
        }

        public String getFilterExpr() {
            return this.filterExpr;
        }

        public void setFilterExpr(String filterExpr) {
            this.filterExpr = filterExpr;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.filterExpr == null ? 0 : this.filterExpr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyItemRowFilterInfo other = (RangerPolicyItemRowFilterInfo)obj;
            return !(this.filterExpr == null ? other.filterExpr != null : !this.filterExpr.equals(other.filterExpr));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyItemRowFilterInfo={");
            sb.append("filterExpr={").append(this.filterExpr).append("} ");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyItemDataMaskInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String dataMaskType;
        private String conditionExpr;
        private String valueExpr;

        public RangerPolicyItemDataMaskInfo() {
        }

        public RangerPolicyItemDataMaskInfo(String dataMaskType, String conditionExpr, String valueExpr) {
            this.setDataMaskType(dataMaskType);
            this.setConditionExpr(conditionExpr);
            this.setValueExpr(valueExpr);
        }

        public RangerPolicyItemDataMaskInfo(RangerPolicyItemDataMaskInfo that) {
            this.dataMaskType = that.dataMaskType;
            this.conditionExpr = that.conditionExpr;
            this.valueExpr = that.valueExpr;
        }

        public String getDataMaskType() {
            return this.dataMaskType;
        }

        public void setDataMaskType(String dataMaskType) {
            this.dataMaskType = dataMaskType;
        }

        public String getConditionExpr() {
            return this.conditionExpr;
        }

        public void setConditionExpr(String conditionExpr) {
            this.conditionExpr = conditionExpr;
        }

        public String getValueExpr() {
            return this.valueExpr;
        }

        public void setValueExpr(String valueExpr) {
            this.valueExpr = valueExpr;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.dataMaskType == null ? 0 : this.dataMaskType.hashCode());
            result = 31 * result + (this.conditionExpr == null ? 0 : this.conditionExpr.hashCode());
            result = 31 * result + (this.valueExpr == null ? 0 : this.valueExpr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyItemDataMaskInfo other = (RangerPolicyItemDataMaskInfo)obj;
            if (this.dataMaskType == null ? other.dataMaskType != null : !this.dataMaskType.equals(other.dataMaskType)) {
                return false;
            }
            if (this.conditionExpr == null ? other.conditionExpr != null : !this.conditionExpr.equals(other.conditionExpr)) {
                return false;
            }
            return !(this.valueExpr == null ? other.valueExpr != null : !this.valueExpr.equals(other.valueExpr));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyItemDataMaskInfo={");
            sb.append("dataMaskType={").append(this.dataMaskType).append("} ");
            sb.append("conditionExpr={").append(this.conditionExpr).append("} ");
            sb.append("valueExpr={").append(this.valueExpr).append("} ");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyItemCondition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String type;
        private List<String> values;

        public RangerPolicyItemCondition() {
            this(null, null);
        }

        public RangerPolicyItemCondition(String type, List<String> values) {
            this.setType(type);
            this.setValues(values);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            if (this.values == values) {
                return;
            }
            this.values.clear();
            if (values != null) {
                this.values.addAll(values);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyCondition={");
            sb.append("type={").append(this.type).append("} ");
            sb.append("values={");
            if (this.values != null) {
                for (String value : this.values) {
                    sb.append(value).append(" ");
                }
            }
            sb.append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyItemCondition other = (RangerPolicyItemCondition)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyItemAccess
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String type;
        private Boolean isAllowed;

        public RangerPolicyItemAccess() {
            this(null, null);
        }

        public RangerPolicyItemAccess(String type) {
            this(type, null);
        }

        public RangerPolicyItemAccess(String type, Boolean isAllowed) {
            this.setType(type);
            this.setIsAllowed(isAllowed);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Boolean getIsAllowed() {
            return this.isAllowed;
        }

        public void setIsAllowed(Boolean isAllowed) {
            this.isAllowed = isAllowed == null ? Boolean.TRUE : isAllowed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyItemAccess={");
            sb.append("type={").append(this.type).append("} ");
            sb.append("isAllowed={").append(this.isAllowed).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isAllowed == null ? 0 : this.isAllowed.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyItemAccess other = (RangerPolicyItemAccess)obj;
            if (this.isAllowed == null ? other.isAllowed != null : !this.isAllowed.equals(other.isAllowed)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerRowFilterPolicyItem
    extends RangerPolicyItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private RangerPolicyItemRowFilterInfo rowFilterInfo;

        public RangerRowFilterPolicyItem() {
            this(null, null, null, null, null, null, null);
        }

        public RangerRowFilterPolicyItem(RangerPolicyItemRowFilterInfo rowFilterInfo, List<RangerPolicyItemAccess> accesses, List<String> users, List<String> groups, List<String> roles, List<RangerPolicyItemCondition> conditions, Boolean delegateAdmin) {
            super(accesses, users, groups, roles, conditions, delegateAdmin);
            this.setRowFilterInfo(rowFilterInfo);
        }

        public RangerPolicyItemRowFilterInfo getRowFilterInfo() {
            return this.rowFilterInfo;
        }

        public void setRowFilterInfo(RangerPolicyItemRowFilterInfo rowFilterInfo) {
            this.rowFilterInfo = rowFilterInfo == null ? new RangerPolicyItemRowFilterInfo() : rowFilterInfo;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.rowFilterInfo == null ? 0 : this.rowFilterInfo.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerRowFilterPolicyItem other = (RangerRowFilterPolicyItem)obj;
            return !(this.rowFilterInfo == null ? other.rowFilterInfo != null : !this.rowFilterInfo.equals(other.rowFilterInfo));
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerRowFilterPolicyItem={");
            super.toString(sb);
            sb.append("rowFilterInfo={");
            if (this.rowFilterInfo != null) {
                this.rowFilterInfo.toString(sb);
            }
            sb.append("} ");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerDataMaskPolicyItem
    extends RangerPolicyItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private RangerPolicyItemDataMaskInfo dataMaskInfo;

        public RangerDataMaskPolicyItem() {
            this(null, null, null, null, null, null, null);
        }

        public RangerDataMaskPolicyItem(List<RangerPolicyItemAccess> accesses, RangerPolicyItemDataMaskInfo dataMaskDetail, List<String> users, List<String> groups, List<String> roles, List<RangerPolicyItemCondition> conditions, Boolean delegateAdmin) {
            super(accesses, users, groups, roles, conditions, delegateAdmin);
            this.setDataMaskInfo(dataMaskDetail);
        }

        public RangerPolicyItemDataMaskInfo getDataMaskInfo() {
            return this.dataMaskInfo;
        }

        public void setDataMaskInfo(RangerPolicyItemDataMaskInfo dataMaskInfo) {
            this.dataMaskInfo = dataMaskInfo == null ? new RangerPolicyItemDataMaskInfo() : dataMaskInfo;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.dataMaskInfo == null ? 0 : this.dataMaskInfo.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerDataMaskPolicyItem other = (RangerDataMaskPolicyItem)obj;
            return !(this.dataMaskInfo == null ? other.dataMaskInfo != null : !this.dataMaskInfo.equals(other.dataMaskInfo));
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerDataMaskPolicyItem={");
            super.toString(sb);
            sb.append("dataMaskInfo={");
            if (this.dataMaskInfo != null) {
                this.dataMaskInfo.toString(sb);
            }
            sb.append("} ");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RangerPolicyItemAccess> accesses;
        private List<String> users;
        private List<String> groups;
        private List<String> roles;
        private List<RangerPolicyItemCondition> conditions;
        private Boolean delegateAdmin;

        public RangerPolicyItem() {
            this(null, null, null, null, null, null);
        }

        public RangerPolicyItem(List<RangerPolicyItemAccess> accessTypes, List<String> users, List<String> groups, List<String> roles, List<RangerPolicyItemCondition> conditions, Boolean delegateAdmin) {
            this.setAccesses(accessTypes);
            this.setUsers(users);
            this.setGroups(groups);
            this.setRoles(roles);
            this.setConditions(conditions);
            this.setDelegateAdmin(delegateAdmin);
        }

        public List<RangerPolicyItemAccess> getAccesses() {
            return this.accesses;
        }

        public void setAccesses(List<RangerPolicyItemAccess> accesses) {
            if (this.accesses == null) {
                this.accesses = new ArrayList<RangerPolicyItemAccess>();
            }
            if (this.accesses == accesses) {
                return;
            }
            this.accesses.clear();
            if (accesses != null) {
                this.accesses.addAll(accesses);
            }
        }

        public List<String> getUsers() {
            return this.users;
        }

        public void setUsers(List<String> users) {
            if (this.users == null) {
                this.users = new ArrayList<String>();
            }
            if (this.users == users) {
                return;
            }
            this.users.clear();
            if (users != null) {
                this.users.addAll(users);
            }
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public void setGroups(List<String> groups) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            if (this.groups == groups) {
                return;
            }
            this.groups.clear();
            if (groups != null) {
                this.groups.addAll(groups);
            }
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            if (this.roles == roles) {
                return;
            }
            this.roles.clear();
            if (roles != null) {
                this.roles.addAll(roles);
            }
        }

        public List<RangerPolicyItemCondition> getConditions() {
            return this.conditions;
        }

        public void setConditions(List<RangerPolicyItemCondition> conditions) {
            if (this.conditions == null) {
                this.conditions = new ArrayList<RangerPolicyItemCondition>();
            }
            if (this.conditions == conditions) {
                return;
            }
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
        }

        public Boolean getDelegateAdmin() {
            return this.delegateAdmin;
        }

        public void setDelegateAdmin(Boolean delegateAdmin) {
            this.delegateAdmin = delegateAdmin == null ? Boolean.FALSE : delegateAdmin;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyItem={");
            sb.append("accessTypes={");
            if (this.accesses != null) {
                for (RangerPolicyItemAccess access : this.accesses) {
                    if (access == null) continue;
                    access.toString(sb);
                }
            }
            sb.append("} ");
            sb.append("users={");
            if (this.users != null) {
                for (String user : this.users) {
                    if (user == null) continue;
                    sb.append(user).append(" ");
                }
            }
            sb.append("} ");
            sb.append("groups={");
            if (this.groups != null) {
                for (String group : this.groups) {
                    if (group == null) continue;
                    sb.append(group).append(" ");
                }
            }
            sb.append("} ");
            sb.append("roles={");
            if (this.roles != null) {
                for (String role : this.roles) {
                    if (role == null) continue;
                    sb.append(role).append(" ");
                }
            }
            sb.append("} ");
            sb.append("conditions={");
            if (this.conditions != null) {
                for (RangerPolicyItemCondition condition : this.conditions) {
                    if (condition == null) continue;
                    condition.toString(sb);
                }
            }
            sb.append("} ");
            sb.append("delegateAdmin={").append(this.delegateAdmin).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accesses == null ? 0 : this.accesses.hashCode());
            result = 31 * result + (this.conditions == null ? 0 : this.conditions.hashCode());
            result = 31 * result + (this.delegateAdmin == null ? 0 : this.delegateAdmin.hashCode());
            result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
            result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
            result = 31 * result + (this.users == null ? 0 : this.users.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyItem other = (RangerPolicyItem)obj;
            if (this.accesses == null ? other.accesses != null : !this.accesses.equals(other.accesses)) {
                return false;
            }
            if (this.conditions == null ? other.conditions != null : !this.conditions.equals(other.conditions)) {
                return false;
            }
            if (this.delegateAdmin == null ? other.delegateAdmin != null : !this.delegateAdmin.equals(other.delegateAdmin)) {
                return false;
            }
            if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
                return false;
            }
            if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
                return false;
            }
            return !(this.users == null ? other.users != null : !this.users.equals(other.users));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyResource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<String> values;
        private Boolean isExcludes;
        private Boolean isRecursive;

        public RangerPolicyResource() {
            this((List<String>)null, null, null);
        }

        public RangerPolicyResource(String value) {
            this.setValue(value);
            this.setIsExcludes(null);
            this.setIsRecursive(null);
        }

        public RangerPolicyResource(String value, Boolean isExcludes, Boolean isRecursive) {
            this.setValue(value);
            this.setIsExcludes(isExcludes);
            this.setIsRecursive(isRecursive);
        }

        public RangerPolicyResource(List<String> values, Boolean isExcludes, Boolean isRecursive) {
            this.setValues(values);
            this.setIsExcludes(isExcludes);
            this.setIsRecursive(isRecursive);
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            if (this.values == values) {
                return;
            }
            this.values.clear();
            if (values != null) {
                this.values.addAll(values);
            }
        }

        public void setValue(String value) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.clear();
            this.values.add(value);
        }

        public Boolean getIsExcludes() {
            return this.isExcludes;
        }

        public void setIsExcludes(Boolean isExcludes) {
            this.isExcludes = isExcludes == null ? Boolean.FALSE : isExcludes;
        }

        public Boolean getIsRecursive() {
            return this.isRecursive;
        }

        public void setIsRecursive(Boolean isRecursive) {
            this.isRecursive = isRecursive == null ? Boolean.FALSE : isRecursive;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyResource={");
            sb.append("values={");
            if (this.values != null) {
                for (String value : this.values) {
                    sb.append(value).append(" ");
                }
            }
            sb.append("} ");
            sb.append("isExcludes={").append(this.isExcludes).append("} ");
            sb.append("isRecursive={").append(this.isRecursive).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isExcludes == null ? 0 : this.isExcludes.hashCode());
            result = 31 * result + (this.isRecursive == null ? 0 : this.isRecursive.hashCode());
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyResource other = (RangerPolicyResource)obj;
            if (this.isExcludes == null ? other.isExcludes != null : !this.isExcludes.equals(other.isExcludes)) {
                return false;
            }
            if (this.isRecursive == null ? other.isRecursive != null : !this.isRecursive.equals(other.isRecursive)) {
                return false;
            }
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }
    }

    static class PolicyIdComparator
    implements Comparator<RangerPolicy>,
    Serializable {
        PolicyIdComparator() {
        }

        @Override
        public int compare(RangerPolicy me, RangerPolicy other) {
            return Long.compare(me.getId(), other.getId());
        }
    }
}

