/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPolicyDeltaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPolicyDeltaUtil.class);
    private static final Logger PERF_POLICY_DELTA_LOG = RangerPerfTracer.getPerfLogger("policy.delta");

    public static List<RangerPolicy> applyDeltas(List<RangerPolicy> policies, List<RangerPolicyDelta> deltas, String serviceType) {
        List<RangerPolicy> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> applyDeltas(serviceType=" + serviceType + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_DELTA_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_DELTA_LOG, "RangerPolicyDelta.applyDeltas()");
        }
        boolean hasExpectedServiceType = false;
        if (CollectionUtils.isNotEmpty(deltas)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("applyDeltas(deltas=" + Arrays.toString(deltas.toArray()) + ", serviceType=" + serviceType + ")");
            }
            for (RangerPolicyDelta delta : deltas) {
                if (serviceType.equals(delta.getServiceType())) {
                    hasExpectedServiceType = true;
                    break;
                }
                if (serviceType.equals("tag") || delta.getServiceType().equals("tag")) continue;
                LOG.warn("Found unexpected serviceType in policyDelta:[" + delta + "]. Was expecting serviceType:[" + serviceType + "]. Should NOT have come here!! Ignoring delta and continuing");
            }
            if (hasExpectedServiceType) {
                ret = new ArrayList<RangerPolicy>(policies);
                for (RangerPolicyDelta delta : deltas) {
                    if (!serviceType.equals(delta.getServiceType())) continue;
                    int changeType = delta.getChangeType();
                    if (changeType == 0 || changeType == 1 || changeType == 2) {
                        Long policyId = delta.getPolicyId();
                        if (policyId == null) continue;
                        ArrayList<RangerPolicy> deletedPolicies = new ArrayList<RangerPolicy>();
                        Iterator<RangerPolicy> iter = ret.iterator();
                        while (iter.hasNext()) {
                            RangerPolicy policy = iter.next();
                            if (!policyId.equals(policy.getId()) || changeType != 2 && changeType != 1) continue;
                            deletedPolicies.add(policy);
                            iter.remove();
                        }
                        switch (changeType) {
                            case 0: {
                                if (!CollectionUtils.isNotEmpty(deletedPolicies)) break;
                                LOG.warn("Unexpected: found existing policy for CHANGE_TYPE_POLICY_CREATE: " + Arrays.toString(deletedPolicies.toArray()));
                                break;
                            }
                            case 1: {
                                if (!CollectionUtils.isEmpty(deletedPolicies) && deletedPolicies.size() <= 1) break;
                                LOG.warn("Unexpected: found no policy or multiple policies for CHANGE_TYPE_POLICY_UPDATE: " + Arrays.toString(deletedPolicies.toArray()));
                                break;
                            }
                            case 2: {
                                if (!CollectionUtils.isEmpty(deletedPolicies) && deletedPolicies.size() <= 1) break;
                                LOG.warn("Unexpected: found no policy or multiple policies for CHANGE_TYPE_POLICY_DELETE: " + Arrays.toString(deletedPolicies.toArray()));
                                break;
                            }
                        }
                        if (changeType == 2) continue;
                        ret.add(delta.getPolicy());
                        continue;
                    }
                    LOG.warn("Found unexpected changeType in policyDelta:[" + delta + "]. Ignoring delta");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("applyDeltas - none of the deltas is for " + serviceType + ")");
                }
                ret = policies;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("applyDeltas called with empty deltas. Will return policies without change");
            }
            ret = policies;
        }
        if (CollectionUtils.isNotEmpty(deltas) && hasExpectedServiceType && CollectionUtils.isNotEmpty(ret)) {
            ret.sort(RangerPolicy.POLICY_ID_COMPARATOR);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== applyDeltas(serviceType=" + serviceType + "): " + ret);
        }
        return ret;
    }

    public static boolean isValidDeltas(List<RangerPolicyDelta> deltas, String componentServiceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isValidDeltas(deltas=" + Arrays.toString(deltas.toArray()) + ", componentServiceType=" + componentServiceType + ")");
        }
        boolean isValid = true;
        for (RangerPolicyDelta delta : deltas) {
            Integer changeType = delta.getChangeType();
            Long policyId = delta.getPolicyId();
            if (changeType == null) {
                isValid = false;
                break;
            }
            if (changeType != 0 && changeType != 1 && changeType != 2) {
                isValid = false;
            } else if (policyId == null) {
                isValid = false;
            } else {
                String serviceType = delta.getServiceType();
                Integer policyType = delta.getPolicyType();
                if (serviceType == null || !serviceType.equals("tag") && !serviceType.equals(componentServiceType)) {
                    isValid = false;
                } else if (policyType == null || policyType != 0 && policyType != 1 && policyType != 2) {
                    isValid = false;
                }
            }
            if (isValid) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isValidDeltas(deltas=" + Arrays.toString(deltas.toArray()) + ", componentServiceType=" + componentServiceType + "): " + isValid);
        }
        return isValid;
    }

    public static Boolean hasPolicyDeltas(ServicePolicies servicePolicies) {
        Boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> hasPolicyDeltas(servicePolicies:[" + servicePolicies + "]");
        }
        if (servicePolicies == null) {
            LOG.error("ServicePolicies are null!");
            ret = null;
        } else {
            boolean isPolicyDeltasExist;
            boolean isPoliciesExistInSecurityZones = false;
            boolean isPolicyDeltasExistInSecurityZones = false;
            if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
                for (ServicePolicies.SecurityZoneInfo element : servicePolicies.getSecurityZones().values()) {
                    if (CollectionUtils.isNotEmpty(element.getPolicies()) && CollectionUtils.isEmpty(element.getPolicyDeltas())) {
                        isPoliciesExistInSecurityZones = true;
                    }
                    if (!CollectionUtils.isEmpty(element.getPolicies()) || !CollectionUtils.isNotEmpty(element.getPolicyDeltas())) continue;
                    isPolicyDeltasExistInSecurityZones = true;
                }
            }
            boolean isPoliciesExist = CollectionUtils.isNotEmpty(servicePolicies.getPolicies()) || servicePolicies.getTagPolicies() != null && CollectionUtils.isNotEmpty(servicePolicies.getTagPolicies().getPolicies()) || isPoliciesExistInSecurityZones;
            boolean bl = isPolicyDeltasExist = CollectionUtils.isNotEmpty(servicePolicies.getPolicyDeltas()) || isPolicyDeltasExistInSecurityZones;
            if (isPoliciesExist && isPolicyDeltasExist) {
                LOG.warn("ServicePolicies contain both policies and policy-deltas!! Cannot build policy-engine from these servicePolicies. Please check server-side code!");
                LOG.warn("Downloaded ServicePolicies are [" + servicePolicies + "]");
                ret = null;
            } else if (!isPoliciesExist && !isPolicyDeltasExist) {
                LOG.warn("ServicePolicies do not contain any policies or policy-deltas!!");
                LOG.warn("Downloaded ServicePolicies are [" + servicePolicies + "]");
                if (servicePolicies.getPolicyDeltas() == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Complete set of servicePolicies is received. There may be a change to service. Forcing to create a new policy engine!");
                    }
                    ret = false;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("servicePolicy deltas are received. There are no material changes in the policies.");
                    }
                    ret = null;
                }
            } else {
                ret = isPolicyDeltasExist;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== hasPolicyDeltas(servicePolicies:[" + servicePolicies + "], ret:[" + ret + "]");
        }
        return ret;
    }
}

