/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="Client Metrics", context="ozone")
public final class ContainerClientMetrics {
    private static ContainerClientMetrics instance;
    @VisibleForTesting
    static int referenceCount;
    private static final String SOURCE_NAME;
    private static int instanceCount;
    @Metric
    private MutableCounterLong totalWriteChunkCalls;
    @Metric
    private MutableCounterLong totalWriteChunkBytes;
    private final Map<PipelineID, MutableCounterLong> writeChunkCallsByPipeline;
    private final Map<PipelineID, MutableCounterLong> writeChunkBytesByPipeline;
    private final Map<UUID, MutableCounterLong> writeChunksCallsByLeaders;
    private final MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);

    public static synchronized ContainerClientMetrics acquire() {
        if (instance == null) {
            instance = (ContainerClientMetrics)DefaultMetricsSystem.instance().register(SOURCE_NAME + ++instanceCount, "Ozone Client Metrics", (Object)new ContainerClientMetrics());
        }
        ++referenceCount;
        return instance;
    }

    public static synchronized void release() {
        if (instance == null) {
            throw new IllegalStateException("This metrics class is not used.");
        }
        if (--referenceCount == 0) {
            DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME + instanceCount);
            instance = null;
        }
    }

    private ContainerClientMetrics() {
        this.writeChunkCallsByPipeline = new ConcurrentHashMap<PipelineID, MutableCounterLong>();
        this.writeChunkBytesByPipeline = new ConcurrentHashMap<PipelineID, MutableCounterLong>();
        this.writeChunksCallsByLeaders = new ConcurrentHashMap<UUID, MutableCounterLong>();
    }

    public void recordWriteChunk(Pipeline pipeline, long chunkSizeBytes) {
        this.writeChunkCallsByPipeline.computeIfAbsent(pipeline.getId(), pipelineID -> this.registry.newCounter(Interns.info((String)("writeChunkCallsPipeline-" + pipelineID.getId()), (String)"Number of writeChunk calls on a pipelines"), 0L)).incr();
        this.writeChunkBytesByPipeline.computeIfAbsent(pipeline.getId(), pipelineID -> this.registry.newCounter(Interns.info((String)("writeChunkBytesPipeline-" + pipelineID.getId()), (String)"Number of bytes written on a pipelines"), 0L)).incr(chunkSizeBytes);
        if (pipeline.getLeaderId() != null) {
            this.writeChunksCallsByLeaders.computeIfAbsent(pipeline.getLeaderId(), leader -> this.registry.newCounter(Interns.info((String)("writeChunkCallsLeader-" + leader), (String)"Number of writeChunk calls on a leader node"), 0L)).incr();
        }
        this.totalWriteChunkCalls.incr();
        this.totalWriteChunkBytes.incr(chunkSizeBytes);
    }

    @VisibleForTesting
    public MutableCounterLong getTotalWriteChunkBytes() {
        return this.totalWriteChunkBytes;
    }

    @VisibleForTesting
    public MutableCounterLong getTotalWriteChunkCalls() {
        return this.totalWriteChunkCalls;
    }

    @VisibleForTesting
    public Map<PipelineID, MutableCounterLong> getWriteChunkBytesByPipeline() {
        return this.writeChunkBytesByPipeline;
    }

    @VisibleForTesting
    public Map<PipelineID, MutableCounterLong> getWriteChunkCallsByPipeline() {
        return this.writeChunkCallsByPipeline;
    }

    @VisibleForTesting
    public Map<UUID, MutableCounterLong> getWriteChunksCallsByLeaders() {
        return this.writeChunksCallsByLeaders;
    }

    static {
        referenceCount = 0;
        SOURCE_NAME = ContainerClientMetrics.class.getSimpleName();
        instanceCount = 0;
    }
}

