/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;

public class BufferPool {
    private static final BufferPool EMPTY = new BufferPool(0, 0);
    private final List<ChunkBuffer> bufferList;
    private int currentBufferIndex;
    private final int bufferSize;
    private final int capacity;
    private final Function<ByteBuffer, ByteString> byteStringConversion;

    public static BufferPool empty() {
        return EMPTY;
    }

    public BufferPool(int bufferSize, int capacity) {
        this(bufferSize, capacity, ByteStringConversion.createByteBufferConversion((boolean)false));
    }

    public BufferPool(int bufferSize, int capacity, Function<ByteBuffer, ByteString> byteStringConversion) {
        this.capacity = capacity;
        this.bufferSize = bufferSize;
        this.bufferList = capacity == 0 ? Collections.emptyList() : new ArrayList(capacity);
        this.currentBufferIndex = -1;
        this.byteStringConversion = byteStringConversion;
    }

    public Function<ByteBuffer, ByteString> byteStringConversion() {
        return this.byteStringConversion;
    }

    ChunkBuffer getCurrentBuffer() {
        return this.currentBufferIndex == -1 ? null : this.bufferList.get(this.currentBufferIndex);
    }

    public ChunkBuffer allocateBuffer(int increment) {
        int nextBufferIndex = this.currentBufferIndex + 1;
        Preconditions.assertTrue((nextBufferIndex < this.capacity ? 1 : 0) != 0, () -> "next index: " + nextBufferIndex + " >= capacity: " + this.capacity);
        this.currentBufferIndex = nextBufferIndex;
        if (this.currentBufferIndex < this.bufferList.size()) {
            return this.getBuffer(this.currentBufferIndex);
        }
        ChunkBuffer newBuffer = ChunkBuffer.allocate((int)this.bufferSize, (int)increment);
        this.bufferList.add(newBuffer);
        return newBuffer;
    }

    void releaseBuffer(ChunkBuffer chunkBuffer) {
        Preconditions.assertTrue((!this.bufferList.isEmpty() ? 1 : 0) != 0, (Object)"empty buffer list");
        Preconditions.assertSame((Object)this.bufferList.get(0), (Object)chunkBuffer, (String)"only the first buffer can be released");
        Preconditions.assertTrue((this.currentBufferIndex >= 0 ? 1 : 0) != 0, () -> "current buffer: " + this.currentBufferIndex);
        ChunkBuffer buffer = this.bufferList.remove(0);
        buffer.clear();
        this.bufferList.add(buffer);
        --this.currentBufferIndex;
    }

    public void clearBufferPool() {
        this.bufferList.clear();
        this.currentBufferIndex = -1;
    }

    public void checkBufferPoolEmpty() {
        Preconditions.assertSame((long)0L, (long)this.computeBufferData(), (String)"total buffer size");
    }

    public long computeBufferData() {
        long totalBufferSize = 0L;
        for (ChunkBuffer buf : this.bufferList) {
            totalBufferSize += (long)buf.position();
        }
        return totalBufferSize;
    }

    public int getSize() {
        return this.bufferList.size();
    }

    public ChunkBuffer getBuffer(int index) {
        return this.bufferList.get(index);
    }

    int getCurrentBufferIndex() {
        return this.currentBufferIndex;
    }

    public int getNumberOfUsedBuffers() {
        return this.currentBufferIndex + 1;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

