/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.protocolPB.GrpcOmTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public final class OzoneClientCache {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientCache.class);
    private static OzoneClientCache instance;
    private OzoneClient client;
    private SecurityConfig secConfig;

    private OzoneClientCache(OzoneConfiguration ozoneConfiguration) throws IOException {
        ozoneConfiguration.setIfUnset("ozone.client.required.om.version.min", OzoneConfigKeys.OZONE_CLIENT_REQUIRED_OM_VERSION_MIN_DEFAULT);
        String omServiceID = OmUtils.getOzoneManagerServiceId((OzoneConfiguration)ozoneConfiguration);
        this.secConfig = new SecurityConfig((ConfigurationSource)ozoneConfiguration);
        this.client = null;
        try {
            if (this.secConfig.isGrpcTlsEnabled() && ozoneConfiguration.get("ozone.om.transport.class", "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory") != "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory") {
                this.setCertificate(omServiceID, ozoneConfiguration);
            }
            this.client = omServiceID == null ? OzoneClientFactory.getRpcClient((ConfigurationSource)ozoneConfiguration) : OzoneClientFactory.getRpcClient((String)omServiceID, (ConfigurationSource)ozoneConfiguration);
        }
        catch (IOException e) {
            LOG.warn("cannot create OzoneClient", (Throwable)e);
            throw e;
        }
        ozoneConfiguration.setBoolean("ozone.s3.auth.check", true);
    }

    public static OzoneClient getOzoneClientInstance(OzoneConfiguration ozoneConfiguration) throws IOException {
        if (instance == null) {
            instance = new OzoneClientCache(ozoneConfiguration);
        }
        return OzoneClientCache.instance.client;
    }

    public static void closeClient() throws IOException {
        if (instance != null) {
            OzoneClientCache.instance.client.close();
            instance = null;
        }
    }

    private void setCertificate(String omServiceID, OzoneConfiguration conf) throws IOException {
        OzoneConfiguration config = new OzoneConfiguration((Configuration)conf);
        if (this.secConfig.isGrpcTlsEnabled()) {
            config.set("ozone.om.transport.class", "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory");
            try (OzoneClient certClient = omServiceID == null ? OzoneClientFactory.getRpcClient((ConfigurationSource)config) : OzoneClientFactory.getRpcClient((String)omServiceID, (ConfigurationSource)config);){
                ServiceInfoEx serviceInfoEx = certClient.getObjectStore().getClientProxy().getOzoneManagerClient().getServiceInfo();
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    String caCertPem = null;
                    List<String> caCertPems = null;
                    caCertPem = serviceInfoEx.getCaCertificate();
                    caCertPems = serviceInfoEx.getCaCertPemList();
                    if (caCertPems == null || caCertPems.isEmpty()) {
                        if (caCertPem == null) {
                            LOG.error("S3g received empty caCertPems from serviceInfo");
                            throw new CertificateException("No caCerts found; caCertPem can not be null when caCertPems is empty or null");
                        }
                        caCertPems = Collections.singletonList(caCertPem);
                    }
                    GrpcOmTransport.setCaCerts((List)OzoneSecurityUtil.convertToX509((List)caCertPems));
                }
            }
        }
    }

    @PreDestroy
    public void destroy() throws IOException {
        OzoneClientCache.closeClient();
    }
}

