/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SignedChunksInputStream
extends InputStream {
    private Pattern signatureLinePattern = Pattern.compile("([0-9A-Fa-f]+);chunk-signature=.*");
    private InputStream originalStream;
    private int remainingData = 0;

    public SignedChunksInputStream(InputStream inputStream) {
        this.originalStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingData > 0) {
            int curr = this.originalStream.read();
            --this.remainingData;
            if (this.remainingData == 0) {
                this.originalStream.read();
                this.originalStream.read();
            }
            return curr;
        }
        this.remainingData = this.readHeader();
        if (this.remainingData == -1) {
            return -1;
        }
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int currentOff = off;
        int currentLen = len;
        int totalReadBytes = 0;
        int realReadLen = 0;
        int maxReadLen = 0;
        do {
            if (this.remainingData > 0) {
                maxReadLen = Math.min(this.remainingData, currentLen);
                realReadLen = this.originalStream.read(b, currentOff, maxReadLen);
                if (realReadLen == -1) break;
                currentOff += realReadLen;
                currentLen -= realReadLen;
                totalReadBytes += realReadLen;
                this.remainingData -= realReadLen;
                if (this.remainingData != 0) continue;
                this.originalStream.read();
                this.originalStream.read();
                continue;
            }
            this.remainingData = this.readHeader();
            if (this.remainingData == -1) break;
        } while (currentLen > 0);
        return totalReadBytes > 0 ? totalReadBytes : -1;
    }

    private int readHeader() throws IOException {
        int prev = -1;
        int curr = 0;
        StringBuilder buf = new StringBuilder();
        while (!this.eol(prev, curr) && curr != -1) {
            int next = this.originalStream.read();
            if (next != -1) {
                buf.append((char)next);
            }
            prev = curr;
            curr = next;
        }
        String signatureLine = buf.toString().trim();
        if (signatureLine.length() == 0) {
            return -1;
        }
        Matcher matcher = this.signatureLinePattern.matcher(signatureLine);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1), 16);
        }
        throw new IOException("Invalid signature line: " + signatureLine);
    }

    private boolean eol(int prev, int curr) {
        return prev == 13 && curr == 10;
    }
}

