/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jooq.Attachable;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Scope;
import org.jooq.TableRecord;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.MappingException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.DSL;
import org.jooq.impl.DateToLocalDateConverter;
import org.jooq.impl.DefaultBindingSQLContext;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.Keywords;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TimeToLocalTimeConverter;
import org.jooq.impl.TimestampToLocalDateTimeConverter;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.jdbc.MockArray;
import org.jooq.types.DayToSecond;
import org.jooq.types.Interval;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UShort;
import org.jooq.types.YearToMonth;
import org.jooq.util.postgres.PostgresUtils;

public class DefaultBinding<T, U>
implements Binding<T, U> {
    static final JooqLogger log = JooqLogger.getLogger(DefaultBinding.class);
    private static final long serialVersionUID = -198499389344950496L;
    private static final EnumSet<SQLDialect> REQUIRE_JDBC_DATE_LITERAL = EnumSet.of(SQLDialect.MYSQL);
    final AbstractBinding<T, U> delegate;

    public static final <T, U> Binding<T, U> binding(Converter<T, U> converter) {
        return DefaultBinding.binding(converter, false);
    }

    static final <T> Binding<T, T> binding(Class<T> type, boolean isLob) {
        return DefaultBinding.binding(Converters.identity(type), isLob);
    }

    static final <T, U> Binding<T, U> binding(Converter<T, U> converter, boolean isLob) {
        Class<T> type = converter.fromType();
        if (type == BigDecimal.class) {
            return new DefaultBigDecimalBinding<U>(converter, isLob);
        }
        if (type == BigInteger.class) {
            return new DefaultBigIntegerBinding<U>(converter, isLob);
        }
        if (type == Blob.class) {
            return new DefaultBlobBinding<U>(converter, isLob);
        }
        if (type == Boolean.class) {
            return new DefaultBooleanBinding<U>(converter, isLob);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new DefaultByteBinding<U>(converter, isLob);
        }
        if (type == byte[].class) {
            return new DefaultBytesBinding<U>(converter, isLob);
        }
        if (type == Clob.class) {
            return new DefaultClobBinding<U>(converter, isLob);
        }
        if (type == java.sql.Date.class) {
            return new DefaultDateBinding<U>(converter, isLob);
        }
        if (type == DayToSecond.class) {
            return new DefaultDayToSecondBinding<U>(converter, isLob);
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DefaultDoubleBinding<U>(converter, isLob);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new DefaultFloatBinding<U>(converter, isLob);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new DefaultIntegerBinding<U>(converter, isLob);
        }
        if (type == LocalDate.class) {
            DateToLocalDateConverter c1 = new DateToLocalDateConverter();
            Converter<T, U> c2 = converter;
            Converter<java.sql.Date, U> c3 = Converters.of(c1, c2);
            return new DelegatingBinding<LocalDate, java.sql.Date, U>(c1, c2, new DefaultDateBinding<U>(c3, isLob), isLob);
        }
        if (type == LocalDateTime.class) {
            TimestampToLocalDateTimeConverter c1 = new TimestampToLocalDateTimeConverter();
            Converter<T, U> c2 = converter;
            Converter<Timestamp, U> c3 = Converters.of(c1, c2);
            return new DelegatingBinding<LocalDateTime, Timestamp, U>(c1, c2, new DefaultTimestampBinding<U>(c3, isLob), isLob);
        }
        if (type == LocalTime.class) {
            TimeToLocalTimeConverter c1 = new TimeToLocalTimeConverter();
            Converter<T, U> c2 = converter;
            Converter<Time, U> c3 = Converters.of(c1, c2);
            return new DelegatingBinding<LocalTime, Time, U>(c1, c2, new DefaultTimeBinding<U>(c3, isLob), isLob);
        }
        if (type == Long.class || type == Long.TYPE) {
            return new DefaultLongBinding<U>(converter, isLob);
        }
        if (type == OffsetDateTime.class) {
            return new DefaultOffsetDateTimeBinding<U>(converter, isLob);
        }
        if (type == OffsetTime.class) {
            return new DefaultOffsetTimeBinding<U>(converter, isLob);
        }
        if (type == Short.class || type == Short.TYPE) {
            return new DefaultShortBinding<U>(converter, isLob);
        }
        if (type == String.class) {
            return new DefaultStringBinding<U>(converter, isLob);
        }
        if (type == Time.class) {
            return new DefaultTimeBinding<U>(converter, isLob);
        }
        if (type == Timestamp.class) {
            return new DefaultTimestampBinding<U>(converter, isLob);
        }
        if (type == UByte.class) {
            return new DefaultUByteBinding<U>(converter, isLob);
        }
        if (type == UInteger.class) {
            return new DefaultUIntegerBinding<U>(converter, isLob);
        }
        if (type == ULong.class) {
            return new DefaultULongBinding<U>(converter, isLob);
        }
        if (type == UShort.class) {
            return new DefaultUShortBinding<U>(converter, isLob);
        }
        if (type == UUID.class) {
            return new DefaultUUIDBinding<U>(converter, isLob);
        }
        if (type == YearToMonth.class) {
            return new DefaultYearToMonthBinding<U>(converter, isLob);
        }
        if (type.isArray()) {
            return new DefaultArrayBinding<U>(converter, isLob);
        }
        if (EnumType.class.isAssignableFrom(type)) {
            return new DefaultEnumTypeBinding<U>(converter, isLob);
        }
        if (Record.class.isAssignableFrom(type)) {
            return new DefaultRecordBinding<U>(converter, isLob);
        }
        if (Result.class.isAssignableFrom(type)) {
            return new DefaultResultBinding<U>(converter, isLob);
        }
        return new DefaultOtherBinding<U>(converter, isLob);
    }

    @Deprecated
    public DefaultBinding(Converter<T, U> converter) {
        this(converter, false);
    }

    @Deprecated
    DefaultBinding(Converter<T, U> converter, boolean isLob) {
        this.delegate = (AbstractBinding)DefaultBinding.binding(converter, isLob);
    }

    static final <T, X, U> Binding<T, U> newBinding(final Converter<X, U> converter, DataType<T> type, final Binding<T, X> binding) {
        Binding<Object, Object> theBinding = converter == null && binding == null ? type.getBinding() : (converter == null ? binding : (binding == null ? DefaultBinding.binding(converter, type.isLob()) : new Binding<T, U>(){
            private static final long serialVersionUID = 8912340791845209886L;
            final Converter<T, U> theConverter;
            {
                this.theConverter = Converters.of(binding.converter(), converter);
            }

            @Override
            public Converter<T, U> converter() {
                return this.theConverter;
            }

            @Override
            public void sql(BindingSQLContext<U> ctx) throws SQLException {
                binding.sql(ctx.convert(converter));
            }

            @Override
            public void register(BindingRegisterContext<U> ctx) throws SQLException {
                binding.register(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetStatementContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetStatementContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }
        }));
        return theBinding;
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration) {
        return DefaultBinding.typeMap(type, configuration, new HashMap());
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration, Map<String, Class<?>> result) {
        try {
            if (UDTRecord.class.isAssignableFrom(type)) {
                Class<?> t = type;
                result.put(Tools.getMappedUDTName(configuration, t), t);
                UDTRecord r = (UDTRecord)t.newInstance();
                for (Field<?> field : r.getUDT().fields()) {
                    DefaultBinding.typeMap(field.getType(), configuration, result);
                }
            }
        }
        catch (Exception e) {
            throw new MappingException("Error while collecting type map", e);
        }
        return result;
    }

    private static final long parse(Class<? extends Date> type, String date) throws SQLException {
        try {
            return Long.valueOf(date);
        }
        catch (NumberFormatException e) {
            date = StringUtils.replace(date, "T", " ");
            if (type == Timestamp.class) {
                return Timestamp.valueOf(date).getTime();
            }
            if (type == java.sql.Date.class) {
                return java.sql.Date.valueOf(date.split(" ")[0]).getTime();
            }
            if (type == Time.class) {
                return Time.valueOf(date).getTime();
            }
            throw new SQLException("Could not parse date " + date, e);
        }
    }

    @Override
    public Converter<T, U> converter() {
        return this.delegate.converter;
    }

    @Override
    public void sql(BindingSQLContext<U> ctx) throws SQLException {
        this.delegate.sql(ctx);
    }

    @Override
    public void register(BindingRegisterContext<U> ctx) throws SQLException {
        this.delegate.register(ctx);
    }

    @Override
    public void set(BindingSetStatementContext<U> ctx) throws SQLException {
        this.delegate.set(ctx);
    }

    @Override
    public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
        this.delegate.set(ctx);
    }

    @Override
    public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    @Override
    public void get(BindingGetStatementContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    @Override
    public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    public String toString() {
        return "DefaultBinding [type=" + this.delegate.type + ", converter=" + this.delegate.converter + "]";
    }

    static final class DefaultYearToMonthBinding<U>
    extends AbstractBinding<YearToMonth, U> {
        private static final long serialVersionUID = 6417965474063152673L;

        DefaultYearToMonthBinding(Converter<YearToMonth, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, YearToMonth value) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), value.toString());
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, YearToMonth value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final YearToMonth get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToMonth(object);
            }
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : YearToMonth.valueOf(string);
        }

        @Override
        final YearToMonth get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToMonth(object);
            }
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : YearToMonth.valueOf(string);
        }

        @Override
        final YearToMonth get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : YearToMonth.valueOf(string);
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultUUIDBinding<U>
    extends AbstractBinding<UUID, U> {
        private static final long serialVersionUID = -6616291625634347383L;

        DefaultUUIDBinding(Converter<UUID, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UUID value) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    ctx.statement().setObject(ctx.index(), value);
                    break;
                }
                default: {
                    ctx.statement().setString(ctx.index(), value.toString());
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UUID value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final UUID get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    return Convert.convert(ctx.resultSet().getObject(ctx.index()), UUID.class);
                }
            }
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UUID.class);
        }

        @Override
        final UUID get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    return (UUID)ctx.statement().getObject(ctx.index());
                }
            }
            return Convert.convert((Object)ctx.statement().getString(ctx.index()), UUID.class);
        }

        @Override
        final UUID get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.input().readString(), UUID.class);
        }

        @Override
        final int sqltype(Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: {
                    return 1111;
                }
            }
            return 12;
        }
    }

    static final class DefaultUShortBinding<U>
    extends AbstractBinding<UShort, U> {
        private static final long serialVersionUID = 2539811197808516971L;

        DefaultUShortBinding(Converter<UShort, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, UShort value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UShort value) throws SQLException {
            ctx.statement().setInt(ctx.index(), value.intValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UShort value) throws SQLException {
            ctx.output().writeInt(value.intValue());
        }

        @Override
        final UShort get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UShort.class);
        }

        @Override
        final UShort get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : UShort.valueOf(string);
        }

        @Override
        final UShort get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : UShort.valueOf(string);
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 4;
        }
    }

    static final class DefaultULongBinding<U>
    extends AbstractBinding<ULong, U> {
        private static final long serialVersionUID = 4891128447530113299L;

        DefaultULongBinding(Converter<ULong, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, ULong value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, ULong value) throws SQLException {
            ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value.toString()));
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, ULong value) throws SQLException {
            ctx.output().writeBigDecimal(new BigDecimal(value.toString()));
        }

        @Override
        final ULong get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), ULong.class);
        }

        @Override
        final ULong get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : ULong.valueOf(string);
        }

        @Override
        final ULong get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : ULong.valueOf(string);
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultUIntegerBinding<U>
    extends AbstractBinding<UInteger, U> {
        private static final long serialVersionUID = 1437279656720185207L;

        DefaultUIntegerBinding(Converter<UInteger, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, UInteger value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UInteger value) throws SQLException {
            ctx.statement().setLong(ctx.index(), value.longValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UInteger value) throws SQLException {
            ctx.output().writeLong(value.longValue());
        }

        @Override
        final UInteger get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UInteger.class);
        }

        @Override
        final UInteger get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : UInteger.valueOf(string);
        }

        @Override
        final UInteger get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : UInteger.valueOf(string);
        }

        @Override
        final int sqltype(Configuration configuration) {
            return -5;
        }
    }

    static final class DefaultUByteBinding<U>
    extends AbstractBinding<UByte, U> {
        private static final long serialVersionUID = -101167998250685198L;

        DefaultUByteBinding(Converter<UByte, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, UByte value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UByte value) throws SQLException {
            ctx.statement().setShort(ctx.index(), value.shortValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UByte value) throws SQLException {
            ctx.output().writeShort(value.shortValue());
        }

        @Override
        final UByte get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UByte.class);
        }

        @Override
        final UByte get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : UByte.valueOf(string);
        }

        @Override
        final UByte get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : UByte.valueOf(string);
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 5;
        }
    }

    static final class DefaultTimestampBinding<U>
    extends AbstractBinding<Timestamp, U> {
        private static final long serialVersionUID = 289387167549159015L;
        private static final EnumSet<SQLDialect> INLINE_AS_STRING_LITERAL = EnumSet.of(SQLDialect.SQLITE);

        DefaultTimestampBinding(Converter<Timestamp, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Timestamp value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.family())) {
                ctx.render().sql('\'').sql(DefaultTimestampBinding.escape(value, ctx.render())).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql("('").sql(DefaultTimestampBinding.escape(value, ctx.render())).sql("')");
            } else if (ctx.family() == SQLDialect.CUBRID) {
                ((RenderContext)ctx.render().visit(Keywords.K_DATETIME)).sql(" '").sql(DefaultTimestampBinding.escape(value, ctx.render())).sql('\'');
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.family())) {
                ctx.render().sql("{ts '").sql(DefaultTimestampBinding.escape(value, ctx.render())).sql("'}");
            } else {
                ((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql(" '").sql(DefaultTimestampBinding.escape(value, ctx.render())).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Timestamp value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setTimestamp(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Timestamp value) throws SQLException {
            ctx.output().writeTimestamp(value);
        }

        @Override
        final Timestamp get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                String timestamp = ctx.resultSet().getString(ctx.index());
                return timestamp == null ? null : new Timestamp(DefaultBinding.parse(Timestamp.class, timestamp));
            }
            return ctx.resultSet().getTimestamp(ctx.index());
        }

        @Override
        final Timestamp get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getTimestamp(ctx.index());
        }

        @Override
        final Timestamp get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readTimestamp();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 93;
        }
    }

    static final class DefaultTimeBinding<U>
    extends AbstractBinding<Time, U> {
        private static final long serialVersionUID = -2563220967846617288L;
        private static final EnumSet<SQLDialect> INLINE_AS_STRING_LITERAL = EnumSet.of(SQLDialect.SQLITE);

        DefaultTimeBinding(Converter<Time, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Time value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.family())) {
                ctx.render().sql('\'').sql(new SimpleDateFormat("HH:mm:ss").format(value)).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql("('").sql(DefaultTimeBinding.escape(value, ctx.render())).sql("')");
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.family())) {
                ctx.render().sql("{t '").sql(DefaultTimeBinding.escape(value, ctx.render())).sql("'}");
            } else {
                ((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql(" '").sql(DefaultTimeBinding.escape(value, ctx.render())).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Time value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setTime(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Time value) throws SQLException {
            ctx.output().writeTime(value);
        }

        @Override
        final Time get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                String time = ctx.resultSet().getString(ctx.index());
                return time == null ? null : new Time(DefaultBinding.parse(Time.class, time));
            }
            return ctx.resultSet().getTime(ctx.index());
        }

        @Override
        final Time get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getTime(ctx.index());
        }

        @Override
        final Time get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readTime();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 92;
        }
    }

    static final class DefaultStringBinding<U>
    extends AbstractBinding<String, U> {
        private static final long serialVersionUID = 4232459541239942932L;

        DefaultStringBinding(Converter<String, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, String value) throws SQLException {
            ctx.statement().setString(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, String value) throws SQLException {
            ctx.output().writeString(value);
        }

        @Override
        final String get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getString(ctx.index());
        }

        @Override
        final String get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getString(ctx.index());
        }

        @Override
        final String get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readString();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultShortBinding<U>
    extends AbstractBinding<Short, U> {
        private static final long serialVersionUID = 8935720621737085226L;

        DefaultShortBinding(Converter<Short, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Short value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Short value) throws SQLException {
            ctx.statement().setShort(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Short value) throws SQLException {
            ctx.output().writeShort(value);
        }

        @Override
        final Short get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Short.valueOf(ctx.resultSet().getShort(ctx.index())));
        }

        @Override
        final Short get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Short.valueOf(ctx.statement().getShort(ctx.index())));
        }

        @Override
        final Short get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Short.valueOf(ctx.input().readShort()));
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 5;
        }
    }

    static final class DefaultResultBinding<U>
    extends AbstractBinding<Result<?>, U> {
        private static final long serialVersionUID = -2148875780733374224L;

        DefaultResultBinding(Converter<Result<?>, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Result<?> value) throws SQLException {
            throw new UnsupportedOperationException("Cannot bind a value of type Result to a PreparedStatement");
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Result<?> value) throws SQLException {
            throw new UnsupportedOperationException("Cannot bind a value of type Result to a SQLOutput");
        }

        @Override
        final Result<?> get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            ResultSet nested = (ResultSet)ctx.resultSet().getObject(ctx.index());
            return DSL.using(ctx.configuration()).fetch(nested);
        }

        @Override
        final Result<?> get0(BindingGetStatementContext<U> ctx) throws SQLException {
            ResultSet nested = (ResultSet)ctx.statement().getObject(ctx.index());
            return DSL.using(ctx.configuration()).fetch(nested);
        }

        @Override
        final Result<?> get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Cannot get a value of type Result from a SQLInput");
        }

        @Override
        final int sqltype(Configuration configuration) {
            switch (configuration.family()) {
                case H2: {
                    return -10;
                }
            }
            return 1111;
        }
    }

    static final class DefaultRecordBinding<U>
    extends AbstractBinding<Record, U> {
        private static final long serialVersionUID = 2547994476924120818L;

        DefaultRecordBinding(Converter<Record, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, Record value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (ctx.family() == SQLDialect.POSTGRES && value != null) {
                DefaultRecordBinding.pgRenderRecordCast(ctx.render(), value);
            }
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Record value) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                ctx.render().visit(DSL.inline(PostgresUtils.toPGString(value)));
                DefaultRecordBinding.pgRenderRecordCast(ctx.render(), value);
            } else {
                ctx.render().sql("[UDT]");
            }
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Record value) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES && value != null) {
                ctx.statement().setString(ctx.index(), PostgresUtils.toPGString(value));
            } else {
                ctx.statement().setObject(ctx.index(), value);
            }
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Record value) throws SQLException {
            if (!(value instanceof UDTRecord)) {
                throw new UnsupportedOperationException("Type " + this.type + " is not supported");
            }
            ctx.output().writeObject((UDTRecord)value);
        }

        @Override
        final Record get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    return DefaultRecordBinding.pgNewRecord(this.type, null, ctx.resultSet().getObject(ctx.index()));
                }
            }
            return (Record)ctx.resultSet().getObject(ctx.index(), DefaultBinding.typeMap(this.type, ctx.configuration()));
        }

        @Override
        final Record get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    return DefaultRecordBinding.pgNewRecord(this.type, null, ctx.statement().getObject(ctx.index()));
                }
            }
            return (Record)ctx.statement().getObject(ctx.index(), DefaultBinding.typeMap(this.type, ctx.configuration()));
        }

        @Override
        final Record get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return (Record)ctx.input().readObject();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 2002;
        }

        static final void pgRenderRecordCast(RenderContext render, Record value) {
            if (value instanceof UDTRecord) {
                render.sql("::").visit(((UDTRecord)value).getUDT().getQualifiedName());
            } else if (value instanceof TableRecord) {
                render.sql("::").visit(((TableRecord)value).getTable().getQualifiedName());
            }
        }

        private static final <T> T pgFromString(Class<T> type, String string) {
            return DefaultRecordBinding.pgFromString(Converters.identity(type), string);
        }

        private static final <T> T pgFromString(Converter<?, T> converter, String string) {
            Class<T> type = converter.toType();
            if (string == null) {
                return null;
            }
            if (type != Blob.class) {
                if (type == Boolean.class) {
                    return (T)Convert.convert((Object)string, Boolean.class);
                }
                if (type == BigInteger.class) {
                    return (T)new BigInteger(string);
                }
                if (type == BigDecimal.class) {
                    return (T)new BigDecimal(string);
                }
                if (type == Byte.class) {
                    return (T)Byte.valueOf(string);
                }
                if (type == byte[].class) {
                    return (T)PostgresUtils.toBytes(string);
                }
                if (type != Clob.class) {
                    if (type == java.sql.Date.class) {
                        return (T)java.sql.Date.valueOf(string);
                    }
                    if (type == Double.class) {
                        return (T)Double.valueOf(string);
                    }
                    if (type == Float.class) {
                        return (T)Float.valueOf(string);
                    }
                    if (type == Integer.class) {
                        return (T)Integer.valueOf(string);
                    }
                    if (type == Long.class) {
                        return (T)Long.valueOf(string);
                    }
                    if (type == Short.class) {
                        return (T)Short.valueOf(string);
                    }
                    if (type == String.class) {
                        return (T)string;
                    }
                    if (type == Time.class) {
                        return (T)Time.valueOf(string);
                    }
                    if (type == Timestamp.class) {
                        return (T)Timestamp.valueOf(string);
                    }
                    if (type == LocalTime.class) {
                        return (T)LocalTime.parse(string);
                    }
                    if (type == LocalDate.class) {
                        return (T)LocalDate.parse(string);
                    }
                    if (type == LocalDateTime.class) {
                        return (T)LocalDateTime.parse(string);
                    }
                    if (type == OffsetTime.class) {
                        return (T)OffsetDateTimeParser.offsetTime(string);
                    }
                    if (type == OffsetDateTime.class) {
                        return (T)OffsetDateTimeParser.offsetDateTime(string);
                    }
                    if (type == UByte.class) {
                        return (T)UByte.valueOf(string);
                    }
                    if (type == UShort.class) {
                        return (T)UShort.valueOf(string);
                    }
                    if (type == UInteger.class) {
                        return (T)UInteger.valueOf(string);
                    }
                    if (type == ULong.class) {
                        return (T)ULong.valueOf(string);
                    }
                    if (type == UUID.class) {
                        return (T)UUID.fromString(string);
                    }
                    if (type.isArray()) {
                        return (T)DefaultRecordBinding.pgNewArray(type, string);
                    }
                    if (EnumType.class.isAssignableFrom(type)) {
                        return DefaultEnumTypeBinding.getEnumType(type, string);
                    }
                    if (Record.class.isAssignableFrom(type)) {
                        return (T)DefaultRecordBinding.pgNewRecord(type, null, string);
                    }
                    if (type == Object.class) {
                        return (T)string;
                    }
                    if (type != converter.fromType()) {
                        Converter<?, ?> c = converter;
                        return c.from(DefaultRecordBinding.pgFromString(c.fromType(), string));
                    }
                }
            }
            throw new UnsupportedOperationException("Class " + type + " is not supported");
        }

        static final Record pgNewRecord(Class<?> type, Field<?>[] fields, Object object) {
            if (object == null) {
                return null;
            }
            final List<String> values = PostgresUtils.toPGObject(object.toString());
            if (fields == null && Record.class.isAssignableFrom(type)) {
                fields = Tools.fields(values.size(), SQLDataType.VARCHAR);
            }
            return Tools.newRecord(true, type, fields).operate(new RecordOperation<Record, RuntimeException>(){

                @Override
                public Record operate(Record record) {
                    Row row = record.fieldsRow();
                    for (int i = 0; i < row.size(); ++i) {
                        DefaultRecordBinding.pgSetValue(record, row.field(i), (String)values.get(i));
                    }
                    return record;
                }
            });
        }

        private static final <T> void pgSetValue(Record record, Field<T> field, String value) {
            record.set(field, DefaultRecordBinding.pgFromString(field.getConverter(), value));
        }

        private static final Object[] pgNewArray(Class<?> type, String string) {
            if (string == null) {
                return null;
            }
            try {
                Class<?> component = type.getComponentType();
                List<String> values = PostgresUtils.toPGArray(string);
                if (values.isEmpty()) {
                    return (Object[])Array.newInstance(component, 0);
                }
                Object[] result = (Object[])Array.newInstance(component, values.size());
                for (int i = 0; i < values.size(); ++i) {
                    result[i] = DefaultRecordBinding.pgFromString(type.getComponentType(), values.get(i));
                }
                return result;
            }
            catch (Exception e) {
                throw new DataTypeException("Error while creating array", e);
            }
        }
    }

    static final class DefaultOtherBinding<U>
    extends AbstractBinding<Object, U> {
        private static final long serialVersionUID = -650741489151706822L;

        DefaultOtherBinding(Converter<Object, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object value) throws SQLException {
            AbstractBinding b = (AbstractBinding)DefaultBinding.binding(value.getClass(), this.isLob);
            if (b instanceof DefaultOtherBinding) {
                ctx.statement().setObject(ctx.index(), value);
            } else {
                b.set0(ctx, value);
            }
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            ctx.statement().setObject(ctx.index(), null);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object value) throws SQLException {
            throw new DataTypeException("Type " + this.type + " is not supported");
        }

        @Override
        final Object get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.resultSet().getObject(ctx.index()));
        }

        @Override
        final Object get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.statement().getObject(ctx.index()));
        }

        @Override
        final Object get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.input().readObject());
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 1111;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Object unlob(Object object) throws SQLException {
            if (object instanceof Blob) {
                Blob blob = (Blob)object;
                try {
                    byte[] byArray = blob.getBytes(1L, (int)blob.length());
                    return byArray;
                }
                finally {
                    JDBCUtils.safeFree(blob);
                }
            }
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                try {
                    String string = clob.getSubString(1L, (int)clob.length());
                    return string;
                }
                finally {
                    JDBCUtils.safeFree(clob);
                }
            }
            return object;
        }
    }

    static final class DefaultOffsetTimeBinding<U>
    extends AbstractBinding<OffsetTime, U> {
        private static final long serialVersionUID = 8991629916239335071L;

        DefaultOffsetTimeBinding(Converter<OffsetTime, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, OffsetTime value) {
            ((RenderContext)ctx.render().visit(Keywords.K_TIME_WITH_TIME_ZONE)).sql(" '").sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render())).sql('\'');
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, OffsetTime value) throws SQLException {
            String string = DefaultOffsetTimeBinding.format(value);
            ctx.statement().setString(ctx.index(), string);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, OffsetTime value) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.type + " is not supported");
        }

        @Override
        final OffsetTime get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return OffsetDateTimeParser.offsetTime(ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final OffsetTime get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return OffsetDateTimeParser.offsetTime(ctx.statement().getString(ctx.index()));
        }

        @Override
        final OffsetTime get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.type + " is not supported");
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 12;
        }

        private static final String format(OffsetTime val) {
            return StringUtils.replace(val.format(DateTimeFormatter.ISO_OFFSET_TIME), "Z", "+00:00");
        }
    }

    static final class DefaultOffsetDateTimeBinding<U>
    extends AbstractBinding<OffsetDateTime, U> {
        private static final long serialVersionUID = 2775682497765456476L;
        private static final DateTimeFormatter ERA = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnnZZZZZ G", Locale.US);

        DefaultOffsetDateTimeBinding(Converter<OffsetDateTime, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, OffsetDateTime value) {
            SQLDialect family = ctx.family();
            if (family == SQLDialect.H2) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql("('").sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render())).sql("' ").visit(Keywords.K_AS)).sql(' ').visit(Keywords.K_TIMESTAMP_WITH_TIME_ZONE)).sql(')');
            } else {
                ((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP_WITH_TIME_ZONE)).sql(" '").sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render())).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, OffsetDateTime value) throws SQLException {
            SQLDialect family = ctx.family();
            ctx.statement().setString(ctx.index(), DefaultOffsetDateTimeBinding.format(value, family));
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, OffsetDateTime value) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.type + " is not supported");
        }

        @Override
        final OffsetDateTime get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return OffsetDateTimeParser.offsetDateTime(ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final OffsetDateTime get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return OffsetDateTimeParser.offsetDateTime(ctx.statement().getString(ctx.index()));
        }

        @Override
        final OffsetDateTime get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.type + " is not supported");
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 12;
        }

        private static final String format(OffsetDateTime val, SQLDialect family) {
            if (family == SQLDialect.POSTGRES && val.getYear() <= 0) {
                return DefaultOffsetDateTimeBinding.formatEra(val);
            }
            String format = DefaultOffsetDateTimeBinding.formatISO(val);
            return StringUtils.replace(format.substring(0, 10) + ' ' + format.substring(11), "Z", "+00:00");
        }

        private static final String formatISO(OffsetDateTime val) {
            return val.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        private static final String formatEra(OffsetDateTime val) {
            return val.format(ERA);
        }
    }

    static final class OffsetDateTimeParser {
        OffsetDateTimeParser() {
        }

        static final OffsetTime offsetTime(String string) {
            if (string == null) {
                return null;
            }
            int[] position = new int[]{0};
            return OffsetTime.of(OffsetDateTimeParser.parseLocalTime(string, position), OffsetDateTimeParser.parseOffset(string, position));
        }

        static final OffsetDateTime offsetDateTime(String string) {
            if (string == null) {
                return null;
            }
            int[] position = new int[]{0};
            LocalDate d = OffsetDateTimeParser.parseLocalDate(string, position);
            OffsetDateTimeParser.parseAnyChar(string, position, " T");
            LocalTime t = OffsetDateTimeParser.parseLocalTime(string, position);
            ZoneOffset offset = OffsetDateTimeParser.parseOffset(string, position);
            return OffsetDateTimeParser.parseBCIf(string, position) ? OffsetDateTime.of(d.withYear(1 - d.getYear()), t, offset) : OffsetDateTime.of(d, t, offset);
        }

        static final LocalDate parseLocalDate(String string, int[] position) {
            int year = OffsetDateTimeParser.parseInt(string, position, 4);
            OffsetDateTimeParser.parseChar(string, position, '-');
            int month = OffsetDateTimeParser.parseInt(string, position, 2);
            OffsetDateTimeParser.parseChar(string, position, '-');
            int day = OffsetDateTimeParser.parseInt(string, position, 2);
            return LocalDate.of(year, month, day);
        }

        static final LocalTime parseLocalTime(String string, int[] position) {
            int hour = OffsetDateTimeParser.parseInt(string, position, 2);
            if (hour == 24) {
                hour %= 24;
            }
            OffsetDateTimeParser.parseChar(string, position, ':');
            int minute = OffsetDateTimeParser.parseInt(string, position, 2);
            int second = 0;
            int nano = 0;
            if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                second = OffsetDateTimeParser.parseInt(string, position, 2);
                if (OffsetDateTimeParser.parseCharIf(string, position, '.')) {
                    nano = OffsetDateTimeParser.parseInt(string, position, 9, true);
                }
            }
            return LocalTime.of(hour, minute, second, nano);
        }

        private static final ZoneOffset parseOffset(String string, int[] position) {
            int offsetHours = 0;
            int offsetMinutes = 0;
            int offsetSeconds = 0;
            if (!OffsetDateTimeParser.parseCharIf(string, position, 'Z')) {
                boolean plus;
                while (OffsetDateTimeParser.parseCharIf(string, position, ' ')) {
                }
                boolean minus = OffsetDateTimeParser.parseCharIf(string, position, '-');
                boolean bl = plus = !minus && OffsetDateTimeParser.parseCharIf(string, position, '+');
                if (minus || plus) {
                    offsetHours = OffsetDateTimeParser.parseInt(string, position, 1);
                    if (Character.isDigit(string.charAt(position[0]))) {
                        offsetHours = offsetHours * 10 + OffsetDateTimeParser.parseInt(string, position, 1);
                    }
                    if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                        offsetMinutes = OffsetDateTimeParser.parseInt(string, position, 2);
                    }
                    if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                        offsetSeconds = OffsetDateTimeParser.parseInt(string, position, 2);
                    }
                    if (minus) {
                        offsetHours = -offsetHours;
                        offsetMinutes = -offsetMinutes;
                        offsetSeconds = -offsetSeconds;
                    }
                }
            }
            return ZoneOffset.ofHoursMinutesSeconds(offsetHours, offsetMinutes, offsetSeconds);
        }

        private static final void parseAnyChar(String string, int[] position, String expected) {
            for (int i = 0; i < expected.length(); ++i) {
                if (string.charAt(position[0]) != expected.charAt(i)) continue;
                position[0] = position[0] + 1;
                return;
            }
            throw new IllegalArgumentException("Expected any of \"" + expected + "\" at position " + position[0] + " in " + string);
        }

        private static final boolean parseBCIf(String string, int[] position) {
            return OffsetDateTimeParser.parseCharIf(string, position, ' ') && OffsetDateTimeParser.parseCharIf(string, position, 'B') && OffsetDateTimeParser.parseCharIf(string, position, 'C');
        }

        private static final boolean parseCharIf(String string, int[] position, char expected) {
            boolean result;
            boolean bl = result = string.length() > position[0] && string.charAt(position[0]) == expected;
            if (result) {
                position[0] = position[0] + 1;
            }
            return result;
        }

        private static final void parseChar(String string, int[] position, char expected) {
            if (!OffsetDateTimeParser.parseCharIf(string, position, expected)) {
                throw new IllegalArgumentException("Expected '" + expected + "' at position " + position[0] + " in " + string);
            }
        }

        private static final int parseInt(String string, int[] position, int maxLength) {
            return OffsetDateTimeParser.parseInt(string, position, maxLength, false);
        }

        private static final int parseInt(String string, int[] position, int maxLength, boolean rightPad) {
            int digit;
            int length;
            int result = 0;
            int pos = position[0];
            for (length = 0; length < maxLength && pos + length < string.length() && (digit = string.charAt(pos + length) - 48) >= 0 && digit < 10; ++length) {
                result = result * 10 + digit;
            }
            if (rightPad && length < maxLength && result > 0) {
                for (int i = length; i < maxLength; ++i) {
                    result *= 10;
                }
            }
            position[0] = pos + length;
            return result;
        }
    }

    static final class DefaultLongBinding<U>
    extends AbstractBinding<Long, U> {
        private static final long serialVersionUID = 7360911614219750448L;

        DefaultLongBinding(Converter<Long, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Long value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Long value) throws SQLException {
            ctx.statement().setLong(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Long value) throws SQLException {
            ctx.output().writeLong(value);
        }

        @Override
        final Long get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Long.valueOf(ctx.resultSet().getLong(ctx.index())));
        }

        @Override
        final Long get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Long.valueOf(ctx.statement().getLong(ctx.index())));
        }

        @Override
        final Long get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Long.valueOf(ctx.input().readLong()));
        }

        @Override
        final int sqltype(Configuration configuration) {
            return -5;
        }
    }

    static final class DefaultIntegerBinding<U>
    extends AbstractBinding<Integer, U> {
        private static final long serialVersionUID = 1356528214897599147L;

        DefaultIntegerBinding(Converter<Integer, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Integer value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Integer value) throws SQLException {
            ctx.statement().setInt(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Integer value) throws SQLException {
            ctx.output().writeInt(value);
        }

        @Override
        final Integer get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Integer.valueOf(ctx.resultSet().getInt(ctx.index())));
        }

        @Override
        final Integer get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Integer.valueOf(ctx.statement().getInt(ctx.index())));
        }

        @Override
        final Integer get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Integer.valueOf(ctx.input().readInt()));
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 4;
        }
    }

    static final class DefaultFloatBinding<U>
    extends AbstractBinding<Float, U> {
        private static final long serialVersionUID = -2468794191255859536L;

        DefaultFloatBinding(Converter<Float, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Float value) {
            if (value.isNaN()) {
                if (ctx.family() == SQLDialect.POSTGRES) {
                    ((RenderContext)ctx.render().visit(DSL.inline("NaN"))).sql("::float4");
                } else if (ctx.family() == SQLDialect.HSQLDB) {
                    ctx.render().visit(DSL.sqrt(DSL.inline(-1)));
                } else {
                    ((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql('(').visit(DSL.inline("NaN"))).sql(' ').visit(Keywords.K_AS)).sql(' ').visit(DSL.keyword(SQLDataType.DOUBLE.getCastTypeName(ctx.configuration())))).sql(')');
                }
            } else {
                ctx.render().sql(value.toString());
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Float value) throws SQLException {
            ctx.statement().setFloat(ctx.index(), value.floatValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Float value) throws SQLException {
            ctx.output().writeFloat(value.floatValue());
        }

        @Override
        final Float get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Float.valueOf(ctx.resultSet().getFloat(ctx.index())));
        }

        @Override
        final Float get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Float.valueOf(ctx.statement().getFloat(ctx.index())));
        }

        @Override
        final Float get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Float.valueOf(ctx.input().readFloat()));
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 6;
        }
    }

    static final class DefaultEnumTypeBinding<U>
    extends AbstractBinding<EnumType, U> {
        private static final long serialVersionUID = -5858761464381778695L;

        DefaultEnumTypeBinding(Converter<EnumType, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, EnumType value) throws SQLException {
            String literal = value.getLiteral();
            if (literal == null) {
                DefaultBinding.binding(String.class, this.isLob).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
            } else {
                DefaultBinding.binding(String.class, this.isLob).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
            }
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, EnumType value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (ctx.family() == SQLDialect.POSTGRES) {
                DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.type);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, EnumType value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.getLiteral());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, EnumType value) throws SQLException {
            ctx.output().writeString(value.getLiteral());
        }

        @Override
        final EnumType get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.type(), ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final EnumType get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.type(), ctx.statement().getString(ctx.index()));
        }

        @Override
        final EnumType get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.type(), ctx.input().readString());
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 12;
        }

        static final void pgRenderEnumCast(RenderContext render, Class<?> type) {
            Class<?> enumType = type.isArray() ? type.getComponentType() : type;
            EnumType[] enums = Tools.enums(enumType);
            if (enums == null || enums.length == 0) {
                throw new IllegalArgumentException("Not a valid EnumType : " + type);
            }
            Schema schema = enums[0].getSchema();
            if (schema != null) {
                render.sql("::");
                schema = DSL.using(render.configuration()).map(schema);
                if (schema != null && Boolean.TRUE.equals(render.configuration().settings().isRenderSchema())) {
                    render.visit(schema);
                    render.sql('.');
                }
                render.visit(DSL.name(enums[0].getName()));
            }
            if (type.isArray()) {
                render.sql("[]");
            }
        }

        static final <E extends EnumType> E getEnumType(Class<? extends E> type, String literal) {
            try {
                EnumType[] list;
                for (EnumType e : list = Tools.enums(type)) {
                    if (!e.getLiteral().equals(literal)) continue;
                    return (E)e;
                }
            }
            catch (Exception e) {
                throw new DataTypeException("Unknown enum literal found : " + literal);
            }
            return null;
        }
    }

    static final class DefaultDoubleBinding<U>
    extends AbstractBinding<Double, U> {
        private static final long serialVersionUID = -615723070592774059L;

        DefaultDoubleBinding(Converter<Double, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Double value) {
            if (value.isNaN()) {
                if (ctx.family() == SQLDialect.POSTGRES) {
                    ((RenderContext)ctx.render().visit(DSL.inline("NaN"))).sql("::float8");
                } else if (ctx.family() == SQLDialect.HSQLDB) {
                    ctx.render().visit(DSL.sqrt(DSL.inline(-1)));
                } else {
                    ((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql('(').visit(DSL.inline("NaN"))).sql(' ').visit(Keywords.K_AS)).sql(' ').visit(DSL.keyword(SQLDataType.DOUBLE.getCastTypeName(ctx.configuration())))).sql(')');
                }
            } else {
                ctx.render().sql(value.toString());
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Double value) throws SQLException {
            ctx.statement().setDouble(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Double value) throws SQLException {
            ctx.output().writeDouble(value);
        }

        @Override
        final Double get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Double.valueOf(ctx.resultSet().getDouble(ctx.index())));
        }

        @Override
        final Double get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Double.valueOf(ctx.statement().getDouble(ctx.index())));
        }

        @Override
        final Double get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Double.valueOf(ctx.input().readDouble()));
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 8;
        }
    }

    static final class DefaultDayToSecondBinding<U>
    extends AbstractBinding<DayToSecond, U> {
        private static final long serialVersionUID = 4378118707359663541L;

        DefaultDayToSecondBinding(Converter<DayToSecond, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, DayToSecond value) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), value.toString());
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, DayToSecond value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final DayToSecond get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toDayToSecond(object);
            }
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : DayToSecond.valueOf(string);
        }

        @Override
        final DayToSecond get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.POSTGRES) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toDayToSecond(object);
            }
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : DayToSecond.valueOf(string);
        }

        @Override
        final DayToSecond get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : DayToSecond.valueOf(string);
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultDateBinding<U>
    extends AbstractBinding<java.sql.Date, U> {
        private static final long serialVersionUID = -4797649501187223237L;
        private static final EnumSet<SQLDialect> INLINE_AS_STRING_LITERAL = EnumSet.of(SQLDialect.SQLITE);

        DefaultDateBinding(Converter<java.sql.Date, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, java.sql.Date value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.family())) {
                ctx.render().sql('\'').sql(DefaultDateBinding.escape(value, ctx.render())).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)ctx.render().visit(Keywords.K_DATE)).sql("('").sql(DefaultDateBinding.escape(value, ctx.render())).sql("')");
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.family())) {
                ctx.render().sql("{d '").sql(DefaultDateBinding.escape(value, ctx.render())).sql("'}");
            } else {
                ((RenderContext)ctx.render().visit(Keywords.K_DATE)).sql(" '").sql(DefaultDateBinding.escape(value, ctx.render())).sql('\'');
            }
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, java.sql.Date value) throws SQLException {
            super.sqlBind0(ctx, value);
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, java.sql.Date value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setDate(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, java.sql.Date value) throws SQLException {
            ctx.output().writeDate(value);
        }

        @Override
        final java.sql.Date get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            SQLDialect family = ctx.family();
            if (family == SQLDialect.SQLITE) {
                String date = ctx.resultSet().getString(ctx.index());
                return date == null ? null : new java.sql.Date(DefaultBinding.parse(java.sql.Date.class, date));
            }
            return ctx.resultSet().getDate(ctx.index());
        }

        @Override
        final java.sql.Date get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getDate(ctx.index());
        }

        @Override
        final java.sql.Date get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readDate();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 91;
        }
    }

    static final class DefaultClobBinding<U>
    extends AbstractBinding<Clob, U> {
        private static final long serialVersionUID = -3890447233590678873L;

        DefaultClobBinding(Converter<Clob, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Clob value) throws SQLException {
            ctx.statement().setClob(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Clob value) throws SQLException {
            ctx.output().writeClob(value);
        }

        @Override
        final Clob get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getClob(ctx.index());
        }

        @Override
        final Clob get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getClob(ctx.index());
        }

        @Override
        final Clob get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readClob();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 2005;
        }
    }

    static final class DefaultBytesBinding<U>
    extends AbstractBinding<byte[], U> {
        private static final long serialVersionUID = -727202499908007757L;
        private static final EnumSet<SQLDialect> INLINE_AS_X_APOS = EnumSet.of(SQLDialect.DERBY, new SQLDialect[]{SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE});

        DefaultBytesBinding(Converter<byte[], U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, byte[] value) {
            if (INLINE_AS_X_APOS.contains((Object)ctx.family())) {
                ctx.render().sql("X'").sql(Tools.convertBytesToHex(value)).sql('\'');
            } else if (ctx.family() == SQLDialect.POSTGRES) {
                ctx.render().sql("E'").sql(PostgresUtils.toPGString(value)).sql("'::bytea");
            } else {
                ctx.render().sql("X'").sql(Tools.convertBytesToHex(value)).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, byte[] value) throws SQLException {
            ctx.statement().setBytes(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, byte[] value) throws SQLException {
            ctx.output().writeBytes(value);
        }

        @Override
        final byte[] get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getBytes(ctx.index());
        }

        @Override
        final byte[] get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBytes(ctx.index());
        }

        @Override
        final byte[] get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBytes();
        }

        @Override
        final int sqltype(Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: {
                    return -2;
                }
            }
            return 2004;
        }
    }

    static final class DefaultByteBinding<U>
    extends AbstractBinding<Byte, U> {
        private static final long serialVersionUID = -7328193812163714614L;

        DefaultByteBinding(Converter<Byte, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Byte value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Byte value) throws SQLException {
            ctx.statement().setByte(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Byte value) throws SQLException {
            ctx.output().writeByte(value);
        }

        @Override
        final Byte get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Byte.valueOf(ctx.resultSet().getByte(ctx.index())));
        }

        @Override
        final Byte get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Byte.valueOf(ctx.statement().getByte(ctx.index())));
        }

        @Override
        final Byte get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Byte.valueOf(ctx.input().readByte()));
        }

        @Override
        final int sqltype(Configuration configuration) {
            return -6;
        }
    }

    static final class DefaultBooleanBinding<U>
    extends AbstractBinding<Boolean, U> {
        private static final long serialVersionUID = -533762957890251203L;
        private static final EnumSet<SQLDialect> BIND_AS_1_0 = EnumSet.of(SQLDialect.FIREBIRD, SQLDialect.SQLITE);

        DefaultBooleanBinding(Converter<Boolean, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Boolean value) {
            if (BIND_AS_1_0.contains((Object)ctx.family())) {
                ctx.render().sql(value != false ? "1" : "0");
            } else {
                ctx.render().visit(value != false ? Keywords.K_TRUE : Keywords.K_FALSE);
            }
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Boolean value) throws SQLException {
            ctx.statement().setBoolean(ctx.index(), value);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Boolean value) throws SQLException {
            ctx.output().writeBoolean(value);
        }

        @Override
        final Boolean get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), (Boolean)ctx.resultSet().getBoolean(ctx.index()));
        }

        @Override
        final Boolean get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), (Boolean)ctx.statement().getBoolean(ctx.index()));
        }

        @Override
        final Boolean get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), (Boolean)ctx.input().readBoolean());
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 16;
        }
    }

    static final class DefaultBlobBinding<U>
    extends AbstractBinding<Blob, U> {
        private static final long serialVersionUID = -4605427469676162501L;

        DefaultBlobBinding(Converter<Blob, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Blob value) throws SQLException {
            ctx.statement().setBlob(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Blob value) throws SQLException {
            ctx.output().writeBlob(value);
        }

        @Override
        final Blob get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getBlob(ctx.index());
        }

        @Override
        final Blob get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBlob(ctx.index());
        }

        @Override
        final Blob get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBlob();
        }

        @Override
        final int sqltype(Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: {
                    return -2;
                }
            }
            return 2004;
        }
    }

    static final class DefaultBigIntegerBinding<U>
    extends AbstractBinding<BigInteger, U> {
        private static final long serialVersionUID = -3857031689661809421L;
        private static final EnumSet<SQLDialect> BIND_AS_STRING = EnumSet.of(SQLDialect.SQLITE);

        DefaultBigIntegerBinding(Converter<BigInteger, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, BigInteger value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, BigInteger value) throws SQLException {
            if (BIND_AS_STRING.contains((Object)ctx.family())) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, BigInteger value) throws SQLException {
            ctx.output().writeBigDecimal(new BigDecimal(value));
        }

        @Override
        final BigInteger get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.configuration().dialect() == SQLDialect.SQLITE) {
                return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigInteger.class);
            }
            BigDecimal b = ctx.resultSet().getBigDecimal(ctx.index());
            return b == null ? null : b.toBigInteger();
        }

        @Override
        final BigInteger get0(BindingGetStatementContext<U> ctx) throws SQLException {
            BigDecimal d = ctx.statement().getBigDecimal(ctx.index());
            return d == null ? null : d.toBigInteger();
        }

        @Override
        final BigInteger get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            BigDecimal d = ctx.input().readBigDecimal();
            return d == null ? null : d.toBigInteger();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultBigDecimalBinding<U>
    extends AbstractBinding<BigDecimal, U> {
        private static final long serialVersionUID = -8912971184035434281L;
        private static final EnumSet<SQLDialect> BIND_AS_STRING = EnumSet.of(SQLDialect.SQLITE);

        DefaultBigDecimalBinding(Converter<BigDecimal, U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, BigDecimal value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, BigDecimal value) throws SQLException {
            if (BIND_AS_STRING.contains((Object)ctx.family())) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setBigDecimal(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, BigDecimal value) throws SQLException {
            ctx.output().writeBigDecimal(value);
        }

        @Override
        final BigDecimal get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigDecimal.class);
            }
            return ctx.resultSet().getBigDecimal(ctx.index());
        }

        @Override
        final BigDecimal get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBigDecimal(ctx.index());
        }

        @Override
        final BigDecimal get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBigDecimal();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultArrayBinding<U>
    extends AbstractBinding<Object[], U> {
        private static final long serialVersionUID = 6875984626674331432L;

        DefaultArrayBinding(Converter<Object[], U> converter, boolean isLob) {
            super(converter, isLob);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Object[] value) throws SQLException {
            String separator = "";
            if (ctx.family() == SQLDialect.H2) {
                ctx.render().sql('(');
                for (Object o : value) {
                    ctx.render().sql(separator);
                    DefaultBinding.binding(this.type.getComponentType(), this.isLob).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                    separator = ", ";
                }
                ctx.render().sql(')');
            } else if (ctx.family() == SQLDialect.POSTGRES) {
                ctx.render().visit(DSL.cast(DSL.inline(PostgresUtils.toPGArrayString(value)), this.type));
            } else {
                ctx.render().visit(Keywords.K_ARRAY);
                ctx.render().sql('[');
                for (Object o : value) {
                    ctx.render().sql(separator);
                    DefaultBinding.binding(this.type.getComponentType(), this.isLob).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                    separator = ", ";
                }
                ctx.render().sql(']');
                if (ctx.family() == SQLDialect.POSTGRES && EnumType.class.isAssignableFrom(this.type.getComponentType())) {
                    DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.type);
                }
            }
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, Object[] value) throws SQLException {
            super.sqlBind0(ctx, value);
            switch (ctx.family()) {
                case POSTGRES: {
                    if (EnumType.class.isAssignableFrom(this.type.getComponentType())) {
                        DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.type);
                        break;
                    }
                    ctx.render().sql("::").sql(DefaultDataType.getDataType(ctx.family(), this.type).getCastTypeName(ctx.render().configuration()));
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object[] value) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    ctx.statement().setString(ctx.index(), PostgresUtils.toPGArrayString(value));
                    break;
                }
                case HSQLDB: {
                    Object[] a = value;
                    Class<byte[][]> t = this.type;
                    if (t == UUID[].class) {
                        a = Convert.convertArray(a, byte[][].class);
                        t = byte[][].class;
                    }
                    ctx.statement().setArray(ctx.index(), new MockArray<Object>(ctx.family(), a, t));
                    break;
                }
                case H2: {
                    ctx.statement().setObject(ctx.index(), value);
                    break;
                }
                default: {
                    throw new SQLDialectNotSupportedException("Cannot bind ARRAY types in dialect " + (Object)((Object)ctx.family()));
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object[] value) throws SQLException {
            ctx.output().writeArray(new MockArray<Object>(ctx.family(), value, this.type()));
        }

        @Override
        final Object[] get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    return (Object[])DefaultArrayBinding.pgGetArray(ctx, ctx.resultSet(), this.type, ctx.index());
                }
            }
            return DefaultArrayBinding.convertArray(ctx.resultSet().getArray(ctx.index()), this.type());
        }

        @Override
        final Object[] get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultArrayBinding.convertArray(ctx.statement().getObject(ctx.index()), this.type());
        }

        @Override
        final Object[] get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            java.sql.Array array = ctx.input().readArray();
            return array == null ? null : (Object[])array.getArray();
        }

        @Override
        final int sqltype(Configuration configuration) {
            return 2003;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final <T> T pgGetArray(Scope ctx, ResultSet rs, Class<T> type, int index) throws SQLException {
            java.sql.Array array = null;
            try {
                array = rs.getArray(index);
                if (array == null) {
                    T t = null;
                    return t;
                }
                if (byte[][].class == type) {
                    throw new ControlFlowSignal("GOTO the next array deserialisation strategy");
                }
                Object[] objectArray = DefaultArrayBinding.convertArray(array, type);
                return (T)objectArray;
            }
            finally {
                JDBCUtils.safeFree(array);
            }
        }

        private static final Object[] convertArray(Object array, Class<? extends Object[]> type) throws SQLException {
            if (array instanceof Object[]) {
                return Convert.convert(array, type);
            }
            if (array instanceof java.sql.Array) {
                return DefaultArrayBinding.convertArray((java.sql.Array)array, type);
            }
            return null;
        }

        private static final Object[] convertArray(java.sql.Array array, Class<? extends Object[]> type) throws SQLException {
            if (array != null) {
                return Convert.convert(array.getArray(), type);
            }
            return null;
        }
    }

    static final class DelegatingBinding<X, T, U>
    extends AbstractBinding<X, U> {
        private static final long serialVersionUID = 9222783475194108822L;
        private final Converter<T, X> delegatingConverter;
        private final AbstractBinding<T, U> delegatingBinding;

        DelegatingBinding(Converter<T, X> delegatingConverter, Converter<X, U> originalConverter, AbstractBinding<T, U> delegatingBinding, boolean isLob) {
            super(originalConverter, isLob);
            this.delegatingConverter = delegatingConverter;
            this.delegatingBinding = delegatingBinding;
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.sqlInline0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.sqlBind0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.set0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            this.delegatingBinding.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.set0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final X get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final X get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final X get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final int sqltype(Configuration configuration) throws SQLException {
            return this.delegatingBinding.sqltype(configuration);
        }
    }

    static abstract class AbstractBinding<T, U>
    implements Binding<T, U> {
        private static final long serialVersionUID = -7965247586545864991L;
        private static final EnumSet<SQLDialect> NEEDS_PRECISION_SCALE_ON_BIGDECIMAL = EnumSet.of(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
        final Class<T> type;
        final Converter<T, U> converter;
        final boolean isLob;

        AbstractBinding(Converter<T, U> converter, boolean isLob) {
            this.type = converter.fromType();
            this.converter = converter;
            this.isLob = isLob;
        }

        @Override
        public final Converter<T, U> converter() {
            return this.converter;
        }

        private final boolean shouldCast(BindingSQLContext<U> ctx, T converted) {
            if (ctx.render().paramType() != ParamType.INLINED && !(converted instanceof EnumType)) {
                switch (ctx.family()) {
                    case DERBY: 
                    case FIREBIRD: 
                    case H2: 
                    case HSQLDB: 
                    case CUBRID: 
                    case POSTGRES: {
                        return true;
                    }
                }
            }
            if (Interval.class.isAssignableFrom(this.type)) {
                switch (ctx.family()) {
                    case POSTGRES: {
                        return true;
                    }
                }
            }
            return false;
        }

        private final void sqlCast(BindingSQLContext<U> ctx, T converted) throws SQLException {
            DataType<T> dataType = DefaultDataType.getDataType(ctx.dialect(), this.type);
            DataType<T> sqlDataType = dataType.getSQLDataType();
            SQLDialect family = ctx.family();
            if (converted != null && this.type == BigDecimal.class && NEEDS_PRECISION_SCALE_ON_BIGDECIMAL.contains((Object)family)) {
                int precision;
                int scale = ((BigDecimal)converted).scale();
                if (scale >= (precision = ((BigDecimal)converted).precision())) {
                    precision = scale + 1;
                }
                this.sqlCast(ctx, converted, dataType, 0, precision, scale);
            } else if (SQLDataType.OTHER == sqlDataType) {
                if (converted != null) {
                    this.sqlCast(ctx, converted, DefaultDataType.getDataType(family, converted.getClass()), 0, 0, 0);
                } else {
                    this.sqlCast(ctx, converted, DefaultDataType.getDataType(family, String.class), 0, 0, 0);
                }
            } else if (SQLDialect.POSTGRES == family && (sqlDataType == null || !sqlDataType.isTemporal() && sqlDataType != SQLDataType.UUID)) {
                this.sql(ctx, converted);
            } else if (SQLDialect.FIREBIRD == family && (sqlDataType == SQLDataType.VARCHAR || sqlDataType == SQLDataType.CHAR)) {
                this.sqlCast(ctx, converted, dataType, AbstractBinding.getValueLength((String)converted), 0, 0);
            } else if (SQLDialect.POSTGRES != family && EnumType.class.isAssignableFrom(this.type)) {
                this.sqlCast(ctx, converted, Tools.emulateEnumType(dataType), dataType.length(), dataType.precision(), dataType.scale());
            } else {
                this.sqlCast(ctx, converted, dataType, dataType.length(), dataType.precision(), dataType.scale());
            }
        }

        private static final int getValueLength(String string) {
            if (string == null) {
                return 1;
            }
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                if (string.charAt(i) <= '\u007f') continue;
                return Math.min(32672, 4 * length);
            }
            return Math.min(32672, length);
        }

        private final void sqlCast(BindingSQLContext<U> ctx, T converted, DataType<?> dataType, int length, int precision, int scale) throws SQLException {
            ((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql('(');
            this.sql(ctx, converted);
            ((RenderContext)ctx.render().sql(' ').visit(Keywords.K_AS)).sql(' ').sql(dataType.length(length).precision(precision, scale).getCastTypeName(ctx.configuration())).sql(')');
        }

        @Override
        public final void sql(BindingSQLContext<U> ctx) throws SQLException {
            T converted = this.converter().to(ctx.value());
            switch (ctx.render().castMode()) {
                case NEVER: {
                    this.sql(ctx, converted);
                    return;
                }
                case ALWAYS: {
                    this.sqlCast(ctx, converted);
                    return;
                }
            }
            if (this.shouldCast(ctx, converted)) {
                this.sqlCast(ctx, converted);
            } else {
                this.sql(ctx, converted);
            }
        }

        private final void sql(BindingSQLContext<U> ctx, T value) throws SQLException {
            if (ctx.render().paramType() == ParamType.INLINED) {
                if (value == null) {
                    ctx.render().visit(Keywords.K_NULL);
                } else {
                    this.sqlInline0(ctx, value);
                }
            } else {
                this.sqlBind0(ctx, value);
            }
        }

        static final String escape(Object val, Context<?> context) {
            String result = val.toString();
            if (Tools.needsBackslashEscaping(context.configuration())) {
                result = StringUtils.replace(result, "\\", "\\\\");
            }
            return StringUtils.replace(result, "'", "''");
        }

        @Override
        public final void register(BindingRegisterContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && log.isTraceEnabled()) {
                log.trace((Object)("Registering variable " + ctx.index()), "" + this.type);
            }
            this.register0(ctx);
        }

        @Override
        public final void set(BindingSetStatementContext<U> ctx) throws SQLException {
            T value = this.converter().to(ctx.value());
            if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && log.isTraceEnabled()) {
                if (value != null && value.getClass().isArray() && value.getClass() != byte[].class) {
                    log.trace((Object)("Binding variable " + ctx.index()), Arrays.asList((Object[])value) + " (" + this.type + ")");
                } else {
                    log.trace((Object)("Binding variable " + ctx.index()), value + " (" + this.type + ")");
                }
            }
            if (value == null) {
                this.setNull0(ctx);
            } else {
                this.set0(ctx, value);
            }
        }

        @Override
        public final void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
            T value = this.converter().to(ctx.value());
            if (value == null) {
                ctx.output().writeObject(null);
            } else {
                this.set0(ctx, value);
            }
        }

        @Override
        public final void get(BindingGetResultSetContext<U> ctx) throws SQLException {
            ctx.value(AbstractBinding.attach(this.converter().from(this.get0(ctx)), ctx.configuration()));
        }

        @Override
        public final void get(BindingGetStatementContext<U> ctx) throws SQLException {
            ctx.value(AbstractBinding.attach(this.converter().from(this.get0(ctx)), ctx.configuration()));
        }

        @Override
        public final void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
            ctx.value(AbstractBinding.attach(this.converter().from(this.get0(ctx)), ctx.configuration()));
        }

        private static final <U> U attach(U value, Configuration configuration) {
            if (value instanceof Attachable && Tools.attachRecords(configuration)) {
                ((Attachable)value).attach(configuration);
            }
            return value;
        }

        final Class<T> type() {
            return this.type;
        }

        void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            ctx.statement().setNull(ctx.index(), this.sqltype(ctx.configuration()));
        }

        void register0(BindingRegisterContext<U> ctx) throws SQLException {
            ctx.statement().registerOutParameter(ctx.index(), this.sqltype(ctx.configuration()));
        }

        void sqlInline0(BindingSQLContext<U> ctx, T value) throws SQLException {
            ctx.render().sql('\'').sql(AbstractBinding.escape(value, ctx.render()), true).sql('\'');
        }

        void sqlBind0(BindingSQLContext<U> ctx, T value) throws SQLException {
            ctx.render().sql(ctx.variable());
        }

        abstract void set0(BindingSetStatementContext<U> var1, T var2) throws SQLException;

        abstract void set0(BindingSetSQLOutputContext<U> var1, T var2) throws SQLException;

        abstract T get0(BindingGetResultSetContext<U> var1) throws SQLException;

        abstract T get0(BindingGetStatementContext<U> var1) throws SQLException;

        abstract T get0(BindingGetSQLInputContext<U> var1) throws SQLException;

        abstract int sqltype(Configuration var1) throws SQLException;

        public String toString() {
            return "AbstractBinding [type=" + this.type + ", converter=" + this.converter + "]";
        }
    }
}

