/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.util.NativeCRC32Wrapper;

public class NativeCheckSumCRC32
implements Checksum {
    private int checksumType;
    private int bytesPerSum;
    private ByteBuffer checksum = ByteBuffer.allocate(4);
    private boolean needsReset = false;

    public NativeCheckSumCRC32(int checksumType, int bytesPerSum) {
        this.checksumType = checksumType;
        this.bytesPerSum = bytesPerSum;
    }

    @Override
    public void update(int b) {
        throw new NotImplementedException("Update method is not implemented");
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (this.needsReset) {
            throw new IllegalArgumentException("This checksum implementation is not updatable");
        }
        NativeCRC32Wrapper.calculateChunkedSumsByteArray(this.bytesPerSum, this.checksumType, this.checksum.array(), 0, b, off, len);
        this.needsReset = true;
    }

    @Override
    public long getValue() {
        this.checksum.position(0);
        return this.checksum.getInt();
    }

    @Override
    public void reset() {
        this.checksum.clear();
        this.needsReset = false;
    }
}

