/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.grpc.metrics;

import com.google.protobuf.AbstractMessage;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.apache.hadoop.ozone.grpc.metrics.GrpcMetrics;

public class GrpcMetricsServerResponseInterceptor
implements ServerInterceptor {
    private final GrpcMetrics grpcMetrics;

    public GrpcMetricsServerResponseInterceptor(GrpcMetrics grpcMetrics) {
        this.grpcMetrics = grpcMetrics;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

            public void sendMessage(RespT message) {
                long messageSize = 0L;
                if (message instanceof AbstractMessage) {
                    AbstractMessage parsedMessage = (AbstractMessage)message;
                    messageSize += (long)parsedMessage.getSerializedSize();
                } else {
                    GrpcMetricsServerResponseInterceptor.this.grpcMetrics.incrUnknownMessagesSent();
                }
                GrpcMetricsServerResponseInterceptor.this.grpcMetrics.incrSentBytes(messageSize);
                super.sendMessage(message);
            }
        }, headers);
    }
}

