/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.freon;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.freon.FakeClusterTopology;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FakeScmBlockLocationProtocolClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeScmBlockLocationProtocolClient.class);
    public static final int BLOCK_PER_CONTAINER = 1000;
    private static AtomicLong counter = new AtomicLong();

    private FakeScmBlockLocationProtocolClient() {
    }

    public static ScmBlockLocationProtocolProtos.SCMBlockLocationResponse submitRequest(ScmBlockLocationProtocolProtos.SCMBlockLocationRequest req) throws IOException {
        try {
            if (req.getCmdType() == ScmBlockLocationProtocolProtos.Type.GetScmInfo) {
                return ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.newBuilder().setCmdType(req.getCmdType()).setStatus(ScmBlockLocationProtocolProtos.Status.OK).setSuccess(true).setGetScmInfoResponse(HddsProtos.GetScmInfoResponseProto.newBuilder().setScmId("scm-id").setClusterId("cluster-id").build()).build();
            }
            if (req.getCmdType() == ScmBlockLocationProtocolProtos.Type.AllocateScmBlock) {
                ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Builder allocateBlockResponse = ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.newBuilder();
                for (int i = 0; i < req.getAllocateScmBlockRequest().getNumBlocks(); ++i) {
                    long seq = counter.incrementAndGet();
                    allocateBlockResponse.addBlocks(ScmBlockLocationProtocolProtos.AllocateBlockResponse.newBuilder().setPipeline(FakeClusterTopology.INSTANCE.getRandomPipeline()).setContainerBlockID(HddsProtos.ContainerBlockID.newBuilder().setContainerID(seq / 1000L).setLocalID(seq)));
                }
                return ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.newBuilder().setCmdType(req.getCmdType()).setStatus(ScmBlockLocationProtocolProtos.Status.OK).setSuccess(true).setAllocateScmBlockResponse(allocateBlockResponse).build();
            }
            throw new IllegalArgumentException("Unsupported request. Fake answer is not implemented for " + req.getCmdType());
        }
        catch (Exception ex) {
            LOGGER.error("Error on creating fake SCM response", (Throwable)ex);
            return null;
        }
    }
}

