/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.ReconfigureProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolPB;

public class ReconfigureProtocolServerSideTranslatorPB
implements ReconfigureProtocolPB {
    private final ReconfigureProtocol impl;
    private static final ReconfigureProtocolProtos.StartReconfigureResponseProto START_RECONFIG_RESP = ReconfigureProtocolProtos.StartReconfigureResponseProto.newBuilder().build();

    public ReconfigureProtocolServerSideTranslatorPB(ReconfigureProtocol impl) {
        this.impl = impl;
    }

    public ReconfigureProtocolProtos.GetServerNameResponseProto getServerName(RpcController controller, ReconfigureProtocolProtos.GetServerNameRequestProto request) throws ServiceException {
        try {
            return ReconfigureProtocolProtos.GetServerNameResponseProto.newBuilder().setName(this.impl.getServerName()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ReconfigureProtocolProtos.StartReconfigureResponseProto startReconfigure(RpcController controller, ReconfigureProtocolProtos.StartReconfigureRequestProto request) throws ServiceException {
        try {
            this.impl.startReconfigure();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return START_RECONFIG_RESP;
    }

    public ReconfigureProtocolProtos.ListReconfigurePropertiesResponseProto listReconfigureProperties(RpcController controller, ReconfigureProtocolProtos.ListReconfigurePropertiesRequestProto request) throws ServiceException {
        try {
            return this.listReconfigureProperties(this.impl.listReconfigureProperties());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private ReconfigureProtocolProtos.ListReconfigurePropertiesResponseProto listReconfigureProperties(List<String> reconfigurableProperties) {
        ReconfigureProtocolProtos.ListReconfigurePropertiesResponseProto.Builder builder = ReconfigureProtocolProtos.ListReconfigurePropertiesResponseProto.newBuilder();
        builder.addAllName(reconfigurableProperties);
        return builder.build();
    }

    public ReconfigureProtocolProtos.GetReconfigureStatusResponseProto getReconfigureStatus(RpcController unused, ReconfigureProtocolProtos.GetReconfigureStatusRequestProto request) throws ServiceException {
        try {
            return this.getReconfigureStatus(this.impl.getReconfigureStatus());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private ReconfigureProtocolProtos.GetReconfigureStatusResponseProto getReconfigureStatus(ReconfigurationTaskStatus status) {
        ReconfigureProtocolProtos.GetReconfigureStatusResponseProto.Builder builder = ReconfigureProtocolProtos.GetReconfigureStatusResponseProto.newBuilder();
        builder.setStartTime(status.getStartTime());
        if (status.stopped()) {
            builder.setEndTime(status.getEndTime());
            assert (status.getStatus() != null);
            for (Map.Entry result : status.getStatus().entrySet()) {
                ReconfigureProtocolProtos.GetConfigurationChangeProto.Builder changeBuilder = ReconfigureProtocolProtos.GetConfigurationChangeProto.newBuilder();
                ReconfigurationUtil.PropertyChange change = (ReconfigurationUtil.PropertyChange)result.getKey();
                changeBuilder.setName(change.prop);
                changeBuilder.setOldValue(change.oldVal != null ? change.oldVal : "");
                if (change.newVal != null) {
                    changeBuilder.setNewValue(change.newVal);
                }
                if (((Optional)result.getValue()).isPresent()) {
                    changeBuilder.setErrorMessage((String)((Optional)result.getValue()).get());
                }
                builder.addChanges(changeBuilder);
            }
        }
        return builder.build();
    }
}

