/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;

public class DeletedBlocksTransactionInfoWrapper {
    private final long txID;
    private final long containerID;
    private final List<Long> localIdList;
    private final int count;

    public DeletedBlocksTransactionInfoWrapper(long txID, long containerID, List<Long> localIdList, int count) {
        this.txID = txID;
        this.containerID = containerID;
        this.localIdList = localIdList;
        this.count = count;
    }

    public static DeletedBlocksTransactionInfoWrapper fromProtobuf(HddsProtos.DeletedBlocksTransactionInfo txn) {
        if (txn.hasTxID() && txn.hasContainerID() && txn.hasCount()) {
            return new DeletedBlocksTransactionInfoWrapper(txn.getTxID(), txn.getContainerID(), txn.getLocalIDList(), txn.getCount());
        }
        return null;
    }

    public static HddsProtos.DeletedBlocksTransactionInfo toProtobuf(DeletedBlocksTransactionInfoWrapper wrapper) {
        return HddsProtos.DeletedBlocksTransactionInfo.newBuilder().setTxID(wrapper.txID).setContainerID(wrapper.containerID).addAllLocalID(wrapper.localIdList).setCount(wrapper.count).build();
    }

    public static HddsProtos.DeletedBlocksTransactionInfo fromTxn(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction txn) {
        return HddsProtos.DeletedBlocksTransactionInfo.newBuilder().setTxID(txn.getTxID()).setContainerID(txn.getContainerID()).addAllLocalID((Iterable)txn.getLocalIDList()).setCount(txn.getCount()).build();
    }

    public static StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction toTxn(HddsProtos.DeletedBlocksTransactionInfo info) {
        return StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder().setTxID(info.getTxID()).setContainerID(info.getContainerID()).addAllLocalID((Iterable)info.getLocalIDList()).setCount(info.getCount()).build();
    }

    public long getTxID() {
        return this.txID;
    }

    public long getContainerID() {
        return this.containerID;
    }

    public List<Long> getLocalIdList() {
        return this.localIdList;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "DeletedBlocksTransactionInfoWrapper{txID=" + this.txID + ", containerID=" + this.containerID + ", localIdList=" + this.localIdList + ", count=" + this.count + '}';
    }
}

