/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.proxy;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMProxyInfo;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockLocationFailoverProxyProvider
implements FailoverProxyProvider<ScmBlockLocationProtocolPB>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(SCMBlockLocationFailoverProxyProvider.class);
    private final SCMClientConfig scmClientConfig;
    private final Map<String, FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB>> scmProxies;
    private final Map<String, SCMProxyInfo> scmProxyInfoMap;
    private List<String> scmNodeIds;
    private volatile String currentProxySCMNodeId;
    private volatile int currentProxyIndex;
    private final ConfigurationSource conf;
    private final long scmVersion;
    private String scmServiceId;
    private final int maxRetryCount;
    private final long retryInterval;
    private final UserGroupInformation ugi;
    private String updatedLeaderNodeID = null;

    public SCMBlockLocationFailoverProxyProvider(ConfigurationSource conf) {
        this.conf = conf;
        this.scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ex) {
            LOG.error("Unable to fetch user credentials from UGI", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        if (this.scmServiceId == null) {
            this.scmServiceId = "scmServiceId";
        }
        this.scmProxies = new HashMap<String, FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB>>();
        this.scmProxyInfoMap = new HashMap<String, SCMProxyInfo>();
        this.loadConfigs();
        this.currentProxyIndex = 0;
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
        this.scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class);
        this.maxRetryCount = this.scmClientConfig.getRetryCount();
        this.retryInterval = this.scmClientConfig.getRetryInterval();
        LOG.info("Created block location fail-over proxy with {} nodes: {}", (Object)this.scmNodeIds.size(), this.scmProxyInfoMap.values());
    }

    private synchronized void loadConfigs() {
        this.scmNodeIds = new ArrayList<String>();
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf);
        for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
            if (scmNodeInfo.getBlockClientAddress() == null) {
                throw new ConfigurationException("SCM BlockClient Address could not be obtained from config. Config is not properly defined");
            }
            InetSocketAddress scmBlockClientAddress = NetUtils.createSocketAddr((String)scmNodeInfo.getBlockClientAddress());
            this.scmServiceId = scmNodeInfo.getServiceId();
            String scmNodeId = scmNodeInfo.getNodeId();
            this.scmNodeIds.add(scmNodeId);
            SCMProxyInfo scmProxyInfo = new SCMProxyInfo(scmNodeInfo.getServiceId(), scmNodeInfo.getNodeId(), scmBlockClientAddress);
            this.scmProxyInfoMap.put(scmNodeId, scmProxyInfo);
        }
    }

    @VisibleForTesting
    public synchronized void changeCurrentProxy(String nodeId) {
        this.currentProxyIndex = this.scmNodeIds.indexOf(nodeId);
        this.currentProxySCMNodeId = nodeId;
        this.nextProxyIndex();
    }

    private synchronized String getCurrentProxySCMNodeId() {
        return this.currentProxySCMNodeId;
    }

    public synchronized FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB> getProxy() {
        String currentProxyNodeId = this.getCurrentProxySCMNodeId();
        FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB> currentProxyInfo = this.scmProxies.get(currentProxyNodeId);
        if (currentProxyInfo == null) {
            currentProxyInfo = this.createSCMProxy(currentProxyNodeId);
        }
        return currentProxyInfo;
    }

    public synchronized void performFailover(ScmBlockLocationProtocolPB newLeader) {
        if (this.updatedLeaderNodeID != null) {
            this.currentProxySCMNodeId = this.updatedLeaderNodeID;
        } else {
            this.nextProxyIndex();
        }
    }

    public synchronized void performFailoverToAssignedLeader(String newLeader, Exception e) {
        ServerNotLeaderException snle = (ServerNotLeaderException)SCMHAUtils.getServerNotLeaderException((Exception)e);
        if (snle != null && snle.getSuggestedLeader() != null) {
            Optional<SCMProxyInfo> matchedProxyInfo = this.scmProxyInfoMap.values().stream().filter(proxyInfo -> NetUtils.getHostPortString((InetSocketAddress)proxyInfo.getAddress()).equals(snle.getSuggestedLeader())).findFirst();
            if (matchedProxyInfo.isPresent()) {
                newLeader = matchedProxyInfo.get().getNodeId();
                LOG.debug("Performing failover to suggested leader {}, nodeId {}", (Object)snle.getSuggestedLeader(), (Object)newLeader);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Suggested leader {} does not match with any of the proxyInfo adress {}", (Object)snle.getSuggestedLeader(), (Object)Arrays.toString(this.scmProxyInfoMap.values().toArray()));
            }
        }
        this.assignLeaderToNode(newLeader);
    }

    public Class<ScmBlockLocationProtocolPB> getInterface() {
        return ScmBlockLocationProtocolPB.class;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB> proxy : this.scmProxies.values()) {
            ScmBlockLocationProtocolPB scmProxy = (ScmBlockLocationProtocolPB)proxy.proxy;
            if (scmProxy == null) continue;
            RPC.stopProxy((Object)scmProxy);
        }
    }

    private synchronized long getRetryInterval() {
        return this.retryInterval;
    }

    private synchronized void nextProxyIndex() {
        this.currentProxyIndex = (this.getCurrentProxyIndex() + 1) % this.scmProxyInfoMap.size();
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
    }

    private synchronized void assignLeaderToNode(String newLeaderNodeId) {
        if (!this.currentProxySCMNodeId.equals(newLeaderNodeId)) {
            if (this.scmProxyInfoMap.containsKey(newLeaderNodeId)) {
                this.updatedLeaderNodeID = newLeaderNodeId;
                LOG.debug("Updated LeaderNodeID {}", (Object)this.updatedLeaderNodeID);
            } else {
                this.updatedLeaderNodeID = null;
            }
        }
    }

    private FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB> createSCMProxy(String nodeId) {
        SCMProxyInfo scmProxyInfo = this.scmProxyInfoMap.get(nodeId);
        InetSocketAddress address = scmProxyInfo.getAddress();
        try {
            ScmBlockLocationProtocolPB scmProxy = this.createSCMProxy(address);
            FailoverProxyProvider.ProxyInfo proxyInfo = new FailoverProxyProvider.ProxyInfo((Object)scmProxy, scmProxyInfo.toString());
            this.scmProxies.put(nodeId, (FailoverProxyProvider.ProxyInfo<ScmBlockLocationProtocolPB>)proxyInfo);
            return proxyInfo;
        }
        catch (IOException ioe) {
            LOG.error("{} Failed to create RPC proxy to SCM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
            throw new RuntimeException(ioe);
        }
    }

    private ScmBlockLocationProtocolPB createSCMProxy(InetSocketAddress scmAddress) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        RetryPolicy connectionRetryPolicy = RetryPolicies.failoverOnNetworkException((int)0);
        return (ScmBlockLocationProtocolPB)RPC.getProtocolProxy(ScmBlockLocationProtocolPB.class, (long)this.scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)this.ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)this.scmClientConfig.getRpcTimeOut()), (RetryPolicy)connectionRetryPolicy).getProxy();
    }

    public RetryPolicy getSCMBlockLocationRetryPolicy() {
        return new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception e, int retry, int failover, boolean b) {
                if (SCMHAUtils.checkRetriableWithNoFailoverException((Exception)e)) {
                    SCMBlockLocationFailoverProxyProvider.this.setUpdatedLeaderNodeID();
                } else {
                    SCMBlockLocationFailoverProxyProvider.this.performFailoverToAssignedLeader(null, e);
                }
                return SCMHAUtils.getRetryAction((int)failover, (int)retry, (Exception)e, (int)SCMBlockLocationFailoverProxyProvider.this.maxRetryCount, (long)SCMBlockLocationFailoverProxyProvider.this.getRetryInterval());
            }
        };
    }

    public synchronized int getCurrentProxyIndex() {
        return this.currentProxyIndex;
    }

    public synchronized void setUpdatedLeaderNodeID() {
        this.updatedLeaderNodeID = this.getCurrentProxySCMNodeId();
    }
}

