/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.keys;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCodec {
    public static final String PRIVATE_KEY = "PRIVATE KEY";
    public static final String PUBLIC_KEY = "PUBLIC KEY";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(KeyCodec.class);
    private final Path location;
    private final SecurityConfig securityConfig;
    private final Set<PosixFilePermission> dirPermissionSet = Stream.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE).collect(Collectors.toSet());
    private final Set<PosixFilePermission> filePermissionSet = Stream.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE).collect(Collectors.toSet());
    private BooleanSupplier isPosixFileSystem;

    public KeyCodec(SecurityConfig config, String component) {
        this.securityConfig = config;
        this.isPosixFileSystem = KeyCodec::isPosix;
        this.location = this.securityConfig.getKeyLocation(component);
    }

    public KeyCodec(SecurityConfig config, Path keyDir) {
        this.securityConfig = config;
        this.isPosixFileSystem = KeyCodec::isPosix;
        this.location = keyDir;
        if (!this.location.toFile().exists() && !this.location.toFile().mkdirs()) {
            throw new RuntimeException("Failed to create directory " + this.location);
        }
    }

    private static boolean isPosix() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    @VisibleForTesting
    public Set<PosixFilePermission> getDirPermissionSet() {
        return this.dirPermissionSet;
    }

    public Set<PosixFilePermission> getFilePermissionSet() {
        return this.filePermissionSet;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    @VisibleForTesting
    public void setIsPosixFileSystem(BooleanSupplier isPosixFileSystem) {
        this.isPosixFileSystem = isPosixFileSystem;
    }

    public void writeKey(KeyPair keyPair) throws IOException {
        this.writeKey(this.location, keyPair, this.securityConfig.getPrivateKeyFileName(), this.securityConfig.getPublicKeyFileName(), false);
    }

    public void writePrivateKey(PrivateKey key) throws IOException {
        File privateKeyFile = Paths.get(this.location.toString(), this.securityConfig.getPrivateKeyFileName()).toFile();
        if (Files.exists(privateKeyFile.toPath(), new LinkOption[0])) {
            throw new IOException("Private key already exist.");
        }
        try (PemWriter privateKeyWriter = new PemWriter((Writer)new FileWriterWithEncoding(privateKeyFile, DEFAULT_CHARSET));){
            privateKeyWriter.writeObject((PemObjectGenerator)new PemObject(PRIVATE_KEY, key.getEncoded()));
        }
        Files.setPosixFilePermissions(privateKeyFile.toPath(), this.filePermissionSet);
    }

    public void writePublicKey(PublicKey key) throws IOException {
        File publicKeyFile = Paths.get(this.location.toString(), this.securityConfig.getPublicKeyFileName()).toFile();
        if (Files.exists(publicKeyFile.toPath(), new LinkOption[0])) {
            throw new IOException("Public key already exist.");
        }
        try (PemWriter keyWriter = new PemWriter((Writer)new FileWriterWithEncoding(publicKeyFile, DEFAULT_CHARSET));){
            keyWriter.writeObject((PemObjectGenerator)new PemObject(PUBLIC_KEY, key.getEncoded()));
        }
        Files.setPosixFilePermissions(publicKeyFile.toPath(), this.filePermissionSet);
    }

    public void writeKey(KeyPair keyPair, boolean overwrite) throws IOException {
        this.writeKey(this.location, keyPair, this.securityConfig.getPrivateKeyFileName(), this.securityConfig.getPublicKeyFileName(), overwrite);
    }

    public void writeKey(Path basePath, KeyPair keyPair, boolean overwrite) throws IOException {
        this.writeKey(basePath, keyPair, this.securityConfig.getPrivateKeyFileName(), this.securityConfig.getPublicKeyFileName(), overwrite);
    }

    private PKCS8EncodedKeySpec readKey(Path basePath, String keyFileName) throws IOException {
        byte[] pemContent;
        File fileName = Paths.get(basePath.toString(), keyFileName).toFile();
        String keyData = FileUtils.readFileToString((File)fileName, (Charset)DEFAULT_CHARSET);
        try (PemReader pemReader = new PemReader((Reader)new StringReader(keyData));){
            PemObject keyObject = pemReader.readPemObject();
            pemContent = keyObject.getContent();
        }
        return new PKCS8EncodedKeySpec(pemContent);
    }

    public PrivateKey readPrivateKey(Path basePath, String privateKeyFileName) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        PKCS8EncodedKeySpec encodedKeySpec = this.readKey(basePath, privateKeyFileName);
        KeyFactory keyFactory = KeyFactory.getInstance(this.securityConfig.getKeyAlgo());
        return keyFactory.generatePrivate(encodedKeySpec);
    }

    public PublicKey readPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        return this.readPublicKey(this.location.toAbsolutePath(), this.securityConfig.getPublicKeyFileName());
    }

    public PublicKey readPublicKey(Path basePath, String publicKeyFileName) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        PKCS8EncodedKeySpec encodedKeySpec = this.readKey(basePath, publicKeyFileName);
        KeyFactory keyFactory = KeyFactory.getInstance(this.securityConfig.getKeyAlgo());
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKeySpec.getEncoded()));
    }

    public PrivateKey readPrivateKey() throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        return this.readPrivateKey(this.location.toAbsolutePath(), this.securityConfig.getPrivateKeyFileName());
    }

    private synchronized void writeKey(Path basePath, KeyPair keyPair, String privateKeyFileName, String publicKeyFileName, boolean force) throws IOException {
        this.checkPreconditions(basePath);
        File privateKeyFile = Paths.get(basePath.toString(), privateKeyFileName).toFile();
        File publicKeyFile = Paths.get(basePath.toString(), publicKeyFileName).toFile();
        this.checkKeyFile(privateKeyFile, force, publicKeyFile);
        try (PemWriter privateKeyWriter = new PemWriter((Writer)new FileWriterWithEncoding(privateKeyFile, DEFAULT_CHARSET));){
            privateKeyWriter.writeObject((PemObjectGenerator)new PemObject(PRIVATE_KEY, keyPair.getPrivate().getEncoded()));
        }
        var9_9 = null;
        try (PemWriter publicKeyWriter = new PemWriter((Writer)new FileWriterWithEncoding(publicKeyFile, DEFAULT_CHARSET));){
            publicKeyWriter.writeObject((PemObjectGenerator)new PemObject(PUBLIC_KEY, keyPair.getPublic().getEncoded()));
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        Files.setPosixFilePermissions(privateKeyFile.toPath(), this.filePermissionSet);
        Files.setPosixFilePermissions(publicKeyFile.toPath(), this.filePermissionSet);
    }

    private void checkKeyFile(File privateKeyFile, boolean force, File publicKeyFile) throws IOException {
        if (privateKeyFile.exists() && force && !privateKeyFile.delete()) {
            throw new IOException("Unable to delete private key file.");
        }
        if (publicKeyFile.exists() && force && !publicKeyFile.delete()) {
            throw new IOException("Unable to delete public key file.");
        }
        if (privateKeyFile.exists()) {
            throw new IOException("Private Key file already exists.");
        }
        if (publicKeyFile.exists()) {
            throw new IOException("Public Key file already exists.");
        }
    }

    private void checkPreconditions(Path basePath) throws IOException {
        Preconditions.checkNotNull((Object)basePath, (Object)"Base path cannot be null");
        if (!this.isPosixFileSystem.getAsBoolean()) {
            LOG.error("Keys cannot be stored securely without POSIX file system support for now.");
            throw new IOException("Unsupported File System for pem file.");
        }
        if (Files.exists(basePath, new LinkOption[0])) {
            Files.setPosixFilePermissions(basePath, this.dirPermissionSet);
        } else {
            boolean success = basePath.toFile().mkdirs();
            if (!success) {
                LOG.error("Unable to create the directory for the location. Location: {}", (Object)basePath);
                throw new IOException("Unable to create the directory for the location. Location:" + basePath);
            }
            Files.setPosixFilePermissions(basePath, this.dirPermissionSet);
        }
    }
}

