/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DBDefinition {
    public static final Logger LOG = LoggerFactory.getLogger(DBDefinition.class);

    public String getName();

    public String getLocationConfigKey();

    default public File getDBLocation(ConfigurationSource conf) {
        return ServerUtils.getDirectoryFromConfig((ConfigurationSource)conf, (String)this.getLocationConfigKey(), (String)this.getName());
    }

    public Iterable<DBColumnFamilyDefinition<?, ?>> getColumnFamilies();

    public List<DBColumnFamilyDefinition<?, ?>> getColumnFamilies(String var1);

    default public DBColumnFamilyDefinition<?, ?> getColumnFamily(String name) {
        List<DBColumnFamilyDefinition<?, ?>> list = this.getColumnFamilies(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("Multi-valued: The name " + name + " maps to multiple values " + list + " in " + this.getName());
        }
        return list.get(0);
    }

    public static abstract class WithMap
    implements WithMapInterface {
        private final Map<String, DBColumnFamilyDefinition<?, ?>> map;

        protected WithMap(Map<String, DBColumnFamilyDefinition<?, ?>> map) {
            this.map = map;
        }

        @Override
        public final Map<String, DBColumnFamilyDefinition<?, ?>> getMap() {
            return this.map;
        }
    }

    public static interface WithMapInterface
    extends DBDefinition {
        public Map<String, DBColumnFamilyDefinition<?, ?>> getMap();

        default public Collection<DBColumnFamilyDefinition<?, ?>> getColumnFamilies() {
            return this.getMap().values();
        }

        @Override
        default public List<DBColumnFamilyDefinition<?, ?>> getColumnFamilies(String name) {
            DBColumnFamilyDefinition<?, ?> d = this.getMap().get(name);
            return d != null ? Collections.singletonList(d) : Collections.emptyList();
        }
    }
}

