/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.TenantOp;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.multitenant.AuthorizerLock;
import org.apache.hadoop.ozone.om.multitenant.MultiTenantAccessController;
import org.apache.hadoop.ozone.om.multitenant.OzoneOwnerPrincipal;
import org.apache.hadoop.ozone.om.multitenant.Tenant;
import org.apache.hadoop.ozone.om.service.OMRangerBGSyncService;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface OMMultiTenantManager {
    public static final String OZONE_TENANT_RANGER_POLICY_DESCRIPTION = "Created by Ozone. WARNING: Changes will be lost when this tenant is deleted.";
    public static final String OZONE_TENANT_RANGER_ROLE_DESCRIPTION = "Managed by Ozone. WARNING: Changes will be overridden. Use Ozone tenant CLI to manage users in this tenant role instead.";

    public void start() throws IOException;

    public void stop() throws IOException;

    public OMRangerBGSyncService getOMRangerBGSyncService();

    public OMMetadataManager getOmMetadataManager();

    public TenantOp getAuthorizerOp();

    public TenantOp getCacheOp();

    public String getUserNameGivenAccessId(String var1);

    public static String getDefaultAccessId(String tenantId, String userPrincipal) {
        return String.valueOf(tenantId) + "$" + userPrincipal;
    }

    public boolean isTenantAdmin(UserGroupInformation var1, String var2, boolean var3);

    public TenantUserList listUsersInTenant(String var1, String var2) throws IOException;

    public Optional<String> getTenantForAccessID(String var1) throws IOException;

    public static String getDefaultUserRoleName(String tenantId) {
        return String.valueOf(tenantId) + "-UserRole";
    }

    public static String getDefaultAdminRoleName(String tenantId) {
        return String.valueOf(tenantId) + "-AdminRole";
    }

    public static String getDefaultBucketNamespacePolicyName(String tenantId) {
        return String.valueOf(tenantId) + "-VolumeAccess";
    }

    public static String getDefaultBucketPolicyName(String tenantId) {
        return String.valueOf(tenantId) + "-BucketAccess";
    }

    public void checkAdmin() throws OMException;

    public void checkTenantAdmin(String var1, boolean var2) throws OMException;

    public void checkTenantExistence(String var1) throws OMException;

    public String getTenantVolumeName(String var1) throws IOException;

    public String getTenantUserRoleName(String var1) throws IOException;

    public String getTenantAdminRoleName(String var1) throws IOException;

    public Tenant getTenantFromDBById(String var1) throws IOException;

    public boolean isUserAccessIdPrincipalOrTenantAdmin(String var1, UserGroupInformation var2) throws IOException;

    public boolean isTenantEmpty(String var1) throws IOException;

    public static boolean checkAndEnableMultiTenancy(OzoneManager ozoneManager, OzoneConfiguration conf) {
        String rangerService;
        Logger logger = OzoneManager.LOG;
        boolean isS3MultiTenancyEnabled = conf.getBoolean("ozone.om.multitenancy.enabled", false);
        boolean devSkipMTCheck = conf.getBoolean("ozone.om.tenant.dev.skip.ranger", false);
        if (!isS3MultiTenancyEnabled || devSkipMTCheck) {
            return isS3MultiTenancyEnabled;
        }
        if (!ozoneManager.isSecurityEnabled()) {
            isS3MultiTenancyEnabled = false;
            logger.error("Ozone security is required to enable S3 Multi-Tenancy");
        } else if (!SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            isS3MultiTenancyEnabled = false;
            logger.error("Kerberos authentication is required to enable S3 Multi-Tenancy");
        }
        String rangerAddress = conf.get("ozone.om.ranger.https-address");
        if (StringUtils.isBlank((CharSequence)rangerAddress)) {
            isS3MultiTenancyEnabled = false;
            logger.error("{} is required to enable S3 Multi-Tenancy but not set", (Object)"ozone.om.ranger.https-address");
        }
        if (StringUtils.isBlank((CharSequence)(rangerService = conf.get("ozone.om.ranger.service")))) {
            isS3MultiTenancyEnabled = false;
            logger.error("{} is required to enable S3 Multi-Tenancy but not set", (Object)"ozone.om.ranger.service");
        }
        String fallbackUsername = conf.get("ozone.om.ranger.https.admin.api.user");
        String fallbackPassword = conf.get("ozone.om.ranger.https.admin.api.passwd");
        if (fallbackUsername != null && fallbackPassword != null) {
            logger.warn("Detected clear text username and password override configs. These will be used to authenticate to Ranger Admin Server instead of using the recommended Kerberos principal and keytab authentication method. This is NOT recommended on a production cluster.");
        } else {
            String rangerPw;
            String omKerbPrinc = conf.get("ozone.om.kerberos.principal");
            if (StringUtils.isBlank((CharSequence)omKerbPrinc)) {
                isS3MultiTenancyEnabled = false;
                logger.error("{} is required to enable S3 Multi-Tenancy but not set", (Object)"ozone.om.kerberos.principal");
            }
            if (StringUtils.isBlank((CharSequence)(rangerPw = conf.get("ozone.om.kerberos.keytab.file")))) {
                isS3MultiTenancyEnabled = false;
                logger.error("{} is required to enable S3 Multi-Tenancy but not set", (Object)"ozone.om.kerberos.keytab.file");
            }
            if (!new File(rangerPw).isFile()) {
                logger.error("{} = '{}' file path doesn't exist or is not a file", (Object)"ozone.om.kerberos.keytab.file", (Object)rangerPw);
            }
        }
        if (!isS3MultiTenancyEnabled) {
            throw new RuntimeException("Failed to meet one or more requirements to enable S3 Multi-Tenancy");
        }
        return true;
    }

    public static MultiTenantAccessController.Policy getDefaultVolumeAccessPolicy(String tenantId, String volumeName, String userRoleName, String adminRoleName) throws IOException {
        String volumePolicyName = OMMultiTenantManager.getDefaultBucketNamespacePolicyName(tenantId);
        return new MultiTenantAccessController.Policy.Builder().setName(volumePolicyName).addVolume(volumeName).setDescription(OZONE_TENANT_RANGER_POLICY_DESCRIPTION).addLabel("OzoneTenant").addRoleAcl(userRoleName, Arrays.asList(MultiTenantAccessController.Acl.allow(IAccessAuthorizer.ACLType.READ), MultiTenantAccessController.Acl.allow(IAccessAuthorizer.ACLType.LIST), MultiTenantAccessController.Acl.allow(IAccessAuthorizer.ACLType.READ_ACL))).addRoleAcl(adminRoleName, Collections.singletonList(MultiTenantAccessController.Acl.allow(IAccessAuthorizer.ACLType.ALL))).build();
    }

    public static MultiTenantAccessController.Policy getDefaultBucketAccessPolicy(String tenantId, String volumeName, String userRoleName) throws IOException {
        String bucketPolicyName = OMMultiTenantManager.getDefaultBucketPolicyName(tenantId);
        return new MultiTenantAccessController.Policy.Builder().setName(bucketPolicyName).addVolume(volumeName).addBucket("*").setDescription(OZONE_TENANT_RANGER_POLICY_DESCRIPTION).addLabel("OzoneTenant").addRoleAcl(userRoleName, Collections.singletonList(MultiTenantAccessController.Acl.allow(IAccessAuthorizer.ACLType.CREATE))).addUserAcl(new OzoneOwnerPrincipal().getName(), Collections.singletonList(MultiTenantAccessController.Acl.allow(IAccessAuthorizer.ACLType.ALL))).build();
    }

    public AuthorizerLock getAuthorizerLock();
}

