/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutVersionManager;

public class OMStorage
extends Storage {
    static final String ERROR_OM_IS_ALREADY_INITIALIZED = "OM is already initialized.";
    static final String ERROR_UNEXPECTED_OM_NODE_ID_TEMPLATE = "OM NodeId: %s does not match existing nodeId from VERSION file: %s";
    static final String ERROR_STORAGE_NOT_INITIALIZED = "OM Storage is not initialized yet.";
    static final String STORAGE_DIR = "om";
    static final String OM_ID = "omUuid";
    static final String OM_CERT_SERIAL_ID = "omCertSerialId";
    static final String OM_NODE_ID = "nodeId";

    public OMStorage(OzoneConfiguration conf) throws IOException {
        super(HddsProtos.NodeType.OM, OMStorage.getOmDbDir((ConfigurationSource)conf), STORAGE_DIR, OMStorage.getInitLayoutVersion((OzoneConfiguration)conf, (String)"ozone.om.init.default.layout.version", OMLayoutVersionManager::maxLayoutVersion));
    }

    public void setOmCertSerialId(String certSerialId) throws IOException {
        this.getStorageInfo().setProperty(OM_CERT_SERIAL_ID, certSerialId);
    }

    public void unsetOmCertSerialId() {
        this.getStorageInfo().unsetProperty(OM_CERT_SERIAL_ID);
    }

    public void setOmId(String omId) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException(ERROR_OM_IS_ALREADY_INITIALIZED);
        }
        this.getStorageInfo().setProperty(OM_ID, omId);
    }

    public void setOmNodeId(String nodeId) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException(ERROR_OM_IS_ALREADY_INITIALIZED);
        }
        this.getStorageInfo().setProperty(OM_NODE_ID, nodeId);
    }

    public void validateOrPersistOmNodeId(String expectedNodeId) throws IOException {
        if (this.getState() != Storage.StorageState.INITIALIZED) {
            throw new IOException(ERROR_STORAGE_NOT_INITIALIZED);
        }
        String ourValue = this.getOmNodeId();
        if (ourValue != null && !ourValue.equals(expectedNodeId)) {
            String msg = String.format(ERROR_UNEXPECTED_OM_NODE_ID_TEMPLATE, expectedNodeId, ourValue);
            throw new IOException(msg);
        }
        this.getStorageInfo().setProperty(OM_NODE_ID, expectedNodeId);
        this.persistCurrentState();
    }

    public String getOmId() {
        return this.getStorageInfo().getProperty(OM_ID);
    }

    public String getOmNodeId() {
        return this.getStorageInfo().getProperty(OM_NODE_ID);
    }

    public String getOmCertSerialId() {
        return this.getStorageInfo().getProperty(OM_CERT_SERIAL_ID);
    }

    protected Properties getNodeProperties() {
        String omId = this.getOmId();
        if (omId == null) {
            omId = UUID.randomUUID().toString();
        }
        Properties omProperties = new Properties();
        omProperties.setProperty(OM_ID, omId);
        String nodeId = this.getOmNodeId();
        if (nodeId != null) {
            omProperties.setProperty(OM_NODE_ID, nodeId);
        }
        if (this.getOmCertSerialId() != null) {
            omProperties.setProperty(OM_CERT_SERIAL_ID, this.getOmCertSerialId());
        }
        return omProperties;
    }

    public static File getOmDbDir(ConfigurationSource conf) {
        return ServerUtils.getDBPath((ConfigurationSource)conf, (String)"ozone.om.db.dirs");
    }
}

