/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.service.SnapshotDiffCleanupService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotCache;
import org.apache.hadoop.ozone.om.snapshot.SnapshotDiffManager;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.ozone.rocksdiff.RocksDBCheckpointDiffer;
import org.apache.ratis.util.function.CheckedFunction;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OmSnapshotManager
implements AutoCloseable {
    public static final String OM_HARDLINK_FILE = "hardLinkFile";
    public static final Logger LOG = LoggerFactory.getLogger(OmSnapshotManager.class);
    private static final long DB_TABLE_ITER_LOOP_THRESHOLD_NS = 100000L;
    private final OzoneManager ozoneManager;
    private final SnapshotDiffManager snapshotDiffManager;
    private final SnapshotCache snapshotCache;
    private final ManagedRocksDB snapshotDiffDb;
    public static final String DELIMITER = "-";
    public static final String SNAP_DIFF_JOB_TABLE_NAME = "snap-diff-job-table";
    public static final String SNAP_DIFF_REPORT_TABLE_NAME = "snap-diff-report-table";
    private static final String SNAP_DIFF_PURGED_JOB_TABLE_NAME = "snap-diff-purged-job-table";
    private final long diffCleanupServiceInterval;
    private final int maxOpenSstFilesInSnapshotDb;
    private final ManagedColumnFamilyOptions columnFamilyOptions;
    private final ManagedDBOptions options;
    private final List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    private final List<ColumnFamilyHandle> columnFamilyHandles;
    private final SnapshotDiffCleanupService snapshotDiffCleanupService;
    private final int maxPageSize;
    private final int softCacheSize;

    public OmSnapshotManager(OzoneManager ozoneManager) {
        ColumnFamilyHandle snapDiffPurgedJobCf;
        ColumnFamilyHandle snapDiffReportCf;
        ColumnFamilyHandle snapDiffJobCf;
        boolean isFilesystemSnapshotEnabled = ozoneManager.isFilesystemSnapshotEnabled();
        LOG.info("Ozone filesystem snapshot feature is {}.", (Object)(isFilesystemSnapshotEnabled ? "enabled" : "disabled"));
        if (!isFilesystemSnapshotEnabled && !this.canDisableFsSnapshot(ozoneManager.getMetadataManager())) {
            throw new RuntimeException("Ozone Manager is refusing to start upbecause filesystem snapshot feature is disabled in config whilethere are still snapshots remaining in the system (including the ones that are marked as deleted but not yet cleaned up by the background worker thread). Please set config ozone.filesystem.snapshot.enabled to true and try to start this Ozone Manager again.");
        }
        this.options = new ManagedDBOptions();
        this.options.setCreateIfMissing(true);
        this.columnFamilyOptions = new ManagedColumnFamilyOptions();
        this.columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>();
        CodecRegistry codecRegistry = OmSnapshotManager.createCodecRegistryForSnapDiff();
        this.maxPageSize = ozoneManager.getConfiguration().getInt("ozone.om.snapshot.diff.max.page.size", 1000);
        this.maxOpenSstFilesInSnapshotDb = ozoneManager.getConfiguration().getInt("ozone.om.snapshot.db.max.open.files", 100);
        String dbPath = this.getDbPath(ozoneManager.getConfiguration());
        try {
            this.columnFamilyDescriptors.add(new ColumnFamilyDescriptor(StringUtils.string2Bytes((String)DBStoreBuilder.DEFAULT_COLUMN_FAMILY_NAME), (ColumnFamilyOptions)new ManagedColumnFamilyOptions((ColumnFamilyOptions)this.columnFamilyOptions)));
            this.columnFamilyDescriptors.addAll(this.getExitingColumnFamilyDescriptors(dbPath));
            this.snapshotDiffDb = this.createRocksDbForSnapshotDiff(this.options, dbPath, this.columnFamilyDescriptors, this.columnFamilyHandles);
            snapDiffJobCf = this.getOrCreateColumnFamily(SNAP_DIFF_JOB_TABLE_NAME, this.columnFamilyDescriptors, this.columnFamilyHandles);
            snapDiffReportCf = this.getOrCreateColumnFamily(SNAP_DIFF_REPORT_TABLE_NAME, this.columnFamilyDescriptors, this.columnFamilyHandles);
            snapDiffPurgedJobCf = this.getOrCreateColumnFamily(SNAP_DIFF_PURGED_JOB_TABLE_NAME, this.columnFamilyDescriptors, this.columnFamilyHandles);
            this.dropUnknownColumnFamilies(this.columnFamilyHandles);
        }
        catch (RuntimeException exception) {
            this.close();
            throw exception;
        }
        this.ozoneManager = ozoneManager;
        RocksDBCheckpointDiffer differ = ozoneManager.getMetadataManager().getStore().getRocksDBCheckpointDiffer();
        this.softCacheSize = ozoneManager.getConfiguration().getInt("ozone.om.snapshot.cache.max.size", 10);
        CacheLoader<UUID, OmSnapshot> loader = this.createCacheLoader();
        RemovalListener cfr_ignored_0 = notification -> {
            try {
                String snapshotTableKey = (String)notification.getKey();
                OmSnapshot omSnapshot = (OmSnapshot)notification.getValue();
                if (omSnapshot == null) {
                    throw new IllegalStateException("Unexpected: OmSnapshot is null");
                }
                LOG.debug("Closing OmSnapshot '{}' due to {}", (Object)snapshotTableKey, (Object)notification.getCause());
                omSnapshot.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close OmSnapshot: {}", notification.getKey(), (Object)e);
            }
        };
        long cacheCleanupServiceInterval = ozoneManager.getConfiguration().getTimeDuration("ozone.om.snapshot.cache.cleanup.service.run.interval", OMConfigKeys.OZONE_OM_SNAPSHOT_CACHE_CLEANUP_SERVICE_RUN_INTERVAL_DEFAULT, TimeUnit.MILLISECONDS);
        this.snapshotCache = new SnapshotCache(loader, this.softCacheSize, ozoneManager.getMetrics(), cacheCleanupServiceInterval);
        this.snapshotDiffManager = new SnapshotDiffManager(this.snapshotDiffDb, differ, ozoneManager, snapDiffJobCf, snapDiffReportCf, this.columnFamilyOptions, codecRegistry);
        this.diffCleanupServiceInterval = ozoneManager.getConfiguration().getTimeDuration("ozone.om.snapshot.diff.cleanup.service.run.interval", OMConfigKeys.OZONE_OM_SNAPSHOT_DIFF_CLEANUP_SERVICE_RUN_INTERVAL_DEFAULT, TimeUnit.MILLISECONDS);
        long diffCleanupServiceTimeout = ozoneManager.getConfiguration().getTimeDuration("ozone.om.snapshot.diff.cleanup.service.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_DIFF_CLEANUP_SERVICE_TIMEOUT_DEFAULT, TimeUnit.MILLISECONDS);
        if (ozoneManager.isFilesystemSnapshotEnabled()) {
            this.snapshotDiffCleanupService = new SnapshotDiffCleanupService(this.diffCleanupServiceInterval, diffCleanupServiceTimeout, ozoneManager, this.snapshotDiffDb, snapDiffJobCf, snapDiffPurgedJobCf, snapDiffReportCf, codecRegistry);
            this.snapshotDiffCleanupService.start();
        } else {
            this.snapshotDiffCleanupService = null;
        }
    }

    @VisibleForTesting
    public boolean canDisableFsSnapshot(OMMetadataManager ommm) {
        boolean isSnapshotInfoTableEmpty;
        try {
            isSnapshotInfoTableEmpty = ommm.getSnapshotInfoTable().isEmpty();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to check SnapshotInfoTable emptiness", e);
        }
        return isSnapshotInfoTableEmpty;
    }

    private CacheLoader<UUID, OmSnapshot> createCacheLoader() {
        return new CacheLoader<UUID, OmSnapshot>(){

            @Nonnull
            public OmSnapshot load(@Nonnull UUID snapshotId) throws IOException {
                OmMetadataManagerImpl snapshotMetadataManager;
                String snapshotTableKey = ((OmMetadataManagerImpl)OmSnapshotManager.this.ozoneManager.getMetadataManager()).getSnapshotChainManager().getTableKey(snapshotId);
                if (snapshotTableKey == null) {
                    throw new IOException("No snapshot exist with snapshotId: " + snapshotId);
                }
                SnapshotInfo snapshotInfo = OmSnapshotManager.this.getSnapshotInfo(snapshotTableKey);
                CacheValue cacheValue = OmSnapshotManager.this.ozoneManager.getMetadataManager().getSnapshotInfoTable().getCacheValue(new CacheKey((Object)snapshotTableKey));
                boolean isSnapshotInCache = Objects.nonNull(cacheValue) && Objects.nonNull(cacheValue.getCacheValue());
                OzoneConfiguration conf = OmSnapshotManager.this.ozoneManager.getConfiguration();
                try {
                    snapshotMetadataManager = new OmMetadataManagerImpl(conf, snapshotInfo.getCheckpointDirName(), isSnapshotInCache, OmSnapshotManager.this.maxOpenSstFilesInSnapshotDb);
                }
                catch (IOException e) {
                    LOG.error("Failed to retrieve snapshot: {}", (Object)snapshotTableKey, (Object)e);
                    throw e;
                }
                try {
                    PrefixManagerImpl pm = new PrefixManagerImpl(snapshotMetadataManager, false);
                    KeyManagerImpl km = new KeyManagerImpl(OmSnapshotManager.this.ozoneManager, OmSnapshotManager.this.ozoneManager.getScmClient(), snapshotMetadataManager, conf, OmSnapshotManager.this.ozoneManager.getBlockTokenSecretManager(), OmSnapshotManager.this.ozoneManager.getKmsProvider(), OmSnapshotManager.this.ozoneManager.getPerfMetrics());
                    return new OmSnapshot(km, pm, OmSnapshotManager.this.ozoneManager, snapshotInfo.getVolumeName(), snapshotInfo.getBucketName(), snapshotInfo.getName(), snapshotInfo.getSnapshotId());
                }
                catch (Exception e) {
                    if (!snapshotMetadataManager.getStore().isClosed()) {
                        snapshotMetadataManager.getStore().close();
                    }
                    throw new IOException(e);
                }
            }
        };
    }

    private static CodecRegistry createCodecRegistryForSnapDiff() {
        CodecRegistry.Builder registry = CodecRegistry.newBuilder();
        registry.addCodec(SnapshotDiffReport.DiffReportEntry.class, SnapshotDiffReportOzone.getDiffReportEntryCodec());
        registry.addCodec(SnapshotDiffJob.class, SnapshotDiffJob.getCodec());
        return registry.build();
    }

    @VisibleForTesting
    public int getSnapshotCacheSize() {
        return this.snapshotCache == null ? 0 : this.snapshotCache.size();
    }

    public void invalidateCache() {
        if (this.snapshotCache != null) {
            this.snapshotCache.invalidateAll();
        }
    }

    public void invalidateCacheEntry(UUID key) {
        if (this.snapshotCache != null) {
            this.snapshotCache.invalidate(key);
        }
    }

    public static DBCheckpoint createOmSnapshotCheckpoint(OMMetadataManager omMetadataManager, SnapshotInfo snapshotInfo) throws IOException {
        DBCheckpoint dbCheckpoint;
        RDBStore store = (RDBStore)omMetadataManager.getStore();
        omMetadataManager.getTableLock("deletedDirectoryTable").writeLock().lock();
        omMetadataManager.getTableLock("deletedTable").writeLock().lock();
        boolean snapshotDirExist = false;
        try {
            String checkpointPrefix = store.getDbLocation().getName();
            Path snapshotDirPath = Paths.get(store.getSnapshotsParentDir(), String.valueOf(checkpointPrefix) + snapshotInfo.getCheckpointDir());
            if (Files.exists(snapshotDirPath, new LinkOption[0])) {
                snapshotDirExist = true;
                dbCheckpoint = new RocksDBCheckpoint(snapshotDirPath);
            } else {
                dbCheckpoint = store.getSnapshot(snapshotInfo.getCheckpointDirName());
            }
            OmSnapshotManager.deleteKeysFromDelKeyTableInSnapshotScope(omMetadataManager, snapshotInfo.getVolumeName(), snapshotInfo.getBucketName());
            OmSnapshotManager.deleteKeysFromDelDirTableInSnapshotScope(omMetadataManager, snapshotInfo.getVolumeName(), snapshotInfo.getBucketName());
        }
        finally {
            omMetadataManager.getTableLock("deletedTable").writeLock().unlock();
            omMetadataManager.getTableLock("deletedDirectoryTable").writeLock().unlock();
        }
        if (dbCheckpoint != null && snapshotDirExist) {
            LOG.info("Checkpoint : {} for snapshot {} already exists.", (Object)dbCheckpoint.getCheckpointLocation(), (Object)snapshotInfo.getName());
            return dbCheckpoint;
        }
        if (dbCheckpoint != null) {
            LOG.info("Created checkpoint : {} for snapshot {}", (Object)dbCheckpoint.getCheckpointLocation(), (Object)snapshotInfo.getName());
        }
        return dbCheckpoint;
    }

    private static void deleteKeysFromDelDirTableInSnapshotScope(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String keyPrefix = SnapshotUtils.getOzonePathKeyForFso(omMetadataManager, volumeName, bucketName);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TableIterator iter = omMetadataManager.getDeletedDirTable().iterator((Object)keyPrefix);){
            OmSnapshotManager.performOperationOnKeys(iter, entry -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing key {} from DeletedDirTable", entry.getKey());
                }
                omMetadataManager.getDeletedDirTable().delete((Object)((String)entry.getKey()));
                return null;
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public SnapshotDiffManager getSnapshotDiffManager() {
        return this.snapshotDiffManager;
    }

    @VisibleForTesting
    public SnapshotDiffCleanupService getSnapshotDiffCleanupService() {
        return this.snapshotDiffCleanupService;
    }

    private static void performOperationOnKeys(TableIterator<String, ? extends Table.KeyValue<String, ?>> keyIter, CheckedFunction<Table.KeyValue<String, ?>, Void, IOException> operationFunction) throws IOException {
        long startTime = System.nanoTime();
        while (keyIter.hasNext()) {
            Table.KeyValue entry = (Table.KeyValue)keyIter.next();
            operationFunction.apply((Object)entry);
        }
        long timeElapsed = System.nanoTime() - startTime;
        if (timeElapsed >= 100000L) {
            LOG.warn("Took {} ns to find endKey. Caller is {}", (Object)timeElapsed, (Object)new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName());
        }
    }

    private static void deleteRangeInclusive(Table<String, ?> table, String beginKey, String endKey) throws IOException {
        if (endKey != null) {
            table.deleteRange((Object)beginKey, (Object)endKey);
            table.delete((Object)endKey);
        }
    }

    private static void deleteKeysFromDelKeyTableInSnapshotScope(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String keyPrefix = omMetadataManager.getOzoneKey(volumeName, bucketName, "");
        Throwable throwable = null;
        Object var5_6 = null;
        try (TableIterator iter = omMetadataManager.getDeletedTable().iterator((Object)keyPrefix);){
            OmSnapshotManager.performOperationOnKeys(iter, entry -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing key {} from DeletedTable", entry.getKey());
                }
                omMetadataManager.getDeletedTable().delete((Object)((String)entry.getKey()));
                return null;
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ReferenceCounted<IOmMetadataReader> getActiveFsMetadataOrSnapshot(String volumeName, String bucketName, String keyName) throws IOException {
        if (keyName == null || !this.ozoneManager.isFilesystemSnapshotEnabled()) {
            return this.ozoneManager.getOmMetadataReader();
        }
        String[] keyParts = keyName.split("/");
        if (OmSnapshotManager.isSnapshotKey(keyParts)) {
            String snapshotName = keyParts[1];
            return this.getActiveSnapshot(volumeName, bucketName, snapshotName);
        }
        return this.ozoneManager.getOmMetadataReader();
    }

    public ReferenceCounted<OmSnapshot> getActiveSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        return this.getSnapshot(volumeName, bucketName, snapshotName, false);
    }

    public ReferenceCounted<OmSnapshot> getSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        return this.getSnapshot(volumeName, bucketName, snapshotName, true);
    }

    public ReferenceCounted<OmSnapshot> getSnapshot(String volumeName, String bucketName, String snapshotName, boolean skipActiveCheck) throws IOException {
        if (snapshotName == null || snapshotName.isEmpty()) {
            throw new OMException(OMException.ResultCodes.INVALID_KEY_NAME);
        }
        String snapshotTableKey = SnapshotInfo.getTableKey((String)volumeName, (String)bucketName, (String)snapshotName);
        return this.getSnapshot(snapshotTableKey, skipActiveCheck);
    }

    private ReferenceCounted<OmSnapshot> getSnapshot(String snapshotTableKey, boolean skipActiveCheck) throws IOException {
        SnapshotInfo snapshotInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, snapshotTableKey);
        if (!skipActiveCheck) {
            SnapshotUtils.checkSnapshotActive(snapshotInfo, false);
        }
        return this.snapshotCache.get(snapshotInfo.getSnapshotId());
    }

    public ReferenceCounted<OmSnapshot> getSnapshot(UUID snapshotId) throws IOException {
        return this.snapshotCache.get(snapshotId);
    }

    private SnapshotInfo getSnapshotInfo(String snapshotKey) throws IOException {
        SnapshotInfo snapshotInfo = (SnapshotInfo)this.ozoneManager.getMetadataManager().getSnapshotInfoTable().get((Object)snapshotKey);
        if (snapshotInfo == null) {
            snapshotInfo = (SnapshotInfo)this.ozoneManager.getMetadataManager().getSnapshotInfoTable().getSkipCache((Object)snapshotKey);
        }
        if (snapshotInfo == null) {
            throw new OMException("Snapshot '" + snapshotKey + "' is not found.", OMException.ResultCodes.INVALID_SNAPSHOT_ERROR);
        }
        return snapshotInfo;
    }

    public static String getSnapshotPrefix(String snapshotName) {
        return ".snapshot/" + snapshotName + "/";
    }

    public static Path getSnapshotPath(OMMetadataManager omMetadataManager, SnapshotInfo snapshotInfo) {
        RDBStore store = (RDBStore)omMetadataManager.getStore();
        String checkpointPrefix = store.getDbLocation().getName();
        return Paths.get(store.getSnapshotsParentDir(), String.valueOf(checkpointPrefix) + snapshotInfo.getCheckpointDir());
    }

    public static String getSnapshotPath(OzoneConfiguration conf, SnapshotInfo snapshotInfo) {
        return OMStorage.getOmDbDir((ConfigurationSource)conf) + "/" + "db.snapshots/checkpointState" + "/" + "om.db" + snapshotInfo.getCheckpointDirName();
    }

    public static boolean isSnapshotKey(String[] keyParts) {
        return keyParts.length > 1 && keyParts[0].compareTo(".snapshot") == 0;
    }

    public CancelSnapshotDiffResponse cancelSnapshotDiff(String volume, String bucket, String fromSnapshot, String toSnapshot) throws IOException {
        return this.snapshotDiffManager.cancelSnapshotDiff(volume, bucket, fromSnapshot, toSnapshot);
    }

    public SnapshotDiffResponse getSnapshotDiffReport(String volume, String bucket, String fromSnapshot, String toSnapshot, String token, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        this.validateSnapshotsExistAndActive(volume, bucket, fromSnapshot, toSnapshot);
        if (Objects.equals(fromSnapshot, toSnapshot)) {
            SnapshotDiffReportOzone diffReport = new SnapshotDiffReportOzone(SnapshotDiffManager.getSnapshotRootPath(volume, bucket).toString(), volume, bucket, fromSnapshot, toSnapshot, Collections.emptyList(), null);
            return new SnapshotDiffResponse(diffReport, SnapshotDiffResponse.JobStatus.DONE, 0L);
        }
        int index = this.getIndexFromToken(token);
        if (pageSize <= 0 || pageSize > this.maxPageSize) {
            pageSize = this.maxPageSize;
        }
        SnapshotDiffResponse snapshotDiffReport = this.snapshotDiffManager.getSnapshotDiffReport(volume, bucket, fromSnapshot, toSnapshot, index, pageSize, forceFullDiff, disableNativeDiff);
        this.validateSnapshotsExistAndActive(volume, bucket, fromSnapshot, toSnapshot);
        return snapshotDiffReport;
    }

    public List<SnapshotDiffJob> getSnapshotDiffList(String volumeName, String bucketName, String jobStatus, boolean listAll) throws IOException {
        String snapshotPath;
        String volumeKey = this.ozoneManager.getMetadataManager().getVolumeKey(volumeName);
        String bucketKey = this.ozoneManager.getMetadataManager().getBucketKey(volumeName, bucketName);
        if (!this.ozoneManager.getMetadataManager().getVolumeTable().isExist((Object)volumeKey) || !this.ozoneManager.getMetadataManager().getBucketTable().isExist((Object)bucketKey)) {
            throw new IOException("Provided volume name " + volumeName + " or bucket name " + bucketName + " doesn't exist");
        }
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)this.ozoneManager.getMetadataManager();
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        if (snapshotChainManager.getSnapshotChainPath(snapshotPath = String.valueOf(volumeName) + "/" + bucketName) == null) {
            return new ArrayList<SnapshotDiffJob>();
        }
        return this.snapshotDiffManager.getSnapshotDiffJobList(volumeName, bucketName, jobStatus, listAll);
    }

    private void validateSnapshotsExistAndActive(String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName) throws IOException {
        SnapshotInfo fromSnapInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, fromSnapshotName);
        SnapshotInfo toSnapInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, toSnapshotName);
        SnapshotUtils.checkSnapshotActive(fromSnapInfo, false);
        SnapshotUtils.checkSnapshotActive(toSnapInfo, false);
    }

    private int getIndexFromToken(String token) throws IOException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            return 0;
        }
        try {
            int index = Integer.parseInt(token);
            if (index < 0) {
                throw new IOException("Passed token is invalid. Resend the request with valid token returned in previous request.");
            }
            return index;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Passed token is invalid. Resend the request with valid token returned in previous request.");
        }
    }

    private ManagedRocksDB createRocksDbForSnapshotDiff(ManagedDBOptions dbOptions, String dbPath, List<ColumnFamilyDescriptor> familyDescriptors, List<ColumnFamilyHandle> familyHandles) {
        try {
            return ManagedRocksDB.open((DBOptions)dbOptions, (String)dbPath, familyDescriptors, familyHandles);
        }
        catch (RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    private String getDbPath(OzoneConfiguration config) {
        File dbDirPath = ServerUtils.getDBPath((ConfigurationSource)config, (String)"ozone.om.snapshot.diff.db.dir");
        return Paths.get(dbDirPath.toString(), "db.snapdiff").toFile().getAbsolutePath();
    }

    private List<ColumnFamilyDescriptor> getExitingColumnFamilyDescriptors(String path) {
        try {
            return RocksDatabase.listColumnFamiliesEmptyOptions((String)path).stream().map(columnFamilyName -> new ColumnFamilyDescriptor(columnFamilyName, (ColumnFamilyOptions)new ManagedColumnFamilyOptions((ColumnFamilyOptions)this.columnFamilyOptions))).collect(Collectors.toList());
        }
        catch (RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    private ColumnFamilyHandle getOrCreateColumnFamily(String columnFamilyName, List<ColumnFamilyDescriptor> familyDescriptors, List<ColumnFamilyHandle> familyHandles) {
        int i = 0;
        while (i < familyDescriptors.size()) {
            String cfName = StringUtils.bytes2String((byte[])familyDescriptors.get(i).getName());
            if (columnFamilyName.equals(cfName)) {
                return familyHandles.get(i);
            }
            ++i;
        }
        try {
            ColumnFamilyDescriptor columnFamilyDescriptor = new ColumnFamilyDescriptor(StringUtils.string2Bytes((String)columnFamilyName), (ColumnFamilyOptions)this.columnFamilyOptions);
            ColumnFamilyHandle columnFamily = ((RocksDB)this.snapshotDiffDb.get()).createColumnFamily(columnFamilyDescriptor);
            familyHandles.add(columnFamily);
            familyDescriptors.add(columnFamilyDescriptor);
            return columnFamily;
        }
        catch (RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void dropUnknownColumnFamilies(List<ColumnFamilyHandle> familyHandles) {
        HashSet<String> allowedColumnFamilyOnStartUp = new HashSet<String>(Arrays.asList(DBStoreBuilder.DEFAULT_COLUMN_FAMILY_NAME, SNAP_DIFF_JOB_TABLE_NAME, SNAP_DIFF_REPORT_TABLE_NAME, SNAP_DIFF_PURGED_JOB_TABLE_NAME));
        try {
            for (ColumnFamilyHandle columnFamilyHandle : familyHandles) {
                String columnFamilyName = StringUtils.bytes2String((byte[])columnFamilyHandle.getName());
                if (allowedColumnFamilyOnStartUp.contains(columnFamilyName)) continue;
                SnapshotUtils.dropColumnFamilyHandle(this.snapshotDiffDb, columnFamilyHandle);
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeColumnFamilyOptions(ManagedColumnFamilyOptions managedColumnFamilyOptions) {
        Preconditions.checkArgument((!managedColumnFamilyOptions.isReused() ? 1 : 0) != 0);
        ManagedColumnFamilyOptions.closeDeeply((ColumnFamilyOptions)managedColumnFamilyOptions);
    }

    @Override
    public void close() {
        if (this.snapshotDiffManager != null) {
            this.snapshotDiffManager.close();
        }
        if (this.snapshotCache != null) {
            this.snapshotCache.close();
        }
        if (this.snapshotDiffCleanupService != null) {
            this.snapshotDiffCleanupService.shutdown();
        }
        if (this.columnFamilyHandles != null) {
            this.columnFamilyHandles.forEach(AbstractImmutableNativeReference::close);
        }
        if (this.snapshotDiffDb != null) {
            this.snapshotDiffDb.close();
        }
        if (this.columnFamilyDescriptors != null) {
            this.columnFamilyDescriptors.forEach(columnFamilyDescriptor -> this.closeColumnFamilyOptions((ManagedColumnFamilyOptions)columnFamilyDescriptor.getOptions()));
        }
        if (this.columnFamilyOptions != null) {
            this.closeColumnFamilyOptions(this.columnFamilyOptions);
        }
        if (this.options != null) {
            this.options.close();
        }
    }

    public long getDiffCleanupServiceInterval() {
        return this.diffCleanupServiceInterval;
    }
}

