/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import java.util.HashMap;
import java.util.Objects;

public class CachedTenantState {
    private final String tenantId;
    private final String tenantUserRoleName;
    private final String tenantAdminRoleName;
    private final HashMap<String, CachedAccessIdInfo> accessIdInfoMap;

    public String getTenantUserRoleName() {
        return this.tenantUserRoleName;
    }

    public String getTenantAdminRoleName() {
        return this.tenantAdminRoleName;
    }

    public CachedTenantState(String tenantId, String tenantUserRoleName, String tenantAdminRoleName) {
        this.tenantId = tenantId;
        this.tenantUserRoleName = tenantUserRoleName;
        this.tenantAdminRoleName = tenantAdminRoleName;
        this.accessIdInfoMap = new HashMap();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public HashMap<String, CachedAccessIdInfo> getAccessIdInfoMap() {
        return this.accessIdInfoMap;
    }

    public boolean isTenantEmpty() {
        return this.accessIdInfoMap.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof CachedTenantState) {
            CachedTenantState other = (CachedTenantState)object;
            return this.tenantId.equals(other.tenantId) && this.tenantUserRoleName.equals(other.tenantUserRoleName) && this.tenantAdminRoleName.equals(other.tenantAdminRoleName) && this.accessIdInfoMap.equals(other.accessIdInfoMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.tenantUserRoleName, this.tenantAdminRoleName);
    }

    public static class CachedAccessIdInfo {
        private final String userPrincipal;
        private boolean isAdmin;

        public CachedAccessIdInfo(String userPrincipal, boolean isAdmin) {
            this.userPrincipal = userPrincipal;
            this.isAdmin = isAdmin;
        }

        public String getUserPrincipal() {
            return this.userPrincipal;
        }

        public void setIsAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
        }

        public boolean getIsAdmin() {
            return this.isAdmin;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof CachedAccessIdInfo) {
                CachedAccessIdInfo other = (CachedAccessIdInfo)object;
                return this.isAdmin == other.isAdmin && this.userPrincipal.equals(other.userPrincipal);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.isAdmin, this.userPrincipal);
        }
    }
}

