/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.multitenant.MultiTenantAccessController;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.RangerClient;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerClientMultiTenantAccessController
implements MultiTenantAccessController {
    private static final Logger LOG = LoggerFactory.getLogger(RangerClientMultiTenantAccessController.class);
    private static final int HTTP_STATUS_CODE_UNAUTHORIZED = 401;
    private static final int HTTP_STATUS_CODE_BAD_REQUEST = 400;
    private final RangerClient client;
    private final String rangerServiceName;
    private final Map<IAccessAuthorizer.ACLType, String> aclToString = MultiTenantAccessController.getRangerAclStrings();
    private final Map<String, IAccessAuthorizer.ACLType> stringToAcl = new HashMap<String, IAccessAuthorizer.ACLType>();
    private final String omPrincipal;
    private final String shortName;

    public RangerClientMultiTenantAccessController(OzoneConfiguration conf) throws IOException {
        String passwordOrKeytab;
        String usernameOrPrincipal;
        String authType;
        this.aclToString.forEach((type, string) -> {
            IAccessAuthorizer.ACLType aCLType = this.stringToAcl.put((String)string, (IAccessAuthorizer.ACLType)type);
        });
        String rangerHttpsAddress = conf.get("ozone.om.ranger.https-address");
        Preconditions.checkNotNull((Object)rangerHttpsAddress);
        this.rangerServiceName = conf.get("ozone.om.ranger.service");
        Preconditions.checkNotNull((Object)this.rangerServiceName);
        String fallbackUsername = conf.get("ozone.om.ranger.https.admin.api.user");
        String fallbackPassword = conf.get("ozone.om.ranger.https.admin.api.passwd");
        if (fallbackUsername != null && fallbackPassword != null) {
            authType = UserGroupInformation.AuthenticationMethod.SIMPLE.name();
            usernameOrPrincipal = fallbackUsername;
            passwordOrKeytab = fallbackPassword;
            this.omPrincipal = fallbackUsername;
            this.shortName = fallbackUsername;
        } else {
            authType = UserGroupInformation.AuthenticationMethod.KERBEROS.name();
            String configuredOmPrincipal = conf.get("ozone.om.kerberos.principal");
            Preconditions.checkNotNull((Object)configuredOmPrincipal);
            this.omPrincipal = SecurityUtil.getServerPrincipal((String)configuredOmPrincipal, (String)OmUtils.getOmAddress((ConfigurationSource)conf).getHostName());
            String keytabPath = conf.get("ozone.om.kerberos.keytab.file");
            Preconditions.checkNotNull((Object)keytabPath);
            this.shortName = UserGroupInformation.createRemoteUser((String)this.omPrincipal).getShortUserName();
            usernameOrPrincipal = this.omPrincipal;
            passwordOrKeytab = keytabPath;
        }
        LOG.info("authType = {}, login user = {}", (Object)authType, (Object)usernameOrPrincipal);
        this.client = new RangerClient(rangerHttpsAddress, authType, usernameOrPrincipal, passwordOrKeytab, this.rangerServiceName, "ozone");
    }

    private void decodeRSEStatusCodes(RangerServiceException rse) {
        ClientResponse.Status status = rse.getStatus();
        if (status == null) {
            LOG.error("Request failure with no status provided.", (Throwable)rse);
        } else {
            switch (status.getStatusCode()) {
                case 401: {
                    LOG.error("Auth failure. Please double check Ranger-related configs");
                    break;
                }
                case 400: {
                    LOG.error("Request failure. If this is an assign-user operation, check if the user name exists in Ranger.");
                    break;
                }
                default: {
                    LOG.error("Other request failure. Status: {}", (Object)status);
                }
            }
        }
    }

    @Override
    public MultiTenantAccessController.Policy createPolicy(MultiTenantAccessController.Policy policy) throws IOException {
        RangerPolicy rangerPolicy;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending create request for policy {} to Ranger.", (Object)policy.getName());
        }
        try {
            rangerPolicy = this.client.createPolicy(this.toRangerPolicy(policy));
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        return this.fromRangerPolicy(rangerPolicy);
    }

    @Override
    public MultiTenantAccessController.Policy getPolicy(String policyName) throws IOException {
        RangerPolicy rangerPolicy;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending get request for policy {} to Ranger.", (Object)policyName);
        }
        try {
            rangerPolicy = this.client.getPolicy(this.rangerServiceName, policyName);
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        return this.fromRangerPolicy(rangerPolicy);
    }

    @Override
    public List<MultiTenantAccessController.Policy> getLabeledPolicies(String label) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending get request for policies with label {} to Ranger.", (Object)label);
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("serviceName", this.rangerServiceName);
        filterMap.put("policyLabelsPartial", label);
        try {
            return this.client.findPolicies(filterMap).stream().map(this::fromRangerPolicy).collect(Collectors.toList());
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
    }

    @Override
    public MultiTenantAccessController.Policy updatePolicy(MultiTenantAccessController.Policy policy) throws IOException {
        RangerPolicy rangerPolicy;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending update request for policy {} to Ranger.", (Object)policy.getName());
        }
        try {
            rangerPolicy = this.client.updatePolicy(this.rangerServiceName, policy.getName(), this.toRangerPolicy(policy));
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        return this.fromRangerPolicy(rangerPolicy);
    }

    @Override
    public void deletePolicy(String policyName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending delete request for policy {} to Ranger.", (Object)policyName);
        }
        try {
            this.client.deletePolicy(this.rangerServiceName, policyName);
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
    }

    @Override
    public MultiTenantAccessController.Role createRole(MultiTenantAccessController.Role role) throws IOException {
        RangerRole rangerRole;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending create request for role {} to Ranger.", (Object)role.getName());
        }
        try {
            rangerRole = this.client.createRole(this.rangerServiceName, RangerClientMultiTenantAccessController.toRangerRole(role, this.shortName));
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        return RangerClientMultiTenantAccessController.fromRangerRole(rangerRole);
    }

    @Override
    public MultiTenantAccessController.Role getRole(String roleName) throws IOException {
        RangerRole rangerRole;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending get request for role {} to Ranger.", (Object)roleName);
        }
        try {
            rangerRole = this.client.getRole(roleName, this.shortName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        return RangerClientMultiTenantAccessController.fromRangerRole(rangerRole);
    }

    @Override
    public MultiTenantAccessController.Role updateRole(long roleId, MultiTenantAccessController.Role role) throws IOException {
        RangerRole rangerRole;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending update request for role ID {} to Ranger.", (Object)roleId);
        }
        try {
            rangerRole = this.client.updateRole(roleId, RangerClientMultiTenantAccessController.toRangerRole(role, this.shortName));
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        return RangerClientMultiTenantAccessController.fromRangerRole(rangerRole);
    }

    @Override
    public void deleteRole(String roleName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending delete request for role {} to Ranger.", (Object)roleName);
        }
        try {
            this.client.deleteRole(roleName, this.shortName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
    }

    @Override
    public long getRangerServicePolicyVersion() throws IOException {
        RangerService rangerOzoneService;
        try {
            rangerOzoneService = this.client.getService(this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            this.decodeRSEStatusCodes(e);
            throw new IOException(e);
        }
        Long policyVersion = rangerOzoneService.getPolicyVersion();
        return policyVersion == null ? -1L : policyVersion;
    }

    private static List<RangerRole.RoleMember> toRangerRoleMembers(Map<String, Boolean> members) {
        return members.entrySet().stream().map(entry -> {
            String princ = (String)entry.getKey();
            boolean isRoleAdmin = (Boolean)entry.getValue();
            return new RangerRole.RoleMember(princ, isRoleAdmin);
        }).collect(Collectors.toList());
    }

    private static List<String> fromRangerRoleMembers(Collection<RangerRole.RoleMember> members) {
        return members.stream().map(rangerUser -> rangerUser.getName()).collect(Collectors.toList());
    }

    private static MultiTenantAccessController.Role fromRangerRole(RangerRole rangerRole) {
        return new MultiTenantAccessController.Role.Builder().setID(rangerRole.getId()).setName(rangerRole.getName()).setDescription(rangerRole.getDescription()).addUsers(RangerClientMultiTenantAccessController.fromRangerRoleMembers(rangerRole.getUsers())).setCreatedByUser(rangerRole.getCreatedByUser()).build();
    }

    private static RangerRole toRangerRole(MultiTenantAccessController.Role role, String createdByUser) {
        RangerRole rangerRole = new RangerRole();
        rangerRole.setName(role.getName());
        rangerRole.setCreatedByUser(createdByUser);
        if (!role.getUsersMap().isEmpty()) {
            rangerRole.setUsers(RangerClientMultiTenantAccessController.toRangerRoleMembers(role.getUsersMap()));
        }
        if (!role.getRolesMap().isEmpty()) {
            rangerRole.setRoles(RangerClientMultiTenantAccessController.toRangerRoleMembers(role.getRolesMap()));
        }
        if (role.getDescription().isPresent()) {
            rangerRole.setDescription(role.getDescription().get());
        }
        return rangerRole;
    }

    private MultiTenantAccessController.Policy fromRangerPolicy(RangerPolicy rangerPolicy) {
        MultiTenantAccessController.Policy.Builder policyBuilder = new MultiTenantAccessController.Policy.Builder();
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : rangerPolicy.getPolicyItems()) {
            ArrayList<MultiTenantAccessController.Acl> acls = new ArrayList<MultiTenantAccessController.Acl>();
            for (RangerPolicy.RangerPolicyItemAccess access : rangerPolicyItem.getAccesses()) {
                if (access.getIsAllowed().booleanValue()) {
                    acls.add(MultiTenantAccessController.Acl.allow(this.stringToAcl.get(access.getType())));
                    continue;
                }
                acls.add(MultiTenantAccessController.Acl.deny(this.stringToAcl.get(access.getType())));
            }
            for (String roleName : rangerPolicyItem.getRoles()) {
                policyBuilder.addRoleAcl(roleName, acls);
            }
        }
        for (Map.Entry entry : rangerPolicy.getResources().entrySet()) {
            String resourceType = (String)entry.getKey();
            List resourceNames = ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues();
            switch (resourceType) {
                case "volume": {
                    policyBuilder.addVolumes(resourceNames);
                    break;
                }
                case "bucket": {
                    policyBuilder.addBuckets(resourceNames);
                    break;
                }
                case "key": {
                    policyBuilder.addKeys(resourceNames);
                    break;
                }
                default: {
                    LOG.warn("Pulled Ranger policy with unknown resource type '{}' with names '{}'", (Object)resourceType, (Object)String.join((CharSequence)",", resourceNames));
                }
            }
        }
        policyBuilder.setName(rangerPolicy.getName()).setId(rangerPolicy.getId()).setDescription(rangerPolicy.getDescription()).addLabels(rangerPolicy.getPolicyLabels());
        return policyBuilder.build();
    }

    private RangerPolicy toRangerPolicy(MultiTenantAccessController.Policy policy) {
        RangerPolicy.RangerPolicyItemAccess access;
        RangerPolicy.RangerPolicyItem item;
        RangerPolicy rangerPolicy = new RangerPolicy();
        rangerPolicy.setName(policy.getName());
        rangerPolicy.setService(this.rangerServiceName);
        rangerPolicy.setPolicyLabels(new ArrayList<String>(policy.getLabels()));
        HashMap<String, RangerPolicy.RangerPolicyResource> resource = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (!policy.getVolumes().isEmpty()) {
            RangerPolicy.RangerPolicyResource volumeResources = new RangerPolicy.RangerPolicyResource();
            volumeResources.setValues(new ArrayList<String>(policy.getVolumes()));
            resource.put("volume", volumeResources);
        }
        if (!policy.getBuckets().isEmpty()) {
            RangerPolicy.RangerPolicyResource bucketResources = new RangerPolicy.RangerPolicyResource();
            bucketResources.setValues(new ArrayList<String>(policy.getBuckets()));
            resource.put("bucket", bucketResources);
        }
        if (!policy.getKeys().isEmpty()) {
            RangerPolicy.RangerPolicyResource keyResources = new RangerPolicy.RangerPolicyResource();
            keyResources.setValues(new ArrayList<String>(policy.getKeys()));
            resource.put("key", keyResources);
        }
        rangerPolicy.setService(this.rangerServiceName);
        rangerPolicy.setResources(resource);
        if (policy.getDescription().isPresent()) {
            rangerPolicy.setDescription(policy.getDescription().get());
        }
        for (Map.Entry<String, Collection<MultiTenantAccessController.Acl>> userAcls : policy.getUserAcls().entrySet()) {
            item = new RangerPolicy.RangerPolicyItem();
            item.setUsers(Collections.singletonList(userAcls.getKey()));
            for (MultiTenantAccessController.Acl acl : userAcls.getValue()) {
                access = new RangerPolicy.RangerPolicyItemAccess();
                access.setIsAllowed(Boolean.valueOf(acl.isAllowed()));
                access.setType(this.aclToString.get(acl.getAclType()));
                item.getAccesses().add(access);
            }
            rangerPolicy.getPolicyItems().add(item);
        }
        for (Map.Entry<String, Collection<MultiTenantAccessController.Acl>> roleAcls : policy.getRoleAcls().entrySet()) {
            item = new RangerPolicy.RangerPolicyItem();
            item.setRoles(Collections.singletonList(roleAcls.getKey()));
            for (MultiTenantAccessController.Acl acl : roleAcls.getValue()) {
                access = new RangerPolicy.RangerPolicyItemAccess();
                access.setIsAllowed(Boolean.valueOf(acl.isAllowed()));
                access.setType(this.aclToString.get(acl.getAclType()));
                item.getAccesses().add(access);
            }
            rangerPolicy.getPolicyItems().add(item);
        }
        return rangerPolicy;
    }
}

